/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.IoUtil;
import org.xipki.util.exception.InvalidConfException;

public abstract class DbWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DbWorker.class);
    protected final AtomicBoolean stopMe = new AtomicBoolean(false);
    protected final DataSourceWrapper datasource;
    private Exception exception;

    public DbWorker(DataSourceFactory datasourceFactory, String dbConfFile) throws InvalidConfException, IOException {
        ConfigurableProperties props = DbPorter.getDbConfProperties(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]));
        this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, props);
    }

    public final Exception exception() {
        return this.exception;
    }

    public void setStopMe(boolean stopMe) {
        this.stopMe.set(stopMe);
    }

    protected abstract void close0();

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Exception ex) {
            LOG.error("exception thrown", (Throwable)ex);
            this.exception = ex;
        }
        finally {
            this.datasource.close();
            this.close0();
        }
    }

    protected abstract void run0() throws Exception;
}

