/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.mgmt.db.diffdb.DbType;
import org.xipki.ca.mgmt.db.diffdb.DigestDiffReporter;
import org.xipki.ca.mgmt.db.diffdb.RefDigestReader;
import org.xipki.ca.mgmt.db.diffdb.TargetDigestReader;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ProcessLog;
import org.xipki.util.StringUtil;

class DigestDiff {
    private static final Logger LOG = LoggerFactory.getLogger(DigestDiff.class);
    private final DataSourceWrapper refDatasource;
    private final boolean revokedOnly;
    private final DataSourceWrapper targetDatasource;
    private final DbType refDbType;
    private final DbType targetDbType;
    private final HashAlgo certhashAlgo;
    private Set<byte[]> includeCaCerts;
    private final String reportDirName;
    private final AtomicBoolean stopMe;
    private final int numPerSelect;
    private final int numTargetThreads;

    public DigestDiff(DataSourceWrapper refDatasource, DataSourceWrapper targetDatasource, String reportDirName, boolean revokedOnly, AtomicBoolean stopMe, int numPerSelect, int numThreads) throws DataAccessException {
        this.refDatasource = (DataSourceWrapper)Args.notNull((Object)refDatasource, (String)"refDatasource");
        this.revokedOnly = revokedOnly;
        this.targetDatasource = (DataSourceWrapper)Args.notNull((Object)targetDatasource, (String)"targetDatasource");
        this.reportDirName = (String)Args.notNull((Object)reportDirName, (String)"reportDirName");
        this.stopMe = (AtomicBoolean)Args.notNull((Object)stopMe, (String)"stopMe");
        this.numPerSelect = Args.positive((int)numPerSelect, (String)"numPerSelect");
        this.refDbType = DigestDiff.detectDbType(refDatasource);
        this.targetDbType = DigestDiff.detectDbType(targetDatasource);
        if (this.refDbType == DbType.XIPKI_OCSP_v4) {
            HashAlgo targetAlgo;
            HashAlgo refAlgo = DigestDiff.detectOcspDbCerthashAlgo(refDatasource);
            if (refAlgo != (targetAlgo = DigestDiff.detectOcspDbCerthashAlgo(targetDatasource))) {
                throw new IllegalArgumentException(StringUtil.concatObjects((Object)"Could not compare OCSP datasources with different CERTHASH_ALGO: refDataSource (", (Object[])new Object[]{refAlgo, ") and targetDataSource (", targetAlgo, ")"}));
            }
            this.certhashAlgo = refAlgo;
        } else {
            this.certhashAlgo = HashAlgo.SHA1;
        }
        this.numTargetThreads = Math.min(numThreads, targetDatasource.getMaximumPoolSize() - 1);
        if (this.numTargetThreads != numThreads) {
            LOG.info("reduce the numTargetThreads from {} to {}", (Object)this.numTargetThreads, (Object)this.numTargetThreads);
        }
    }

    public Set<byte[]> isIncludeCaCerts() {
        return this.includeCaCerts;
    }

    public void setIncludeCaCerts(Set<byte[]> includeCaCerts) {
        this.includeCaCerts = includeCaCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff() throws Exception {
        Map<Integer, byte[]> caIdCertMap = DigestDiff.getCas(this.targetDatasource, this.targetDbType);
        LinkedList<Integer> refCaIds = new LinkedList<Integer>();
        String refSql = this.refDbType == DbType.XIPKI_OCSP_v4 ? "SELECT ID FROM ISSUER" : "SELECT ID FROM CA";
        PreparedStatement refStmt = null;
        try {
            refStmt = this.refDatasource.prepareStatement(refSql);
            ResultSet refRs = null;
            try {
                refRs = refStmt.executeQuery();
                while (refRs.next()) {
                    int id = refRs.getInt(1);
                    refCaIds.add(id);
                }
            }
            catch (SQLException ex) {
                throw this.refDatasource.translate(refSql, ex);
            }
            finally {
                this.refDatasource.releaseResources((Statement)refStmt, refRs);
            }
        }
        finally {
            this.refDatasource.releaseResources((Statement)refStmt, null);
        }
        int numBlocksToRead = this.numTargetThreads * 3 / 2;
        for (Integer refCaId : refCaIds) {
            RefDigestReader refReader = RefDigestReader.getInstance(this.refDatasource, this.refDbType, this.certhashAlgo, refCaId, numBlocksToRead, this.numPerSelect, this.stopMe);
            this.diffSingleCa(refReader, caIdCertMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffSingleCa(RefDigestReader refReader, Map<Integer, byte[]> caIdCertBytesMap) throws IOException, InterruptedException {
        X509Cert caCert = refReader.getCaCert();
        byte[] caCertBytes = caCert.getEncoded();
        if (this.includeCaCerts != null && !this.includeCaCerts.isEmpty()) {
            boolean include = false;
            for (byte[] m : this.includeCaCerts) {
                if (!Arrays.equals(m, caCertBytes)) continue;
                include = true;
                break;
            }
            if (!include) {
                System.out.println("skipped CA " + refReader.getCaSubjectName());
            }
        }
        String commonName = caCert.getCommonName();
        File caReportDir = new File(this.reportDirName, "ca-" + commonName);
        int idx = 2;
        while (caReportDir.exists()) {
            caReportDir = new File(this.reportDirName, "ca-" + commonName + "-" + idx++);
        }
        DigestDiffReporter reporter = new DigestDiffReporter(caReportDir.getPath(), caCertBytes);
        Integer caId = null;
        for (Map.Entry<Integer, byte[]> entry : caIdCertBytesMap.entrySet()) {
            if (!Arrays.equals(caCertBytes, entry.getValue())) continue;
            caId = entry.getKey();
        }
        if (caId == null) {
            reporter.addNoCaMatch();
            refReader.close();
            reporter.close();
            return;
        }
        TargetDigestReader target = null;
        try {
            reporter.start();
            ProcessLog processLog = new ProcessLog((long)refReader.getTotalAccount());
            System.out.println("Processing certificates of CA \n\t'" + refReader.getCaSubjectName() + "'");
            processLog.printHeader();
            target = new TargetDigestReader(this.revokedOnly, processLog, refReader, reporter, this.targetDatasource, this.targetDbType, this.certhashAlgo, caId, this.numPerSelect, this.numTargetThreads, this.stopMe);
            target.awaitTerminiation();
            processLog.printTrailer();
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            reporter.addError("Exception thrown: " + ex.getClass().getName() + ": " + ex.getMessage());
            LOG.error("exception in diffSingleCa", (Throwable)ex);
        }
        finally {
            reporter.close();
            refReader.close();
            if (target != null) {
                target.close();
            }
        }
    }

    private static Map<Integer, byte[]> getCas(DataSourceWrapper datasource, DbType dbType) throws DataAccessException {
        String sql = "SELECT ID,CERT FROM " + (dbType == DbType.XIPKI_OCSP_v4 ? "ISSUER" : "CA");
        PreparedStatement stmt = datasource.prepareStatement(sql);
        HashMap<Integer, byte[]> caIdCertMap = new HashMap<Integer, byte[]>(5);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
            while (rs.next()) {
                caIdCertMap.put(rs.getInt("ID"), Base64.decodeFast((String)rs.getString("CERT")));
            }
        }
        catch (SQLException ex) {
            throw datasource.translate(sql, ex);
        }
        finally {
            datasource.releaseResources((Statement)stmt, rs);
        }
        return caIdCertMap;
    }

    public static DbType detectDbType(DataSourceWrapper datasource) throws DataAccessException {
        Connection conn = datasource.getConnection();
        try {
            String dbSchemaVersion = datasource.getFirstStringValue(null, "DBSCHEMA", "VALUE2", "WHERE NAME='VERSION'");
            if (datasource.tableExists(conn, "CA")) {
                if ("4".equals(dbSchemaVersion)) {
                    DbType dbType = DbType.XIPKI_CA_v4;
                    return dbType;
                }
                if ("5".equals(dbSchemaVersion)) {
                    DbType dbType = DbType.XIPKI_CA_v5;
                    return dbType;
                }
                if ("6".equals(dbSchemaVersion)) {
                    DbType dbType = DbType.XIPKI_CA_v6;
                    return dbType;
                }
                if ("7".equals(dbSchemaVersion)) {
                    DbType dbType = DbType.XIPKI_CA_v7;
                    return dbType;
                }
                if ("8".equals(dbSchemaVersion)) {
                    DbType dbType = DbType.XIPKI_CA_v8;
                    return dbType;
                }
                throw new IllegalArgumentException("unknown DBSCHEMA version " + dbSchemaVersion);
            }
            if (datasource.tableExists(conn, "ISSUER")) {
                if ("4".equals(dbSchemaVersion)) {
                    DbType dbType = DbType.XIPKI_OCSP_v4;
                    return dbType;
                }
                throw new IllegalArgumentException("unknown DBSCHEMA version " + dbSchemaVersion);
            }
            throw new IllegalArgumentException("unknown database schema");
        }
        finally {
            datasource.returnConnection(conn);
        }
    }

    public static HashAlgo detectOcspDbCerthashAlgo(DataSourceWrapper datasource) throws DataAccessException {
        String str = datasource.getFirstStringValue(null, "DBSCHEMA", "VALUE2", "NAME='CERTHASH_ALGO'");
        try {
            return HashAlgo.getInstance((String)str);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

