/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.diffdb;

import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.mgmt.db.diffdb.IdentifiedDigestEntry;

interface QueueEntry {
    public static final EndOfQueue END_OF_QUEUE = new EndOfQueue();

    public static class DigestEntrySet
    implements QueueEntry,
    Comparable<DigestEntrySet> {
        private final long startId;
        private Exception exception;
        private final List<IdentifiedDigestEntry> entries = new LinkedList<IdentifiedDigestEntry>();

        public DigestEntrySet(long startId) {
            this.startId = startId;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        void addEntry(IdentifiedDigestEntry entry) {
            this.entries.add(entry);
        }

        long getStartId() {
            return this.startId;
        }

        List<IdentifiedDigestEntry> getEntries() {
            return this.entries;
        }

        @Override
        public int compareTo(DigestEntrySet obj) {
            return Long.compare(this.startId, obj.startId);
        }
    }

    public static class EndOfQueue
    implements QueueEntry {
        private EndOfQueue() {
        }
    }
}

