/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.HashAlgo;
import org.xipki.util.SqlUtil;

abstract class AbstractOcspCertstoreDbImporter
extends DbPorter {
    protected static final String MSG_CERTS_FINISHED = "certs.finished";
    protected static final String SQL_ADD_CRLINFO = SqlUtil.buildInsertSql((String)"CRL_INFO", (String)"ID,NAME,INFO");
    protected static final String SQL_ADD_ISSUER = SqlUtil.buildInsertSql((String)"ISSUER", (String)"ID,SUBJECT,NBEFORE,NAFTER,S1C,REV_INFO,CERT,CRL_ID");
    protected static final String SQL_ADD_CERT = SqlUtil.buildInsertSql((String)"CERT", (String)"ID,IID,SN,LUPDATE,NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,SUBJECT,CRL_ID");

    AbstractOcspCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
    }

    protected String sha1(byte[] data) {
        return HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{data});
    }

    protected void deleteCertGreaterThan(long id, Logger log) {
        this.deleteFromTableWithLargerId("CERT", "ID", id, log);
    }
}

