/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.mgmt.db.port.IdentifiedDbObject;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class CaCertstore
extends ValidableConf {
    private int version;
    private int countCrls;
    private int countCerts;
    private List<Ca> cas;
    private List<IdName> requestors;
    private List<IdName> profiles;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCountCrls() {
        return this.countCrls;
    }

    public void setCountCrls(int countCrls) {
        this.countCrls = countCrls;
    }

    public int getCountCerts() {
        return this.countCerts;
    }

    public void setCountCerts(int countCerts) {
        this.countCerts = countCerts;
    }

    public List<Ca> getCas() {
        return this.cas;
    }

    public void setCas(List<Ca> cas) {
        this.cas = cas;
    }

    public List<IdName> getRequestors() {
        return this.requestors;
    }

    public void setRequestors(List<IdName> requestors) {
        this.requestors = requestors;
    }

    public List<IdName> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<IdName> profiles) {
        this.profiles = profiles;
    }

    public void validate() throws InvalidConfException {
    }

    public static class Ca
    extends IdName {
        private String revInfo;
        private byte[] cert;

        public byte[] getCert() {
            return this.cert;
        }

        public void setCert(byte[] cert) {
            this.cert = cert;
        }

        public String getRevInfo() {
            return this.revInfo;
        }

        public void setRevInfo(String revInfo) {
            this.revInfo = revInfo;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Ca.notNull((Object)this.cert, (String)"cert");
        }
    }

    public static class IdName
    extends ValidableConf {
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            IdName.notBlank((String)this.name, (String)"name");
        }
    }

    public static class Crls
    extends ValidableConf {
        private List<Crl> crls;

        public List<Crl> getCrls() {
            return this.crls;
        }

        public void setCrls(List<Crl> crls) {
            this.crls = crls;
        }

        public void add(Crl crl) {
            if (this.crls == null) {
                this.crls = new LinkedList<Crl>();
            }
            this.crls.add(crl);
        }

        public void validate() throws InvalidConfException {
            Crls.validate(this.crls, (Collection[])new Collection[0]);
        }
    }

    public static class Crl
    extends IdentifiedDbObject {
        private Integer caId;
        private String crlNo;
        private String file;
        private Integer crlScope;

        public Integer getCaId() {
            return this.caId;
        }

        public void setCaId(Integer caId) {
            this.caId = caId;
        }

        public String getCrlNo() {
            return this.crlNo;
        }

        public void setCrlNo(String crlNo) {
            this.crlNo = crlNo;
        }

        public Integer getCrlScope() {
            return this.crlScope;
        }

        public void setCrlScope(Integer crlScope) {
            this.crlScope = crlScope;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Crl.notNull((Object)this.caId, (String)"caId");
            Crl.notBlank((String)this.crlNo, (String)"crlNo");
            Crl.notBlank((String)this.file, (String)"file");
            Crl.notNull((Object)this.crlScope, (String)"crlScope");
        }
    }

    public static class Certs
    extends ValidableConf {
        private List<Cert> certs;

        public List<Cert> getCerts() {
            if (this.certs == null) {
                this.certs = new LinkedList<Cert>();
            }
            return this.certs;
        }

        public void setCerts(List<Cert> certs) {
            this.certs = certs;
        }

        public void add(Cert cert) {
            this.getCerts().add(cert);
        }

        public void validate() throws InvalidConfException {
            Certs.validate(this.certs, (Collection[])new Collection[0]);
        }
    }

    public static class Cert
    extends IdentifiedDbObject {
        private String file;
        private String privateKeyFile;
        private Integer caId;
        private String sn;
        private Integer pid;
        private Integer rid;
        private Boolean ee;
        private Long update;
        private Integer rev;
        private Integer rr;
        private Long rt;
        private Long rit;
        private String tid;
        private Long fpRs;
        private Integer crlScope;
        private String rs;

        public Integer getCaId() {
            return this.caId;
        }

        public void setCaId(Integer caId) {
            this.caId = caId;
        }

        public String getSn() {
            return this.sn;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public Boolean getEe() {
            return this.ee;
        }

        public void setEe(Boolean ee) {
            this.ee = ee;
        }

        public Integer getPid() {
            return this.pid;
        }

        public void setPid(Integer pid) {
            this.pid = pid;
        }

        public Integer getRid() {
            return this.rid;
        }

        public void setRid(Integer rid) {
            this.rid = rid;
        }

        public Long getUpdate() {
            return this.update;
        }

        public void setUpdate(Long update) {
            this.update = update;
        }

        public Integer getRev() {
            return this.rev;
        }

        public void setRev(Integer rev) {
            this.rev = rev;
        }

        public Integer getRr() {
            return this.rr;
        }

        public void setRr(Integer rr) {
            this.rr = rr;
        }

        public Long getRt() {
            return this.rt;
        }

        public void setRt(Long rt) {
            this.rt = rt;
        }

        public Long getRit() {
            return this.rit;
        }

        public void setRit(Long rit) {
            this.rit = rit;
        }

        public String getTid() {
            return this.tid;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }

        public Long getFpRs() {
            return this.fpRs;
        }

        public void setFpRs(Long fpRs) {
            this.fpRs = fpRs;
        }

        public String getRs() {
            return this.rs;
        }

        public void setRs(String rs) {
            this.rs = rs;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        public Integer getCrlScope() {
            return this.crlScope;
        }

        public void setCrlScope(Integer crlScope) {
            this.crlScope = crlScope;
        }

        @Override
        public void validate() throws InvalidConfException {
            super.validate();
            Cert.notNull((Object)this.caId, (String)"caId");
            Cert.notNull((Object)this.ee, (String)"ee");
            Cert.notBlank((String)this.file, (String)"file");
            Cert.notNull((Object)this.pid, (String)"pid");
            Cert.notNull((Object)this.rev, (String)"rev");
            Cert.notNull((Object)this.rid, (String)"rid");
            Cert.notBlank((String)this.sn, (String)"sn");
            Cert.notNull((Object)this.update, (String)"update");
            Cert.notNull((Object)this.crlScope, (String)"crlScope");
            if (this.rev == 1) {
                Cert.notNull((Object)this.rr, (String)"rr");
                Cert.notNull((Object)this.rt, (String)"rt");
            }
        }
    }
}

