/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.mgmt.db.port.CaCertstore;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.FpIdCalculator;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.ProcessLog;
import org.xipki.util.SqlUtil;
import org.xipki.util.StringUtil;

class CaCertstoreDbImporter
extends DbPorter {
    private static final Logger LOG = LoggerFactory.getLogger(CaCertstoreDbImporter.class);
    private static final String SQL_ADD_CERT = SqlUtil.buildInsertSql((String)"CERT", (String)"ID,LUPDATE,SN,SUBJECT,FP_S,FP_RS,FP_SAN,NBEFORE,NAFTER,REV,RR,RT,RIT,PID,CA_ID,RID,EE,TID,SHA1,REQ_SUBJECT,CRL_SCOPE,CERT,PRIVATE_KEY");
    private static final String SQL_ADD_CRL = SqlUtil.buildInsertSql((String)"CRL", (String)"ID,CA_ID,CRL_NO,THISUPDATE,NEXTUPDATE,DELTACRL,BASECRL_NO,CRL_SCOPE,SHA1,CRL");
    private final int numCertsPerCommit;

    CaCertstoreDbImporter(DataSourceWrapper datasource, String srcDir, int numCertsPerCommit, boolean resume, AtomicBoolean stopMe) throws Exception {
        super(datasource, srcDir, stopMe);
        this.numCertsPerCommit = Args.positive((int)numCertsPerCommit, (String)"numCertsPerCommit");
        File processLogFile = new File(this.baseDir, "import.process");
        if (resume) {
            if (!processLogFile.exists()) {
                throw new Exception("could not process with '--resume' option");
            }
        } else if (processLogFile.exists()) {
            throw new Exception("please either specify '--resume' option or delete the file " + processLogFile.getPath() + " first");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importRequestorOrProfile(List<CaCertstore.IdName> entries, String tblName) throws DataAccessException {
        System.out.print("    importing table " + tblName + " ... ");
        String sql = SqlUtil.buildInsertSql((String)tblName, (String)"ID,NAME");
        boolean succ = false;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.IdName entry : entries) {
                try {
                    ps.setInt(1, entry.getId());
                    ps.setString(2, entry.getName());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import " + tblName + " with NAME=" + entry.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCa(List<CaCertstore.Ca> cas) throws DataAccessException, CertificateException {
        System.out.print("    importing table CA ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA", (String)"ID,NAME,SUBJECT,REV_INFO,CERT");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaCertstore.Ca ca : cas) {
                try {
                    X509Cert cert = X509Util.parseCert((byte[])ca.getCert());
                    int idx = 1;
                    ps.setInt(idx++, ca.getId());
                    ps.setString(idx++, ca.getName().toLowerCase());
                    ps.setString(idx++, X509Util.cutX500Name((X500Name)cert.getSubject(), (int)this.maxX500nameLen));
                    ps.setString(idx++, ca.getRevInfo());
                    ps.setString(idx, Base64.encodeToString((byte[])ca.getCert()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CA with NAME=" + ca.getName());
                    throw this.translate(sql, ex);
                }
                catch (CertificateException ex) {
                    System.err.println("could not import CA with NAME=" + ca.getName());
                    throw ex;
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    public void importToDb() throws Exception {
        CaCertstore certstore = (CaCertstore)((Object)CaJson.parseObject((Path)Paths.get(this.baseDir, "ca-certstore.json"), CaCertstore.class));
        certstore.validate();
        if (certstore.getVersion() > 2) {
            throw new Exception("could not import Certstore greater than 2: " + certstore.getVersion());
        }
        this.importRequestorOrProfile(certstore.getProfiles(), "PROFILE");
        this.importRequestorOrProfile(certstore.getRequestors(), "REQUESTOR");
        this.importCa(certstore.getCas());
        File processLogFile = new File(this.baseDir, "import.process");
        System.out.println("importing CA certstore to database");
        try {
            byte[] content;
            DbPorter.CaDbEntryType typeProcessedInLastProcess = null;
            Integer numProcessedInLastProcess = null;
            Long idProcessedInLastProcess = null;
            if (processLogFile.exists() && (content = IoUtil.read((File)processLogFile)).length > 5) {
                StringTokenizer st = new StringTokenizer(StringUtil.toUtf8String((byte[])content), ":");
                String type = st.nextToken();
                typeProcessedInLastProcess = DbPorter.CaDbEntryType.valueOf(type);
                numProcessedInLastProcess = Integer.parseInt(st.nextToken());
                idProcessedInLastProcess = Long.parseLong(st.nextToken());
            }
            boolean entriesFinished = false;
            if (typeProcessedInLastProcess != null && idProcessedInLastProcess == -1L) {
                numProcessedInLastProcess = 0;
                idProcessedInLastProcess = 0L;
                if (typeProcessedInLastProcess == DbPorter.CaDbEntryType.CRL) {
                    typeProcessedInLastProcess = DbPorter.CaDbEntryType.CERT;
                } else if (typeProcessedInLastProcess == DbPorter.CaDbEntryType.CERT) {
                    entriesFinished = true;
                } else {
                    throw new IllegalStateException("unsupported CaDbEntryType " + typeProcessedInLastProcess);
                }
            }
            if (!entriesFinished) {
                DbPorter.CaDbEntryType[] types;
                Exception exception = null;
                if (DbPorter.CaDbEntryType.CRL == typeProcessedInLastProcess || typeProcessedInLastProcess == null) {
                    exception = this.importEntries(DbPorter.CaDbEntryType.CRL, certstore, processLogFile, numProcessedInLastProcess, idProcessedInLastProcess);
                    typeProcessedInLastProcess = null;
                    numProcessedInLastProcess = null;
                    idProcessedInLastProcess = null;
                }
                for (DbPorter.CaDbEntryType type : types = new DbPorter.CaDbEntryType[]{DbPorter.CaDbEntryType.CERT}) {
                    if (exception != null || type != typeProcessedInLastProcess && typeProcessedInLastProcess != null) continue;
                    exception = this.importEntries(type, certstore, processLogFile, numProcessedInLastProcess, idProcessedInLastProcess);
                }
                if (exception != null) {
                    throw exception;
                }
            }
            IoUtil.deleteFile0((File)processLogFile);
        }
        catch (Exception ex) {
            System.err.println("could not import CA certstore to database");
            throw ex;
        }
        System.out.println(" imported CA certstore to database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Exception importEntries(DbPorter.CaDbEntryType type, CaCertstore certstore, File processLogFile, Integer numProcessedInLastProcess, Long idProcessedInLastProcess) {
        String tablesText = "table " + type.getTableName();
        try {
            String sql;
            long total;
            int numProcessedBefore = 0;
            long minId = 1L;
            if (idProcessedInLastProcess != null) {
                minId = idProcessedInLastProcess + 1L;
                numProcessedBefore = numProcessedInLastProcess;
            }
            this.deleteFromTableWithLargerId(type.getTableName(), "ID", minId - 1L, LOG);
            if (type == DbPorter.CaDbEntryType.CERT) {
                total = certstore.getCountCerts();
                sql = SQL_ADD_CERT;
            } else {
                if (type != DbPorter.CaDbEntryType.CRL) throw new IllegalStateException("unsupported DbEntryType " + type);
                total = certstore.getCountCrls();
                sql = SQL_ADD_CRL;
            }
            long remainingTotal = total - (long)numProcessedBefore;
            ProcessLog processLog = new ProcessLog(remainingTotal);
            System.out.println("importing entries to " + tablesText + " from ID " + minId);
            processLog.printHeader();
            PreparedStatement stmt = null;
            try (DbPorter.DbPortFileNameIterator entriesFileIterator = new DbPorter.DbPortFileNameIterator(this.baseDir + File.separator + type.getDirName() + ".mf");){
                stmt = this.prepareStatement(sql);
                while (entriesFileIterator.hasNext()) {
                    String entriesFile;
                    block20: {
                        entriesFile = this.baseDir + File.separator + type.getDirName() + File.separator + entriesFileIterator.next();
                        int fromIdx = entriesFile.indexOf(45);
                        int toIdx = entriesFile.indexOf(".zip");
                        if (fromIdx != -1 && toIdx != -1) {
                            try {
                                long toId = Integer.parseInt(entriesFile.substring(fromIdx + 1, toIdx));
                                if (toId < minId) {
                                    continue;
                                }
                                break block20;
                            }
                            catch (Exception ex) {
                                LOG.warn("invalid file name '{}', but will still be processed", (Object)entriesFile);
                                break block20;
                            }
                        }
                        LOG.warn("invalid file name '{}', but will still be processed", (Object)entriesFile);
                    }
                    try {
                        long lastId = type == DbPorter.CaDbEntryType.CERT ? this.importCerts(entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql) : this.importCrls(entriesFile, minId, processLogFile, processLog, numProcessedBefore, stmt, sql);
                        minId = lastId + 1L;
                    }
                    catch (Exception ex) {
                        System.err.println("\ncould not import entries from file " + entriesFile + ".\nplease continue with the option '--resume'");
                        LOG.error("Exception", (Throwable)ex);
                        Exception exception = ex;
                        entriesFileIterator.close();
                        this.releaseResources(stmt, null);
                        return exception;
                    }
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null);
                throw throwable;
            }
            this.releaseResources(stmt, null);
            processLog.printTrailer();
            CaCertstoreDbImporter.echoToFile(type + ":" + ((long)numProcessedBefore + processLog.numProcessed()) + ":-1", processLogFile);
            System.out.println(" imported " + processLog.numProcessed() + " entries");
            return null;
        }
        catch (Exception ex) {
            System.err.println("\nimporting " + tablesText + " has been cancelled due to error,\nplease continue with the option '--resume'");
            LOG.error("Exception", (Throwable)ex);
            return ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCerts(String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        CaCertstore.Certs certs;
        DbPorter.CaDbEntryType type = DbPorter.CaDbEntryType.CERT;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        try {
            certs = (CaCertstore.Certs)((Object)CaJson.parseObjectAndClose((InputStream)zipFile.getInputStream(zipFile.getEntry("overview.json")), CaCertstore.Certs.class));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        certs.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            List<CaCertstore.Cert> list = certs.getCerts();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                ZipEntry keyZipEnty;
                TBSCertificate tbsCert;
                CaCertstore.Cert cert = list.get(i);
                if (this.stopMe.get()) {
                    throw new InterruptedException("interrupted by the user");
                }
                long id = cert.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                String filename = cert.getFile();
                byte[] encodedCert = IoUtil.readAllBytesAndClose((InputStream)zipFile.getInputStream(zipFile.getEntry(filename)));
                try {
                    tbsCert = Certificate.getInstance((Object)encodedCert).getTBSCertificate();
                }
                catch (RuntimeException ex) {
                    LOG.error("could not parse certificate in file {}", (Object)filename);
                    LOG.debug("could not parse certificate in file " + filename, (Throwable)ex);
                    throw new CertificateException(ex.getMessage(), ex);
                }
                String b64Sha1FpCert = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCert});
                String subjectText = X509Util.cutX500Name((X500Name)tbsCert.getSubject(), (int)this.maxX500nameLen);
                String privateKey = null;
                if (cert.getPrivateKeyFile() != null && (keyZipEnty = zipFile.getEntry(cert.getPrivateKeyFile())) != null) {
                    privateKey = new String(IoUtil.readAllBytesAndClose((InputStream)zipFile.getInputStream(keyZipEnty)));
                }
                try {
                    int idx = 1;
                    stmt.setLong(idx++, id);
                    stmt.setLong(idx++, cert.getUpdate());
                    stmt.setString(idx++, tbsCert.getSerialNumber().getPositiveValue().toString(16));
                    stmt.setString(idx++, subjectText);
                    long fpSubject = X509Util.fpCanonicalizedName((X500Name)tbsCert.getSubject());
                    stmt.setLong(idx++, fpSubject);
                    if (cert.getFpRs() != null) {
                        stmt.setLong(idx++, cert.getFpRs());
                    } else {
                        stmt.setNull(idx++, -5);
                    }
                    byte[] san = X509Util.getCoreExtValue((Extensions)tbsCert.getExtensions(), (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                    if (san != null) {
                        stmt.setLong(idx++, FpIdCalculator.hash((byte[])san));
                    } else {
                        stmt.setNull(idx++, -5);
                    }
                    stmt.setLong(idx++, DateUtil.toEpochSecond((Date)tbsCert.getStartDate().getDate()));
                    stmt.setLong(idx++, DateUtil.toEpochSecond((Date)tbsCert.getEndDate().getDate()));
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRev());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRr());
                    CaCertstoreDbImporter.setLong(stmt, idx++, cert.getRt());
                    CaCertstoreDbImporter.setLong(stmt, idx++, cert.getRit());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getPid());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getCaId());
                    CaCertstoreDbImporter.setInt(stmt, idx++, cert.getRid());
                    Extension extension = tbsCert.getExtensions().getExtension(Extension.basicConstraints);
                    boolean ee = true;
                    if (extension != null) {
                        ASN1Encodable asn1 = extension.getParsedValue();
                        ee = !BasicConstraints.getInstance((Object)asn1).isCA();
                    }
                    stmt.setInt(idx++, ee ? 1 : 0);
                    String tidS = null;
                    if (cert.getTid() != null) {
                        tidS = cert.getTid();
                    }
                    stmt.setString(idx++, tidS);
                    stmt.setString(idx++, b64Sha1FpCert);
                    stmt.setString(idx++, cert.getRs());
                    stmt.setInt(idx++, cert.getCrlScope());
                    stmt.setString(idx++, Base64.encodeToString((byte[])encodedCert));
                    stmt.setString(idx, privateKey);
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    throw this.translate(sql, ex);
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile(type + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long importCrls(String entriesZipFile, long minId, File processLogFile, ProcessLog processLog, int numProcessedInLastProcess, PreparedStatement stmt, String sql) throws Exception {
        CaCertstore.Crls crls;
        DbPorter.CaDbEntryType type = DbPorter.CaDbEntryType.CRL;
        int numEntriesPerCommit = Math.max(1, Math.round(type.getSqlBatchFactor() * (float)this.numCertsPerCommit));
        ZipFile zipFile = new ZipFile(new File(entriesZipFile));
        try {
            crls = (CaCertstore.Crls)((Object)CaJson.parseObjectAndClose((InputStream)zipFile.getInputStream(zipFile.getEntry("overview.json")), CaCertstore.Crls.class));
        }
        catch (Exception ex) {
            try {
                zipFile.close();
            }
            catch (Exception e2) {
                LOG.error("could not close ZIP file {}: {}", (Object)entriesZipFile, (Object)e2.getMessage());
                LOG.debug("could not close ZIP file " + entriesZipFile, (Throwable)e2);
            }
            throw ex;
        }
        crls.validate();
        this.disableAutoCommit();
        try {
            int numEntriesInBatch = 0;
            long lastSuccessfulEntryId = 0L;
            List<CaCertstore.Crl> list = crls.getCrls();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean isLastBlock;
                X509CRLHolder x509crl;
                CaCertstore.Crl crl = list.get(i);
                long id = crl.getId();
                if (id < minId) continue;
                ++numEntriesInBatch;
                String filename = crl.getFile();
                ZipEntry zipEnty = zipFile.getEntry(filename);
                byte[] encodedCrl = IoUtil.readAllBytesAndClose((InputStream)zipFile.getInputStream(zipEnty));
                String b64Sha1 = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCrl});
                try {
                    x509crl = X509Util.parseCrl((byte[])encodedCrl);
                }
                catch (Exception ex) {
                    LOG.error("could not parse CRL in file {}", (Object)filename);
                    LOG.debug("could not parse CRL in file " + filename, (Throwable)ex);
                    if (ex instanceof CRLException) {
                        throw ex;
                    }
                    throw new CRLException(ex.getMessage(), ex);
                }
                try {
                    Extensions extns = x509crl.getExtensions();
                    byte[] extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.cRLNumber);
                    if (extnValue == null) {
                        LOG.warn("CRL without CRL number, ignore it");
                        continue;
                    }
                    BigInteger crlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                    extnValue = X509Util.getCoreExtValue((Extensions)extns, (ASN1ObjectIdentifier)Extension.deltaCRLIndicator);
                    BigInteger baseCrlNumber = extnValue == null ? null : ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                    int idx = 1;
                    stmt.setLong(idx++, crl.getId());
                    stmt.setInt(idx++, crl.getCaId());
                    stmt.setLong(idx++, crlNumber.longValue());
                    stmt.setLong(idx++, DateUtil.toEpochSecond((Date)x509crl.getThisUpdate()));
                    if (x509crl.getNextUpdate() != null) {
                        stmt.setLong(idx++, DateUtil.toEpochSecond((Date)x509crl.getNextUpdate()));
                    } else {
                        stmt.setNull(idx++, 4);
                    }
                    if (baseCrlNumber == null) {
                        CaCertstoreDbImporter.setBoolean(stmt, idx++, false);
                        stmt.setNull(idx++, -5);
                    } else {
                        CaCertstoreDbImporter.setBoolean(stmt, idx++, true);
                        stmt.setLong(idx++, baseCrlNumber.longValue());
                    }
                    stmt.setInt(idx++, crl.getCrlScope());
                    stmt.setString(idx++, b64Sha1);
                    stmt.setString(idx, Base64.encodeToString((byte[])encodedCrl));
                    stmt.addBatch();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CRL with ID=" + crl.getId() + ", message: " + ex.getMessage());
                    throw ex;
                }
                boolean bl = isLastBlock = i == n - 1;
                if (numEntriesInBatch <= 0 || numEntriesInBatch % numEntriesPerCommit != 0 && !isLastBlock) continue;
                try {
                    stmt.executeBatch();
                    this.commit("(commit import to CA)");
                }
                catch (Throwable th) {
                    this.rollback();
                    this.deleteFromTableWithLargerId(type.getTableName(), "ID", id, LOG);
                    if (th instanceof SQLException) {
                        throw this.translate(sql, (SQLException)th);
                    }
                    if (th instanceof Exception) {
                        throw (Exception)th;
                    }
                    throw new Exception(th);
                }
                lastSuccessfulEntryId = id;
                processLog.addNumProcessed((long)numEntriesInBatch);
                numEntriesInBatch = 0;
                CaCertstoreDbImporter.echoToFile(type + ":" + ((long)numProcessedInLastProcess + processLog.numProcessed()) + ":" + lastSuccessfulEntryId, processLogFile);
                processLog.printStatus();
            }
            long l = lastSuccessfulEntryId;
            return l;
        }
        finally {
            this.recoverAutoCommit();
            zipFile.close();
        }
    }
}

