/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.Permissions;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.ConfPairs;
import org.xipki.util.FileOrBinary;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;

class CaconfDbExporter
extends DbPorter {
    CaconfDbExporter(DataSourceWrapper datasource, String destDir, AtomicBoolean stopMe) throws DataAccessException {
        super(datasource, destDir, stopMe);
    }

    public void export() throws Exception {
        CaConfType.CaSystem caconf = new CaConfType.CaSystem();
        System.out.println("exporting CA configuration from database");
        this.exportDbSchema(caconf);
        this.exportSigner(caconf);
        this.exportRequestor(caconf);
        this.exportPublisher(caconf);
        this.exportProfile(caconf);
        this.exportCa(caconf);
        if (this.dbSchemaVersion >= 7) {
            this.exportKeypairGen(caconf);
        }
        caconf.validate();
        try (OutputStream os = Files.newOutputStream(Paths.get(this.baseDir, "ca-configuration.json"), new OpenOption[0]);){
            CaJson.writePrettyJSON((Object)caconf, (OutputStream)os);
        }
        System.out.println(" exported CA configuration from database");
    }

    private void exportRequestor(CaConfType.CaSystem caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table REQUESTOR ... ");
        boolean succ = false;
        LinkedList<CaConfType.Requestor> requestors = new LinkedList<CaConfType.Requestor>();
        caconf.setRequestors(requestors);
        String sql = "SELECT ID,NAME,TYPE,CONF FROM REQUESTOR";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaConfType.Requestor requestor = new CaConfType.Requestor();
                requestor.setId(Integer.valueOf(rs.getInt("ID")));
                requestor.setName(name);
                requestor.setType(rs.getString("TYPE"));
                requestor.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/cert-requestor-" + name + ".conf"));
                requestor.validate();
                requestors.add(requestor);
            }
            caconf.setRequestors(requestors);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportDbSchema(CaConfType.CaSystem caconf) throws DataAccessException {
        System.out.print("    exporting table DBSCHEMA ... ");
        boolean succ = false;
        String sql = "SELECT NAME,VALUE2 FROM DBSCHEMA";
        HashMap<String, String> dbSchemas = new HashMap<String, String>();
        caconf.setDbSchemas(dbSchemas);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,VALUE2 FROM DBSCHEMA");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                String value = rs.getString("VALUE2");
                dbSchemas.put(name, value);
            }
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,VALUE2 FROM DBSCHEMA", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportSigner(CaConfType.CaSystem caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table SIGNER ... ");
        boolean succ = false;
        LinkedList<CaConfType.Signer> signers = new LinkedList<CaConfType.Signer>();
        caconf.setSigners(signers);
        String sql = "SELECT NAME,TYPE,CONF,CERT FROM SIGNER";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,TYPE,CONF,CERT FROM SIGNER");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaConfType.Signer signer = new CaConfType.Signer();
                signer.setName(name);
                signer.setType(rs.getString("TYPE"));
                signer.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-signer-" + name));
                signer.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-signer-" + name + ".der"));
                signer.validate();
                signers.add(signer);
            }
            caconf.setSigners(signers);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF,CERT FROM SIGNER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportKeypairGen(CaConfType.CaSystem caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table KEYPAIR_GEN ... ");
        boolean succ = false;
        LinkedList<CaConfType.NameTypeConf> keypairGens = new LinkedList<CaConfType.NameTypeConf>();
        caconf.setKeypairGens(keypairGens);
        String sql = "SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaConfType.NameTypeConf entry = new CaConfType.NameTypeConf();
                entry.setName(name);
                entry.setType(rs.getString("TYPE"));
                entry.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                entry.validate();
                keypairGens.add(entry);
            }
            caconf.setKeypairGens(keypairGens);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,TYPE,CONF FROM KEYPAIR_GEN", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportPublisher(CaConfType.CaSystem caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table PUBLISHER ... ");
        boolean succ = false;
        LinkedList<CaConfType.NameTypeConf> publishers = new LinkedList<CaConfType.NameTypeConf>();
        caconf.setPublishers(publishers);
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PUBLISHER";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaConfType.NameTypeConf publisher = new CaConfType.NameTypeConf();
                publisher.setId(Integer.valueOf(rs.getInt("ID")));
                publisher.setName(name);
                publisher.setType(rs.getString("TYPE"));
                publisher.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/conf-publisher-" + name));
                publisher.validate();
                publishers.add(publisher);
            }
            caconf.setPublishers(publishers);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportProfile(CaConfType.CaSystem caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table PROFILE ... ");
        boolean succ = false;
        LinkedList<CaConfType.NameTypeConf> profiles = new LinkedList<CaConfType.NameTypeConf>();
        caconf.setProfiles(profiles);
        String sql = "SELECT ID,NAME,TYPE,CONF FROM PROFILE";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT ID,NAME,TYPE,CONF FROM PROFILE");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                CaConfType.NameTypeConf profile = new CaConfType.NameTypeConf();
                profile.setId(Integer.valueOf(rs.getInt("ID")));
                profile.setName(name);
                profile.setType(rs.getString("TYPE"));
                profile.setConf(this.buildFileOrValue(rs.getString("CONF"), "ca-conf/certprofile-" + name));
                profile.validate();
                profiles.add(profile);
            }
            caconf.setProfiles(profiles);
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT ID,NAME,TYPE,CONF FROM PROFILE", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private void exportCa(CaConfType.CaSystem caconf) throws DataAccessException, IOException, InvalidConfException {
        System.out.print("    exporting table CA ... ");
        boolean succ = false;
        caconf.setCas(new LinkedList());
        Map<String, Integer> aliasToCaIdMap = this.getCaAliases();
        Map<Integer, List<String>> caHassPublishersMap = this.getCaHasPublishers(caconf.getPublishers());
        Map<Integer, List<CaConfType.CaHasRequestor>> caHasRequestorsMap = this.getCaHasRequestors(caconf.getRequestors());
        Map<Integer, List<String>> caHasProfilesMap = this.getCaHasProfiles(caconf.getProfiles());
        Object columns = "SELECT ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN";
        columns = this.dbSchemaVersion >= 7 ? (String)columns + ",CONF" : (String)columns + ",SN_SIZE,CA_URIS,MAX_VALIDITY,PERMISSION,NUM_CRLS,EXPIRATION_PERIOD,VALIDITY_MODE,CRL_CONTROL,CTLOG_CONTROL,REVOKE_SUSPENDED_CONTROL,KEEP_EXPIRED_CERT_DAYS,EXTRA_CONTROL";
        String sql = (String)columns + " FROM CA";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                CaConfColumn ccc;
                CaConfType.Ca ca = new CaConfType.Ca();
                caconf.getCas().add(ca);
                int id = rs.getInt("ID");
                ca.setId(Integer.valueOf(id));
                String name = rs.getString("NAME");
                ca.setName(name);
                CaConfType.CaInfo ci = new CaConfType.CaInfo();
                ca.setCaInfo(ci);
                ci.setNextCrlNo(rs.getLong("NEXT_CRLNO"));
                ci.setStatus(CaStatus.forName((String)rs.getString("STATUS")));
                ci.setCert(this.buildFileOrBase64Binary(rs.getString("CERT"), "ca-conf/cert-ca-" + name + ".der"));
                String encodedCertchain = rs.getString("CERTCHAIN");
                if (StringUtil.isNotBlank((String)encodedCertchain)) {
                    List certchain;
                    try {
                        certchain = X509Util.listCertificates((String)encodedCertchain);
                    }
                    catch (CertificateException e) {
                        throw new InvalidConfException("error parsing CERTCHAIN of CA " + name);
                    }
                    ArrayList<FileOrBinary> ccList = new ArrayList<FileOrBinary>(certchain.size());
                    for (int i = 0; i < certchain.size(); ++i) {
                        byte[] certBytes = ((X509Cert)certchain.get(i)).getEncoded();
                        ccList.add(this.buildFileOrBinary(certBytes, "ca-conf/ca-" + name + "-certchain-" + i + ".der"));
                    }
                    ci.setCertchain(ccList);
                }
                ci.setSignerType(rs.getString("SIGNER_TYPE"));
                ci.setSignerConf(this.buildFileOrValue(rs.getString("SIGNER_CONF"), "ca-conf/signerconf-ca-" + name));
                String revInfoStr = rs.getString("REV_INFO");
                if (revInfoStr != null) {
                    ci.setRevocationInfo(CertRevocationInfo.fromEncoded((String)revInfoStr));
                }
                ci.setCrlSignerName(rs.getString("CRL_SIGNER_NAME"));
                if (this.dbSchemaVersion >= 7) {
                    String confColumn = rs.getString("CONF");
                    ccc = CaConfColumn.decode((String)confColumn);
                } else {
                    ccc = new CaConfColumn();
                    ccc.setSnSize(rs.getInt("SN_SIZE"));
                    String str = rs.getString("CA_URIS");
                    if (StringUtil.isNotBlank((String)str)) {
                        CaUris caUris = CaUris.decode((String)str);
                        ccc.setCacertUris(caUris.getCacertUris());
                        ccc.setCrlUris(caUris.getCrlUris());
                        ccc.setDeltaCrlUris(caUris.getDeltaCrlUris());
                        ccc.setOcspUris(caUris.getOcspUris());
                    }
                    if (StringUtil.isNotBlank((String)(str = rs.getString("MAX_VALIDITY")))) {
                        ccc.setMaxValidity(Validity.getInstance((String)str));
                    }
                    if (StringUtil.isNotBlank((String)(str = rs.getString("CRL_CONTROL")))) {
                        ccc.setCrlControl(new CrlControl(str));
                    }
                    if (StringUtil.isNotBlank((String)(str = rs.getString("CTLOG_CONTROL")))) {
                        ccc.setCtlogControl(new CtlogControl(str));
                    }
                    ccc.setPermission(new Permissions(rs.getInt("PERMISSION")));
                    ccc.setExpirationPeriod(rs.getInt("EXPIRATION_PERIOD"));
                    ccc.setKeepExpiredCertDays(rs.getInt("KEEP_EXPIRED_CERT_DAYS"));
                    str = rs.getString("VALIDITY_MODE");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setValidityMode(ValidityMode.forName((String)str));
                    }
                    if (StringUtil.isNotBlank((String)(str = rs.getString("EXTRA_CONTROL")))) {
                        ccc.setExtraControl(new ConfPairs(str));
                    }
                    ccc.setNumCrls(rs.getInt("NUM_CRLS"));
                    str = rs.getString("REVOKE_SUSPENDED_CONTROL");
                    if (StringUtil.isNotBlank((String)str)) {
                        ccc.setRevokeSuspendedControl(new RevokeSuspendedControl(str));
                    }
                    ccc.setKeypairGenNames(Collections.singletonList("software"));
                    ccc.setSaveCert(true);
                    ccc.setSaveKeypair(false);
                }
                this.adoptConfColumn(ca, ccc);
                ca.setProfiles(caHasProfilesMap.get(id));
                ca.setProfiles(caHasProfilesMap.get(id));
                ca.setRequestors(caHasRequestorsMap.get(id));
                ca.setPublishers(caHassPublishersMap.get(id));
                LinkedList<String> aliases = new LinkedList<String>();
                for (Map.Entry<String, Integer> m : aliasToCaIdMap.entrySet()) {
                    if (m.getValue() != id) continue;
                    aliases.add(m.getKey());
                }
                if (!aliases.isEmpty()) {
                    ca.setAliases(aliases);
                }
                ca.validate();
            }
            succ = true;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                System.out.println(succ ? "SUCCESSFUL" : "FAILED");
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    public void adoptConfColumn(CaConfType.Ca ca, CaConfColumn cc) {
        CaConfType.CaInfo caInfo = ca.getCaInfo();
        if (cc.getCacertUris() != null || cc.getCrlUris() != null || cc.getDeltaCrlUris() != null || cc.getOcspUris() != null) {
            caInfo.setCaUris(new CaUris(cc.getCacertUris(), cc.getOcspUris(), cc.getCrlUris(), cc.getDeltaCrlUris()));
        }
        caInfo.setCrlControl(cc.getCrlControl());
        caInfo.setCtlogControl(cc.getCtlogControl());
        caInfo.setExtraControl(cc.getExtraControl());
        caInfo.setRevokeSuspendedControl(cc.getRevokeSuspendedControl());
        caInfo.setSnSize(cc.getSnSize());
        caInfo.setMaxValidity(cc.getMaxValidity());
        caInfo.setKeypairGenNames(cc.getKeypairGenNames());
        caInfo.setSaveKeypair(cc.isSaveKeypair());
        caInfo.setSaveKeypair(cc.isSaveKeypair());
        caInfo.setPermissions(this.permissionToStringList(cc.getPermission().getValue()));
        caInfo.setNumCrls(cc.getNumCrls());
        caInfo.setExpirationPeriod(cc.getExpirationPeriod());
        caInfo.setKeepExpiredCertDays(cc.getKeepExpiredCertDays());
        cc.setValidityMode(cc.getValidityMode());
    }

    private Map<String, Integer> getCaAliases() throws DataAccessException {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        String sql = "SELECT NAME,CA_ID FROM CAALIAS";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT NAME,CA_ID FROM CAALIAS");
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.put(rs.getString("NAME"), rs.getInt("CA_ID"));
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT NAME,CA_ID FROM CAALIAS", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        return ret;
    }

    private Map<Integer, List<String>> getCaHasPublishers(List<CaConfType.NameTypeConf> publishers) throws DataAccessException {
        Map<Integer, String> publisherIdToNameMap = CaconfDbExporter.idToNameMap(publishers);
        HashMap<Integer, List<String>> ret = new HashMap<Integer, List<String>>();
        String sql = "SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER");
            rs = stmt.executeQuery();
            while (rs.next()) {
                int caId = rs.getInt("CA_ID");
                int publisherId = rs.getInt("PUBLISHER_ID");
                List publisherNames = ret.computeIfAbsent(caId, k -> new LinkedList());
                publisherNames.add(publisherIdToNameMap.get(publisherId));
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,PUBLISHER_ID FROM CA_HAS_PUBLISHER", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        return ret;
    }

    private Map<Integer, List<String>> getCaHasProfiles(List<CaConfType.NameTypeConf> profiles) throws DataAccessException {
        Map<Integer, String> profileIdToNameMap = CaconfDbExporter.idToNameMap(profiles);
        HashMap<Integer, List<String>> ret = new HashMap<Integer, List<String>>();
        Object sql = "SELECT CA_ID,PROFILE_ID";
        if (this.dbSchemaVersion > 8) {
            sql = (String)sql + ",ALIASES";
        }
        sql = (String)sql + " FROM CA_HAS_PROFILE";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement((String)sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                int caId = rs.getInt("CA_ID");
                int profileId = rs.getInt("PROFILE_ID");
                Object profileNameAndAliases = profileIdToNameMap.get(profileId);
                if (this.dbSchemaVersion > 8) {
                    String aliases = rs.getString("ALIASES");
                    profileNameAndAliases = (String)profileNameAndAliases + ":" + aliases;
                }
                List set = ret.computeIfAbsent(caId, k -> new LinkedList());
                set.add(profileNameAndAliases);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate((String)sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        return ret;
    }

    private Map<Integer, List<CaConfType.CaHasRequestor>> getCaHasRequestors(List<CaConfType.Requestor> requestors) throws DataAccessException {
        Map<Integer, String> requestorIdToNameMap = CaconfDbExporter.idToNameMap(requestors);
        HashMap<Integer, List<CaConfType.CaHasRequestor>> ret = new HashMap<Integer, List<CaConfType.CaHasRequestor>>();
        String sql = "SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.prepareStatement("SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR");
            rs = stmt.executeQuery();
            while (rs.next()) {
                int caId = rs.getInt("CA_ID");
                int requestorId = rs.getInt("REQUESTOR_ID");
                int permission = rs.getInt("PERMISSION");
                String profiles = rs.getString("PROFILES");
                CaConfType.CaHasRequestor m = new CaConfType.CaHasRequestor();
                m.setRequestorName(requestorIdToNameMap.get(requestorId));
                m.setProfiles(StringUtil.split((String)profiles, (String)","));
                m.setPermissions(this.permissionToStringList(permission));
                List set = ret.computeIfAbsent(caId, k -> new LinkedList());
                set.add(m);
            }
        }
        catch (SQLException ex) {
            try {
                throw this.translate("SELECT CA_ID,REQUESTOR_ID,PERMISSION,PROFILES FROM CA_HAS_REQUESTOR", ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs);
                throw throwable;
            }
        }
        this.releaseResources(stmt, rs);
        return ret;
    }

    private static Map<Integer, String> idToNameMap(List<? extends CaConfType.IdNameConf> entries) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (CaConfType.IdNameConf idNameConf : entries) {
            ret.put(idNameConf.getId(), idNameConf.getName());
        }
        return ret;
    }

    private Permissions permissionToStringList(int permissionn) {
        if (this.dbSchemaVersion < 7) {
            permissionn |= 0x200;
        }
        return new Permissions(permissionn);
    }
}

