/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.db.port;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.api.mgmt.CaConfType;
import org.xipki.ca.api.mgmt.CaJson;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.entry.BaseCaInfo;
import org.xipki.ca.api.mgmt.entry.CaConfColumn;
import org.xipki.ca.mgmt.db.DbSchemaInfo;
import org.xipki.ca.mgmt.db.port.DbPorter;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.FileOrBinary;
import org.xipki.util.SqlUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

class CaconfDbImporter
extends DbPorter {
    private final CaConfType.CaSystem caconf;

    CaconfDbImporter(DataSourceWrapper datasource, String srcDir, AtomicBoolean stopMe) throws DataAccessException, IOException, InvalidConfException {
        super(datasource, srcDir, stopMe);
        this.caconf = (CaConfType.CaSystem)CaJson.parseObject((Path)Paths.get(this.baseDir, "ca-configuration.json"), CaConfType.CaSystem.class);
        this.caconf.validate();
    }

    public CaConfType.CaSystem getCaConf() {
        return this.caconf;
    }

    public void importToDb() throws Exception {
        System.out.println("importing CA configuration to database");
        try {
            boolean emptyDb;
            boolean bl = emptyDb = this.datasource.getCount(this.connection, "SIGNER") == 0 && this.datasource.getCount(this.connection, "REQUESTOR") <= 1 && this.datasource.getCount(this.connection, "PUBLISHER") == 0 && this.datasource.getCount(this.connection, "PROFILE") == 0 && this.datasource.getCount(this.connection, "KEYPAIR_GEN") <= 1;
            if (!emptyDb) {
                throw new Exception("Database for caconf is not empty");
            }
            this.importDbSchema(this.caconf.getDbSchemas());
            this.importSigner(this.caconf.getSigners());
            this.importRequestor(this.caconf.getRequestors());
            this.importPublisher(this.caconf.getPublishers());
            this.importProfile(this.caconf.getProfiles());
            this.importKeypairGen(this.caconf.getKeypairGens());
            List cas = this.caconf.getCas();
            this.importCa(cas);
            this.importCaalias(cas);
            this.importCaHasRequestor(this.caconf);
            this.importCaHasPublisher(this.caconf);
            this.importCaHasCertprofile(this.caconf);
        }
        catch (Exception ex) {
            System.err.println("could not import CA configuration to database. message: " + ex.getMessage());
            throw ex;
        }
        System.out.println(" imported CA configuration to database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDbSchema(Map<String, String> entries) throws DataAccessException {
        System.out.print("    importing table DBSCHEMA ... ");
        if (entries == null) {
            System.out.println("nothing to import");
            return;
        }
        DbSchemaInfo dbSchemaInfo = new DbSchemaInfo(this.datasource);
        Set<String> dbSchemaNames = dbSchemaInfo.getVariableNames();
        String sql = SqlUtil.buildInsertSql((String)"DBSCHEMA", (String)"NAME,VALUE2");
        PreparedStatement ps = null;
        boolean succ = false;
        try {
            ps = this.prepareStatement(sql);
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                String name = entry.getKey();
                if (dbSchemaNames.contains(name)) continue;
                try {
                    ps.setString(1, name);
                    ps.setString(2, entry.getValue());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import DBSCHEMA with NAME=" + name);
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSigner(List<CaConfType.Signer> signers) throws DataAccessException, IOException {
        System.out.print("    importing table SIGNER ... ");
        if (signers == null) {
            System.out.println("nothing to import");
            return;
        }
        String sql = SqlUtil.buildInsertSql((String)"SIGNER", (String)"NAME,TYPE,CERT,CONF");
        boolean succ = false;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaConfType.Signer signer : signers) {
                String b64Cert = signer.getCert() == null ? null : Base64.encodeToString((byte[])this.readContent(signer.getCert()));
                try {
                    int idx = 1;
                    ps.setString(idx++, signer.getName());
                    ps.setString(idx++, signer.getType());
                    ps.setString(idx++, b64Cert);
                    ps.setString(idx, this.readContent(signer.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import SIGNER with NAME=" + signer.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importRequestor(List<CaConfType.Requestor> requestors) throws DataAccessException, IOException {
        System.out.print("    importing table REQUESTOR ... ");
        String sql = SqlUtil.buildInsertSql((String)"REQUESTOR", (String)"ID,NAME,TYPE,CONF");
        boolean succ = false;
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaConfType.Requestor requestor : requestors) {
                try {
                    ps.setInt(1, requestor.getId());
                    ps.setString(2, requestor.getName());
                    ps.setString(3, requestor.getType());
                    ps.setString(4, this.readContent(requestor.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import REQUESTOR with NAME=" + requestor.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPublisher(List<CaConfType.NameTypeConf> publishers) throws DataAccessException, IOException {
        System.out.print("    importing table PUBLISHER ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"PUBLISHER", (String)"ID,NAME,TYPE,CONF");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaConfType.NameTypeConf publisher : publishers) {
                try {
                    int idx = 1;
                    ps.setInt(idx++, publisher.getId());
                    ps.setString(idx++, publisher.getName());
                    ps.setString(idx++, publisher.getType());
                    ps.setString(idx, this.readContent(publisher.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import PUBLISHER with NAME=" + publisher.getName());
                    throw this.translate(sql, ex);
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importProfile(List<CaConfType.NameTypeConf> profiles) throws DataAccessException, IOException {
        System.out.print("    importing table PROFILE ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"PROFILE", (String)"ID,NAME,TYPE,CONF");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaConfType.NameTypeConf certprofile : profiles) {
                try {
                    int idx = 1;
                    ps.setInt(idx++, certprofile.getId());
                    ps.setString(idx++, certprofile.getName());
                    ps.setString(idx++, certprofile.getType());
                    ps.setString(idx, this.readContent(certprofile.getConf()));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import PROFILE with NAME=" + certprofile.getName());
                    throw this.translate(sql, ex);
                }
                catch (IOException ex) {
                    System.err.println("could not import PROFILE with NAME=" + certprofile.getName());
                    throw ex;
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * Exception decompiling
     */
    private void importKeypairGen(List<CaConfType.NameTypeConf> keypairGens) throws DataAccessException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCa(List<CaConfType.Ca> cas) throws DataAccessException, CertificateException, IOException {
        System.out.print("    importing table CA ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA", (String)"ID,NAME,STATUS,NEXT_CRLNO,CRL_SIGNER_NAME,SUBJECT,REV_INFO,SIGNER_TYPE,SIGNER_CONF,CERT,CERTCHAIN,CONF");
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(sql);
            for (CaConfType.Ca ca : cas) {
                CaConfType.CaInfo caInfo = ca.getCaInfo();
                try {
                    byte[] certBytes = this.readContent(caInfo.getCert());
                    X509Cert cert = X509Util.parseCert((byte[])certBytes);
                    String certchainStr = null;
                    if (caInfo.getCertchain() != null) {
                        byte[][] certchainBytes = new byte[caInfo.getCertchain().size()][];
                        for (int i = 0; i < certchainBytes.length; ++i) {
                            certchainBytes[i] = this.readContent((FileOrBinary)caInfo.getCertchain().get(i));
                        }
                        certchainStr = X509Util.encodeCertificates((byte[][])certchainBytes);
                    }
                    String revInfoStr = null;
                    if (caInfo.getRevocationInfo() != null) {
                        revInfoStr = caInfo.getRevocationInfo().encode();
                    }
                    int idx = 1;
                    ps.setInt(idx++, ca.getId());
                    ps.setString(idx++, ca.getName().toLowerCase());
                    ps.setString(idx++, ca.getCaInfo().getStatus().getStatus());
                    ps.setLong(idx++, caInfo.getNextCrlNo());
                    ps.setString(idx++, caInfo.getCrlSignerName());
                    ps.setString(idx++, X509Util.cutX500Name((X500Name)cert.getSubject(), (int)this.maxX500nameLen));
                    ps.setString(idx++, revInfoStr);
                    ps.setString(idx++, caInfo.getSignerType());
                    ps.setString(idx++, this.readContent(caInfo.getSignerConf()));
                    ps.setString(idx++, Base64.encodeToString((byte[])certBytes));
                    ps.setString(idx++, certchainStr);
                    CaConfColumn caConfColumn = CaConfColumn.fromBaseCaInfo((BaseCaInfo)ca.getCaInfo());
                    ps.setString(idx, caConfColumn.encode());
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    System.err.println("could not import CA with NAME=" + ca.getName());
                    throw this.translate(sql, ex);
                }
                catch (IOException | CertificateException ex) {
                    System.err.println("could not import CA with NAME=" + ca.getName());
                    throw ex;
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaalias(List<CaConfType.Ca> cas) throws DataAccessException {
        System.out.print("    importing table CAALIAS ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CAALIAS", (String)"NAME,CA_ID");
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            for (CaConfType.Ca ca : cas) {
                for (String alias : ca.getAliases()) {
                    try {
                        ps.setString(1, alias);
                        ps.setInt(2, ca.getId());
                        ps.executeUpdate();
                    }
                    catch (SQLException ex) {
                        System.err.println("could not import CAALIAS with alias=" + alias + " for CA " + ca.getName());
                        throw this.translate(sql, ex);
                    }
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaHasRequestor(CaConfType.CaSystem root) throws DataAccessException {
        System.out.print("    importing table CA_HAS_REQUESTOR ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_REQUESTOR", (String)"CA_ID,REQUESTOR_ID,PERMISSION,PROFILES");
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            Map<String, Integer> requestorNameToIdMap = CaconfDbImporter.nameToIdMap(root.getRequestors());
            for (CaConfType.Ca ca : root.getCas()) {
                for (CaConfType.CaHasRequestor entry : ca.getRequestors()) {
                    String errMsg = "could not import CA_HAS_REQUESTOR for CA=" + ca.getName() + " and REQUESTOR=" + entry.getRequestorName();
                    try {
                        int idx = 1;
                        ps.setInt(idx++, ca.getId());
                        ps.setInt(idx++, requestorNameToIdMap.get(entry.getRequestorName()));
                        ps.setInt(idx++, entry.getPermissions().getValue());
                        ps.setString(idx, StringUtil.collectionAsString((Collection)entry.getProfiles(), (String)","));
                        ps.executeUpdate();
                    }
                    catch (SQLException ex) {
                        System.err.println(errMsg);
                        throw this.translate(sql, ex);
                    }
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaHasPublisher(CaConfType.CaSystem root) throws Exception {
        System.out.print("    importing table CA_HAS_PUBLISHER ... ");
        boolean succ = false;
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PUBLISHER", (String)"CA_ID,PUBLISHER_ID");
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            Map<String, Integer> publisherNameToIdMap = CaconfDbImporter.nameToIdMap(root.getPublishers());
            for (CaConfType.Ca ca : root.getCas()) {
                for (String publisher : ca.getPublishers()) {
                    try {
                        ps.setInt(1, ca.getId());
                        ps.setInt(2, publisherNameToIdMap.get(publisher));
                        ps.executeUpdate();
                    }
                    catch (SQLException ex) {
                        System.err.println("could not import CA_HAS_PUBLISHER with CA=" + ca.getName() + " and PUBLISHER=" + publisher);
                        throw this.translate(sql, ex);
                    }
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCaHasCertprofile(CaConfType.CaSystem root) throws DataAccessException {
        System.out.print("    importing table CA_HAS_PROFILE ... ");
        boolean succ = false;
        String columns = "CA_ID,PROFILE_ID,ALIASES";
        String sql = SqlUtil.buildInsertSql((String)"CA_HAS_PROFILE", (String)columns);
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            Map<String, Integer> profileNameToIdMap = CaconfDbImporter.nameToIdMap(root.getProfiles());
            for (CaConfType.Ca ca : root.getCas()) {
                for (String combinedProfile : ca.getProfiles()) {
                    try {
                        CaProfileEntry entry = CaProfileEntry.decode((String)combinedProfile);
                        ps.setInt(1, ca.getId());
                        ps.setInt(2, profileNameToIdMap.get(entry.getProfileName()));
                        ps.setString(3, StringUtil.collectionAsString((Collection)entry.getProfileAliases(), (String)","));
                        ps.executeUpdate();
                    }
                    catch (SQLException ex) {
                        System.err.println("could not import CA_HAS_PROFILE with CA=" + ca.getName() + " and PROFILE=" + combinedProfile);
                        throw this.translate(sql, ex);
                    }
                }
            }
            succ = true;
        }
        catch (Throwable throwable) {
            this.releaseResources(ps, null);
            System.out.println(succ ? "SUCCESSFUL" : "FAILED");
            throw throwable;
        }
        this.releaseResources(ps, null);
        System.out.println(succ ? "SUCCESSFUL" : "FAILED");
    }

    private static Map<String, Integer> nameToIdMap(List<? extends CaConfType.IdNameConf> entries) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CaConfType.IdNameConf idNameConf : entries) {
            map.put(idNameConf.getName(), idNameConf.getId());
        }
        return map;
    }
}

