/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class ConfirmCertsRequest
extends SdkRequest {
    private final String transactionId;
    private final Entry[] entries;

    public ConfirmCertsRequest(String transactionId, Entry[] entries) {
        this.transactionId = transactionId;
        this.entries = entries;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeTextString(this.transactionId);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static ConfirmCertsRequest decode(byte[] encoded) throws DecodeException {
        ConfirmCertsRequest confirmCertsRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            ConfirmCertsRequest.assertArrayStart("ConfirmCertsRequest", (CborDecoder)decoder, 2);
            confirmCertsRequest = new ConfirmCertsRequest(decoder.readTextString(), Entry.decodeArray((CborDecoder)decoder));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(ConfirmCertsRequest.buildDecodeErrMessage(ex, ConfirmCertsRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return confirmCertsRequest;
    }

    public static class Entry
    extends SdkEncodable {
        private final boolean accept;
        private final BigInteger certReqId;
        private final byte[] certhash;

        public Entry(boolean accept, BigInteger certReqId, byte[] certhash) {
            this.accept = accept;
            this.certhash = certhash;
            this.certReqId = certReqId;
        }

        public BigInteger getCertReqId() {
            return this.certReqId;
        }

        public byte[] getCerthash() {
            return this.certhash;
        }

        public boolean isAccept() {
            return this.accept;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException {
            encoder.writeArrayStart(3);
            encoder.writeBoolean(this.accept);
            encoder.writeBigInt(this.certReqId);
            encoder.writeByteString(this.certhash);
        }

        public static Entry decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(3)) {
                    return null;
                }
                return new Entry(decoder.readBoolean(), decoder.readBigInt(), decoder.readByteString());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(Entry.buildDecodeErrMessage(ex, Entry.class), (Throwable)ex);
            }
        }

        public static Entry[] decodeArray(CborDecoder decoder) throws DecodeException {
            Integer arrayLen = decoder.readNullOrArrayLength(Entry[].class);
            if (arrayLen == null) {
                return null;
            }
            Entry[] entries = new Entry[arrayLen.intValue()];
            for (int i = 0; i < arrayLen; ++i) {
                entries[i] = Entry.decode(decoder);
            }
            return entries;
        }
    }
}

