/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.SdkResponse;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class CrlResponse
extends SdkResponse {
    private final byte[] crl;

    public CrlResponse(byte[] crl) {
        this.crl = crl;
    }

    public byte[] getCrl() {
        return this.crl;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(1);
        encoder.writeByteString(this.crl);
    }

    public static CrlResponse decode(byte[] encoded) throws DecodeException {
        CrlResponse crlResponse;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            CrlResponse.assertArrayStart("CrlResponse", (CborDecoder)decoder, 1);
            crlResponse = new CrlResponse(decoder.readByteString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(CrlResponse.buildDecodeErrMessage(ex, CrlResponse.class), (Throwable)ex);
            }
        }
        decoder.close();
        return crlResponse;
    }
}

