/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.pki.ErrorCode;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class ErrorEntry
extends SdkEncodable {
    private final int code;
    private final String message;

    public ErrorEntry(ErrorCode code, String message) {
        this.code = code.getCode();
        this.message = message;
    }

    public ErrorEntry(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(ErrorCode.ofCode((int)this.code).name());
        }
        catch (Exception e) {
            sb.append("Unknown code ").append(this.code);
        }
        if (this.message != null) {
            sb.append(", message: ").append(this.message);
        }
        return sb.toString();
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(2);
        encoder.writeInt((long)this.code);
        encoder.writeTextString(this.message);
    }

    public static ErrorEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(2)) {
                return null;
            }
            return new ErrorEntry(decoder.readInt(), decoder.readTextString());
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(ErrorEntry.buildDecodeErrMessage(ex, ErrorEntry.class), (Throwable)ex);
        }
    }
}

