/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.xipki.ca.sdk.SdkResponse;
import org.xipki.pki.ErrorCode;
import org.xipki.util.Args;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class ErrorResponse
extends SdkResponse {
    private final String transactionId;
    private final ErrorCode code;
    private final String message;

    public ErrorResponse(String transactionId, ErrorCode code, String message) {
        this.transactionId = transactionId;
        this.code = (ErrorCode)Args.notNull((Object)code, (String)"code");
        this.message = message;
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.transactionId != null) {
            sb.append("tid=").append(this.transactionId).append(", ");
        }
        sb.append(this.code);
        if (this.message != null) {
            sb.append(", ").append(this.message);
        }
        return sb.toString();
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(3);
        encoder.writeTextString(this.transactionId);
        encoder.writeInt((long)this.code.getCode());
        encoder.writeTextString(this.message);
    }

    public static ErrorResponse decode(byte[] encoded) throws DecodeException {
        ErrorResponse errorResponse;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            ErrorResponse.assertArrayStart("ErrorResponse", (CborDecoder)decoder, 3);
            String tid = decoder.readTextString();
            int code = decoder.readInt();
            ErrorCode errorCode = ErrorCode.ofCode((int)code);
            errorResponse = new ErrorResponse(tid, errorCode, decoder.readTextString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(ErrorResponse.buildDecodeErrMessage(ex, ErrorResponse.class), (Throwable)ex);
            }
        }
        decoder.close();
        return errorResponse;
    }
}

