/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class GetCRLRequest
extends SdkRequest {
    private final BigInteger crlNumber;
    private final Instant thisUpdate;
    private final String crlDp;

    public GetCRLRequest(BigInteger crlNumber, Instant thisUpdate, String crlDp) {
        this.crlNumber = crlNumber;
        this.thisUpdate = thisUpdate;
        this.crlDp = crlDp;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public Instant getThisUpdate() {
        return this.thisUpdate;
    }

    public String getCrlDp() {
        return this.crlDp;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(3);
        encoder.writeBigInt(this.crlNumber);
        encoder.writeInstant(this.thisUpdate);
        encoder.writeTextString(this.crlDp);
    }

    public static GetCRLRequest decode(byte[] encoded) throws DecodeException {
        GetCRLRequest getCRLRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            GetCRLRequest.assertArrayStart("GetCRLRequest", (CborDecoder)decoder, 3);
            getCRLRequest = new GetCRLRequest(decoder.readBigInt(), decoder.readInstant(), decoder.readTextString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(GetCRLRequest.buildDecodeErrMessage(ex, GetCRLRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return getCRLRequest;
    }
}

