/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.Args;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class OldCertInfo
extends SdkEncodable {
    private static final long TAG_ISN = 1L;
    private static final long TAG_SUBJECT = 2L;
    private static final long TAG_FSN = 3L;
    private final boolean reusePublicKey;
    private ByIssuerAndSerial isn;
    private BySha1FpAndSerial fsn;
    private BySubject subject;

    public OldCertInfo(boolean reusePublicKey, ByIssuerAndSerial isn) {
        this.reusePublicKey = reusePublicKey;
        this.isn = (ByIssuerAndSerial)Args.notNull((Object)isn, (String)"isn");
    }

    public OldCertInfo(boolean reusePublicKey, BySha1FpAndSerial fsn) {
        this.reusePublicKey = reusePublicKey;
        this.fsn = (BySha1FpAndSerial)Args.notNull((Object)fsn, (String)"fsn");
    }

    public OldCertInfo(boolean reusePublicKey, BySubject subject) {
        this.reusePublicKey = reusePublicKey;
        this.subject = (BySubject)Args.notNull((Object)subject, (String)"subject");
    }

    public boolean isReusePublicKey() {
        return this.reusePublicKey;
    }

    public ByIssuerAndSerial getIsn() {
        return this.isn;
    }

    public BySubject getSubject() {
        return this.subject;
    }

    public BySha1FpAndSerial getFsn() {
        return this.fsn;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeBoolean(this.isReusePublicKey());
        if (this.isn != null) {
            encoder.writeTag(1L);
            encoder.writeObject((CborEncodable)this.isn);
        } else if (this.subject != null) {
            encoder.writeTag(2L);
            encoder.writeObject((CborEncodable)this.subject);
        } else {
            encoder.writeTag(3L);
            encoder.writeObject((CborEncodable)this.fsn);
        }
    }

    public static OldCertInfo decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(2)) {
                return null;
            }
            boolean usePublicKey = decoder.readBoolean();
            long tag = decoder.readTag();
            if (tag == 1L) {
                ByIssuerAndSerial isn = ByIssuerAndSerial.decode(decoder);
                return new OldCertInfo(usePublicKey, isn);
            }
            if (tag == 2L) {
                BySubject subject = BySubject.decode(decoder);
                return new OldCertInfo(usePublicKey, subject);
            }
            BySha1FpAndSerial fsn = BySha1FpAndSerial.decode(decoder);
            return new OldCertInfo(usePublicKey, fsn);
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(OldCertInfo.buildDecodeErrMessage(ex, ByIssuerAndSerial.class), (Throwable)ex);
        }
    }

    public static class BySubject
    extends SdkEncodable {
        private final byte[] subject;
        private final byte[] san;

        public BySubject(byte[] subject, byte[] san) {
            this.subject = subject;
            this.san = san;
        }

        public byte[] getSubject() {
            return this.subject;
        }

        public byte[] getSan() {
            return this.san;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(2);
            encoder.writeByteString(this.subject);
            encoder.writeByteString(this.san);
        }

        public static BySubject decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(2)) {
                    return null;
                }
                return new BySubject(decoder.readByteString(), decoder.readByteString());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(BySubject.buildDecodeErrMessage(ex, BySubject.class), (Throwable)ex);
            }
        }
    }

    public static class BySha1FpAndSerial
    extends SdkEncodable {
        private final byte[] caCertSha1;
        private final BigInteger serialNumber;

        public BySha1FpAndSerial(byte[] caCertSha1, BigInteger serialNumber) {
            this.caCertSha1 = caCertSha1;
            this.serialNumber = serialNumber;
        }

        public byte[] getCaCertSha1() {
            return this.caCertSha1;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(2);
            encoder.writeByteString(this.caCertSha1);
            encoder.writeBigInt(this.serialNumber);
        }

        public static BySha1FpAndSerial decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(2)) {
                    return null;
                }
                return new BySha1FpAndSerial(decoder.readByteString(), decoder.readBigInt());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(BySha1FpAndSerial.buildDecodeErrMessage(ex, ByIssuerAndSerial.class), (Throwable)ex);
            }
        }
    }

    public static class ByIssuerAndSerial
    extends SdkEncodable {
        private final X500NameType issuer;
        private final BigInteger serialNumber;

        public ByIssuerAndSerial(X500NameType issuer, BigInteger serialNumber) {
            this.issuer = issuer;
            this.serialNumber = serialNumber;
        }

        public X500NameType getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(2);
            encoder.writeObject((CborEncodable)this.issuer);
            encoder.writeBigInt(this.serialNumber);
        }

        public static ByIssuerAndSerial decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(2)) {
                    return null;
                }
                return new ByIssuerAndSerial(X500NameType.decode(decoder), decoder.readBigInt());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(ByIssuerAndSerial.buildDecodeErrMessage(ex, ByIssuerAndSerial.class), (Throwable)ex);
            }
        }
    }
}

