/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public abstract class SdkEncodable
implements CborEncodable {
    protected abstract void encode0(CborEncoder var1) throws IOException, EncodeException;

    public final void encode(CborEncoder encoder) throws EncodeException {
        try {
            this.encode0(encoder);
        }
        catch (IOException ex) {
            throw new EncodeException("IO error encoding " + this.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new EncodeException("Runtime error encoding " + this.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public byte[] encode() throws EncodeException {
        byte[] byArray;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            CborEncoder encoder = new CborEncoder((OutputStream)bout);
            this.encode(encoder);
            bout.flush();
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new EncodeException("IOException encoding " + this.getClass().getName(), (Throwable)ex);
            }
        }
        bout.close();
        return byArray;
    }

    protected static void assertArrayStart(String name, CborDecoder decoder, int size) throws IOException, DecodeException {
        if (decoder.readNullOrArrayLength(size)) {
            throw new DecodeException(name + " must not be null.");
        }
    }

    protected static String buildDecodeErrMessage(Exception ex, Class<?> clazz) throws DecodeException {
        return "error decoding " + clazz.getName() + ": " + ex.getMessage();
    }
}

