/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class SingleCertSerialEntry
extends SdkEncodable {
    private final BigInteger serialNumber;
    private final ErrorEntry error;

    public SingleCertSerialEntry(BigInteger serialNumber, ErrorEntry error) {
        this.serialNumber = serialNumber;
        this.error = error;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public ErrorEntry getError() {
        return this.error;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeBigInt(this.serialNumber);
        encoder.writeObject((CborEncodable)this.error);
    }

    public static SingleCertSerialEntry decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(2)) {
                return null;
            }
            return new SingleCertSerialEntry(decoder.readBigInt(), ErrorEntry.decode(decoder));
        }
        catch (IOException | RuntimeException ex) {
            throw new DecodeException(SingleCertSerialEntry.buildDecodeErrMessage(ex, SingleCertSerialEntry.class), (Throwable)ex);
        }
    }

    public static SingleCertSerialEntry[] decodeArray(CborDecoder decoder) throws DecodeException {
        Integer arrayLen = decoder.readNullOrArrayLength(SingleCertSerialEntry[].class);
        if (arrayLen == null) {
            return null;
        }
        SingleCertSerialEntry[] entries = new SingleCertSerialEntry[arrayLen.intValue()];
        for (int i = 0; i < arrayLen; ++i) {
            entries[i] = SingleCertSerialEntry.decode(decoder);
        }
        return entries;
    }
}

