/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.util.Args;
import org.xipki.util.Hex;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.cbor.CborType;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class X500NameType
extends SdkEncodable {
    private static final long TAG_ENCODED = 1L;
    private static final long TAG_TEXT = 2L;
    private X500Name name;
    private final String text;
    private final byte[] encoded;

    public X500NameType(String text) {
        this.text = Args.notBlank((String)text, (String)"text");
        this.encoded = null;
    }

    public X500NameType(X500Name name) {
        try {
            this.encoded = name.getEncoded();
            this.name = name;
            this.text = null;
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new IllegalStateException("error encoding X500Name " + name);
        }
    }

    public X500NameType(byte[] encoded) {
        try {
            this.encoded = encoded;
            this.name = X500Name.getInstance((Object)encoded);
            this.text = null;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("error encoding X500Name " + this.name);
        }
    }

    public String getText() {
        return this.text;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public X500Name toX500Name() throws IOException {
        if (this.name != null) {
            return this.name;
        }
        try {
            this.name = this.encoded != null ? X500Name.getInstance((Object)this.encoded) : new X500Name(this.text);
            return this.name;
        }
        catch (Exception e) {
            throw new IOException("error parsing X500Name " + (String)(this.encoded == null ? this.text : "0x" + Hex.encode((byte[])this.encoded)));
        }
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        if (this.encoded != null) {
            encoder.writeTag(1L);
            encoder.writeByteString(this.encoded);
        } else {
            encoder.writeTag(2L);
            encoder.writeTextString(this.text);
        }
    }

    public static X500NameType decode(CborDecoder decoder) throws DecodeException {
        try {
            CborType type = decoder.peekType();
            if (CborDecoder.isNull((CborType)type)) {
                decoder.readNull();
                return null;
            }
            long tag = decoder.readTag();
            if (tag == 1L) {
                return new X500NameType(decoder.readByteString());
            }
            return new X500NameType(decoder.readTextString());
        }
        catch (IOException ex) {
            throw new DecodeException(X500NameType.buildDecodeErrMessage(ex, X500NameType.class), (Throwable)ex);
        }
    }
}

