/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.util.Arrays;
import java.util.Objects;
import org.xipki.pkcs11.wrapper.Functions;

public class PKCS11KeyId {
    private final long handle;
    private final long keyType;
    private final long objectCLass;
    private final byte[] id;
    private final String idHex;
    private final String label;
    private Long publicKeyHandle;

    public PKCS11KeyId(long handle, long objectClass, long keyType, byte[] id, String label) {
        this.handle = handle;
        this.objectCLass = objectClass;
        this.keyType = keyType;
        if (id == null || id.length == 0) {
            this.id = null;
            this.idHex = null;
        } else {
            this.id = id;
            this.idHex = Functions.toHex(id);
        }
        this.label = label;
    }

    public long getKeyType() {
        return this.keyType;
    }

    public long getObjectCLass() {
        return this.objectCLass;
    }

    public long getHandle() {
        return this.handle;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getIdHex() {
        return this.idHex;
    }

    public String getLabel() {
        return this.label;
    }

    public Long getPublicKeyHandle() {
        return this.publicKeyHandle;
    }

    public void setPublicKeyHandle(Long publicKeyHandle) {
        this.publicKeyHandle = publicKeyHandle;
    }

    public String toString() {
        return String.format("(handle = %d, id = %s, label = %s)", this.handle, this.idHex, this.label);
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PKCS11KeyId)) {
            return false;
        }
        PKCS11KeyId other = (PKCS11KeyId)obj;
        return this.handle == other.handle && Arrays.equals(this.id, other.id) && Objects.equals(this.label, other.label);
    }
}

