/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.hsmproxy;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.hsmproxy.HsmProxyResponder;
import org.xipki.security.Securities;
import org.xipki.security.util.TlsHelper;
import org.xipki.security.util.X509Util;
import org.xipki.util.FileOrBinary;
import org.xipki.util.IoUtil;
import org.xipki.util.JSON;
import org.xipki.util.LogUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class HsmProxyServletFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(HsmProxyServletFilter.class);
    private static final String DFLT_CFG = "etc/hsmproxy/hsmproxy.json";
    private HsmProxyResponder responder;
    private Securities securities;

    public HsmProxyServletFilter() throws Exception {
        P11ProxyConf conf;
        XipkiBaseDir.init();
        try {
            conf = P11ProxyConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
        }
        catch (IOException ex) {
            throw new IOException("could not parse PKCS#11 Proxy configuration file etc/hsmproxy/hsmproxy.json", ex);
        }
        catch (InvalidConfException ex) {
            throw new InvalidConfException("could not parse PKCS#11 Proxy configuration file etc/hsmproxy/hsmproxy.json", (Throwable)ex);
        }
        boolean logReqResp = conf.isLogReqResp();
        LOG.info("logReqResp: {}", (Object)logReqResp);
        this.securities = new Securities();
        try {
            this.securities.init(conf.getSecurity());
        }
        catch (IOException | InvalidConfException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not initialize Securities");
            return;
        }
        for (FileOrBinary fb : conf.getClientCerts()) {
            if (fb.getFile() == null) continue;
            fb.setFile(IoUtil.expandFilepath((String)fb.getFile(), (boolean)true));
        }
        List clientCerts = X509Util.parseCerts(conf.getClientCerts());
        this.responder = new HsmProxyResponder(logReqResp, conf.getReverseProxyMode(), this.securities.getP11CryptServiceFactory(), clientCerts);
    }

    public void destroy() {
        if (this.securities != null) {
            this.securities.close();
            this.securities = null;
        }
    }

    public void doFilter(XiHttpRequest request, XiHttpResponse response) throws Exception {
        this.responder.service(request, response);
    }

    private static class P11ProxyConf
    extends ValidableConf {
        private boolean logReqResp;
        private String reverseProxyMode;
        private List<FileOrBinary> clientCerts;
        private Securities.SecurityConf security;

        private P11ProxyConf() {
        }

        public static P11ProxyConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
            try (InputStream is = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);){
                P11ProxyConf conf = (P11ProxyConf)((Object)JSON.parseConf((InputStream)is, P11ProxyConf.class));
                conf.validate();
                P11ProxyConf p11ProxyConf = conf;
                return p11ProxyConf;
            }
        }

        public void setLogReqResp(boolean logReqResp) {
            this.logReqResp = logReqResp;
        }

        public boolean isLogReqResp() {
            return this.logReqResp;
        }

        public String getReverseProxyMode() {
            return this.reverseProxyMode;
        }

        public void setReverseProxyMode(String reverseProxyMode) {
            this.reverseProxyMode = reverseProxyMode;
        }

        public List<FileOrBinary> getClientCerts() {
            return this.clientCerts;
        }

        public void setClientCerts(List<FileOrBinary> clientCerts) {
            this.clientCerts = clientCerts;
        }

        public Securities.SecurityConf getSecurity() {
            return this.security == null ? Securities.SecurityConf.DEFAULT : this.security;
        }

        public void setSecurity(Securities.SecurityConf security) {
            this.security = security;
        }

        public void validate() throws InvalidConfException {
            P11ProxyConf.notEmpty(this.clientCerts, (String)"clientCerts");
            P11ProxyConf.validate((ValidableConf)this.security, (ValidableConf[])new ValidableConf[0]);
            TlsHelper.checkReverseProxyMode((String)this.reverseProxyMode);
        }
    }
}

