/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson;

import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.PublicCaInfo;
import org.xipki.ca.api.profile.BaseCertprofile;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.ExtensionValues;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.KeypairGenControl;
import org.xipki.ca.api.profile.NotAfterMode;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.api.profile.SubjectKeyIdentifierControl;
import org.xipki.ca.api.profile.TextVadidator;
import org.xipki.ca.certprofile.xijson.AdmissionExtension;
import org.xipki.ca.certprofile.xijson.BiometricInfoOption;
import org.xipki.ca.certprofile.xijson.MonetaryValueOption;
import org.xipki.ca.certprofile.xijson.NotBeforeOption;
import org.xipki.ca.certprofile.xijson.QcStatementOption;
import org.xipki.ca.certprofile.xijson.SubjectDirectoryAttributesControl;
import org.xipki.ca.certprofile.xijson.XijsonExtensions;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.KeypairGenerationType;
import org.xipki.ca.certprofile.xijson.conf.Subject;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.ca.certprofile.xijson.conf.extn.QcStatements;
import org.xipki.pki.BadCertTemplateException;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;
import org.xipki.util.Validity;

public class XijsonCertprofile
extends BaseCertprofile {
    private static final Logger LOG = LoggerFactory.getLogger(XijsonCertprofile.class);
    private Certprofile.CertDomain certDomain;
    private Certprofile.CertLevel certLevel;
    private KeypairGenControl keypairGenControl;
    private String serialNumberMode;
    private Map<ASN1ObjectIdentifier, KeyParametersOption> keyAlgorithms;
    private Integer maxSize;
    private NotBeforeOption notBeforeOption;
    private List<SignAlgo> signatureAlgorithms;
    private Certprofile.SubjectControl subjectControl;
    private Validity validity;
    private boolean hasNoWellDefinedExpirationDate;
    private NotAfterMode notAfterMode;
    private Certprofile.X509CertVersion version;
    private XijsonExtensions extensions;

    private void reset() {
        this.certDomain = null;
        this.certLevel = null;
        this.keypairGenControl = null;
        this.serialNumberMode = null;
        this.keyAlgorithms = null;
        this.maxSize = null;
        this.signatureAlgorithms = null;
        this.notBeforeOption = null;
        this.subjectControl = null;
        this.validity = null;
        this.hasNoWellDefinedExpirationDate = false;
        this.notAfterMode = null;
        this.version = null;
        this.extensions = null;
        this.extraReset();
    }

    protected void extraReset() {
    }

    public void initialize(String data) throws CertprofileException {
        X509ProfileType conf;
        try {
            byte[] bytes = StringUtil.toUtf8Bytes((String)Args.notBlank((String)data, (String)"data"));
            conf = X509ProfileType.parse(bytes);
        }
        catch (RuntimeException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new CertprofileException("caught RuntimeException while parsing certprofile: " + ex.getMessage());
        }
        this.initialize(conf);
    }

    public void initialize(X509ProfileType conf) throws CertprofileException {
        Args.notNull((Object)((Object)conf), (String)"conf");
        this.reset();
        try {
            this.initialize0(conf);
        }
        catch (RuntimeException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new CertprofileException("caught RuntimeException while initializing certprofile: " + ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize0(X509ProfileType conf) throws CertprofileException {
        this.version = conf.getVersion();
        if (this.version == null) {
            this.version = Certprofile.X509CertVersion.v3;
        }
        if (conf.getSignatureAlgorithms() != null) {
            List<String> algoNames = conf.getSignatureAlgorithms();
            ArrayList<SignAlgo> list = new ArrayList<SignAlgo>(algoNames.size());
            for (String algoName : algoNames) {
                try {
                    list.add(SignAlgo.getInstance((String)algoName));
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.warn("unsupported signature algorithm: {}, ignore it", (Object)algoName);
                }
            }
            if (list.isEmpty()) {
                throw new CertprofileException("none of the signature algorithms is supported: " + conf.getSignatureAlgorithms());
            }
            this.signatureAlgorithms = Collections.unmodifiableList(list);
        }
        this.maxSize = conf.getMaxSize();
        if ("99991231235959Z".equalsIgnoreCase(conf.getValidity())) {
            this.hasNoWellDefinedExpirationDate = true;
            this.validity = null;
        } else {
            this.hasNoWellDefinedExpirationDate = false;
            this.validity = Validity.getInstance((String)conf.getValidity());
        }
        this.notAfterMode = conf.getNotAfterMode();
        this.certLevel = conf.getCertLevel();
        if (this.certLevel == null) {
            throw new CertprofileException("invalid CertLevel");
        }
        this.certDomain = conf.getCertDomain() == null ? Certprofile.CertDomain.RFC5280 : conf.getCertDomain();
        KeypairGenerationType kg = conf.getKeypairGeneration();
        this.serialNumberMode = conf.getSerialNumberMode();
        if (kg == null || XijsonCertprofile.booleanValue(kg.getForbidden(), false)) {
            this.keypairGenControl = KeypairGenControl.ForbiddenKeypairGenControl.INSTANCE;
        } else if (XijsonCertprofile.booleanValue(kg.getInheritCA(), false)) {
            this.keypairGenControl = KeypairGenControl.InheritCAKeypairGenControl.INSTANCE;
        } else {
            KeypairGenerationType.KeyType keyType = kg.getKeyType();
            ASN1ObjectIdentifier keyAlgOid = new ASN1ObjectIdentifier(kg.getAlgorithm().getOid());
            Map<String, String> params = kg.getParameters();
            if (keyType == KeypairGenerationType.KeyType.RSA) {
                int keySize = Integer.parseInt(params.get("keysize"));
                this.keypairGenControl = new KeypairGenControl.RSAKeypairGenControl(keySize, keyAlgOid);
            } else if (keyType == KeypairGenerationType.KeyType.EC) {
                ASN1ObjectIdentifier curveOid = new ASN1ObjectIdentifier(params.get("curve"));
                this.keypairGenControl = new KeypairGenControl.ECKeypairGenControl(curveOid, keyAlgOid);
            } else if (keyType == KeypairGenerationType.KeyType.DSA) {
                int plen = Integer.parseInt(params.get("plength"));
                String tmp = params.get("qlength");
                int qlen = tmp == null ? 0 : Integer.parseInt(tmp);
                this.keypairGenControl = new KeypairGenControl.DSAKeypairGenControl(plen, qlen, keyAlgOid);
            } else {
                if (keyType != KeypairGenerationType.KeyType.ED25519 && keyType != KeypairGenerationType.KeyType.ED448 && keyType != KeypairGenerationType.KeyType.X25519 && keyType != KeypairGenerationType.KeyType.X448) throw new CertprofileException("unknown KeypairGeneration type " + keyType);
                this.keypairGenControl = new KeypairGenControl.EDDSAKeypairGenControl(keyAlgOid);
            }
        }
        String str = conf.getNotBeforeTime().toLowerCase().trim();
        Long offsetSeconds = null;
        ZoneId midnightTimeZone = null;
        if (str.startsWith("midnight")) {
            int seperatorIdx = str.indexOf(58);
            String timezoneId = seperatorIdx == -1 ? "GMT+0" : str.substring(seperatorIdx + 1).toUpperCase();
            List<String> validIds = Arrays.asList("GMT+0", "GMT+1", "GMT+2", "GMT+3", "GMT+4", "GMT+5", "GMT+6", "GMT+7", "GMT+8", "GMT+9", "GMT+10", "GMT+11", "GMT+12", "GMT-0", "GMT-1", "GMT-2", "GMT-3", "GMT-4", "GMT-5", "GMT-6", "GMT-7", "GMT-8", "GMT-9", "GMT-10", "GMT-11", "GMT-12");
            if (!validIds.contains(timezoneId)) {
                throw new CertprofileException("invalid time zone id " + timezoneId);
            }
            midnightTimeZone = ZoneId.of(timezoneId);
        } else if ("current".equalsIgnoreCase(str)) {
            offsetSeconds = 0L;
        } else {
            long seconds;
            if (str.length() <= 2) throw new CertprofileException("invalid notBefore '" + str + "'");
            char sign = str.charAt(0);
            char suffix = str.charAt(str.length() - 1);
            if (sign != '+' && sign != '-') throw new CertprofileException("invalid notBefore '" + str + "'");
            long digit = Long.parseLong(str.substring(1, str.length() - 1));
            if (suffix == 'd') {
                seconds = digit * 86400L;
            } else if (suffix == 'h') {
                seconds = digit * 3600L;
            } else if (suffix == 'm') {
                seconds = digit * 60L;
            } else {
                if (suffix != 's') throw new CertprofileException("invalid notBefore " + str);
                seconds = digit;
            }
            offsetSeconds = sign == '+' ? seconds : -1L * seconds;
        }
        this.notBeforeOption = offsetSeconds != null ? NotBeforeOption.getOffsetOption(offsetSeconds) : NotBeforeOption.getMidNightOption(midnightTimeZone);
        this.keyAlgorithms = conf.toXiKeyAlgorithms();
        Subject subject = conf.getSubject();
        LinkedList<Certprofile.RdnControl> subjectDnControls = new LinkedList<Certprofile.RdnControl>();
        for (Subject.RdnType rdn : subject.getRdns()) {
            ASN1ObjectIdentifier type = new ASN1ObjectIdentifier(rdn.getType().getOid());
            Range range = rdn.getMinLen() != null || rdn.getMaxLen() != null ? new Range(rdn.getMinLen(), rdn.getMaxLen()) : null;
            Subject.ValueType value = rdn.getValue();
            Certprofile.RdnControl rdnControl = value == null ? new Certprofile.RdnControl(type, rdn.minOccurs(), rdn.maxOccurs()) : new Certprofile.RdnControl(type, value.getText(), value.isOverridable());
            subjectDnControls.add(rdnControl);
            rdnControl.setStringType(rdn.getStringType());
            rdnControl.setStringLengthRange(range);
            if (rdn.getRegex() != null) {
                rdnControl.setPattern(TextVadidator.compile((String)rdn.getRegex()));
            }
            rdnControl.setPrefix(rdn.getPrefix());
            rdnControl.setSuffix(rdn.getSuffix());
            rdnControl.setGroup(rdn.getGroup());
            if (rdn.getNotInSubject() != null) {
                rdnControl.setNotInSubject(rdn.getNotInSubject().booleanValue());
            }
            SubjectDnSpec.fixRdnControl((Certprofile.RdnControl)rdnControl);
        }
        this.subjectControl = new Certprofile.SubjectControl(subjectDnControls, subject.keepRdnOrder());
        this.extensions = new XijsonExtensions(this, conf, this.subjectControl);
    }

    protected boolean initExtraExtension(ExtensionType extn) throws CertprofileException {
        return false;
    }

    public boolean hasNoWellDefinedExpirationDate() {
        return this.hasNoWellDefinedExpirationDate;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public NotAfterMode getNotAfterMode() {
        return this.notAfterMode != null ? this.notAfterMode : super.getNotAfterMode();
    }

    protected void verifySubjectDnOccurrence(X500Name requestedSubject) throws BadCertTemplateException {
        ASN1ObjectIdentifier[] types = ((X500Name)Args.notNull((Object)requestedSubject, (String)"requestedSubject")).getAttributeTypes();
        Map<ASN1ObjectIdentifier, Certprofile.GeneralNameTag> subjectToSubjectAltNameModes = this.extensions.getSubjectToSubjectAltNameModes();
        for (ASN1ObjectIdentifier type : types) {
            Certprofile.RdnControl occu = this.subjectControl.getControl(type);
            if (occu == null) {
                if (subjectToSubjectAltNameModes != null && subjectToSubjectAltNameModes.containsKey(type)) continue;
                throw new BadCertTemplateException(String.format("subject DN of type %s is not allowed", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type)));
            }
            if (!occu.isValueOverridable()) {
                throw new BadCertTemplateException(String.format("subject DN of type %s is not allowed in the request", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type)));
            }
            RDN[] rdns = requestedSubject.getRDNs(type);
            if (rdns.length <= occu.getMaxOccurs() && rdns.length >= occu.getMinOccurs()) continue;
            throw new BadCertTemplateException(String.format("occurrence of subject DN of type %s not within the allowed range. %d is not within [%d, %d]", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type), rdns.length, occu.getMinOccurs(), occu.getMaxOccurs()));
        }
        for (ASN1ObjectIdentifier m : this.subjectControl.getTypes()) {
            Certprofile.RdnControl occurrence = this.subjectControl.getControl(m);
            if (occurrence.getValue() != null || occurrence.getMinOccurs() == 0) continue;
            boolean present = false;
            for (ASN1ObjectIdentifier type : types) {
                if (!occurrence.getType().equals((ASN1Primitive)type)) continue;
                present = true;
                break;
            }
            if (present) continue;
            throw new BadCertTemplateException(String.format("required subject DN of type %s is not present", ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)occurrence.getType())));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExtensionValues getExtensions(Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> extensionControls, X500Name requestedSubject, X500Name grantedSubject, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Instant notBefore, Instant notAfter, PublicCaInfo caInfo) throws CertprofileException, BadCertTemplateException {
        ExtensionValues extraExtensions;
        ASN1ObjectIdentifier[] gmtOids;
        ASN1EncodableVector vec;
        RDN[] admissionRdns;
        Extension extension;
        ASN1ObjectIdentifier type;
        HashSet<ASN1ObjectIdentifier> occurrences;
        ExtensionValues values;
        block98: {
            GeneralNames genNames;
            values = new ExtensionValues();
            if (CollectionUtil.isEmpty(extensionControls)) {
                return values;
            }
            Args.notNull((Object)requestedSubject, (String)"requestedSubject");
            Args.notNull((Object)notBefore, (String)"notBefore");
            Args.notNull((Object)notAfter, (String)"notAfter");
            occurrences = new HashSet<ASN1ObjectIdentifier>(extensionControls.keySet());
            type = Extension.policyMappings;
            ExtensionValue policyMappings = this.extensions.getPolicyMappings();
            if (policyMappings != null && occurrences.remove(type)) {
                values.addExtension(type, policyMappings);
            }
            if (occurrences.contains(type = Extension.subjectAlternativeName) && (genNames = this.extensions.createRequestedSubjectAltNames(requestedSubject, grantedSubject, requestedExtensions)) != null) {
                ExtensionValue value = new ExtensionValue(extensionControls.get(type).isCritical(), (ASN1Encodable)genNames);
                values.addExtension(type, value);
                occurrences.remove(type);
            }
            type = Extension.subjectDirectoryAttributes;
            extension = requestedExtensions == null ? null : requestedExtensions.get(type);
            SubjectDirectoryAttributesControl subjectDirAttrsControl = this.extensions.getSubjectDirAttrsControl();
            if (!occurrences.contains(type) || subjectDirAttrsControl == null || extension == null) break block98;
            ASN1GeneralizedTime dateOfBirth = null;
            String placeOfBirth = null;
            String gender = null;
            LinkedList<String> countryOfCitizenshipList = new LinkedList<String>();
            LinkedList<String> countryOfResidenceList = new LinkedList<String>();
            HashMap<ASN1ObjectIdentifier, List> otherAttrs = new HashMap<ASN1ObjectIdentifier, List>();
            RDN[] reqSubDirAttrs = SubjectDirectoryAttributes.getInstance((Object)extension.getParsedValue()).getAttributes();
            for (RDN reqSubDirAttr : reqSubDirAttrs) {
                String country;
                Attribute attr = (Attribute)reqSubDirAttr;
                ASN1ObjectIdentifier attrType = attr.getAttrType();
                ASN1Encodable attrVal = attr.getAttributeValues()[0];
                if (ObjectIdentifiers.DN.dateOfBirth.equals((ASN1Primitive)attrType)) {
                    dateOfBirth = ASN1GeneralizedTime.getInstance((Object)attrVal);
                    continue;
                }
                if (ObjectIdentifiers.DN.placeOfBirth.equals((ASN1Primitive)attrType)) {
                    placeOfBirth = DirectoryString.getInstance((Object)attrVal).getString();
                    continue;
                }
                if (ObjectIdentifiers.DN.gender.equals((ASN1Primitive)attrType)) {
                    gender = ASN1PrintableString.getInstance((Object)attrVal).getString();
                    continue;
                }
                if (ObjectIdentifiers.DN.countryOfCitizenship.equals((ASN1Primitive)attrType)) {
                    country = ASN1PrintableString.getInstance((Object)attrVal).getString();
                    countryOfCitizenshipList.add(country);
                    continue;
                }
                if (ObjectIdentifiers.DN.countryOfResidence.equals((ASN1Primitive)attrType)) {
                    country = ASN1PrintableString.getInstance((Object)attrVal).getString();
                    countryOfResidenceList.add(country);
                    continue;
                }
                List otherAttrVals = otherAttrs.computeIfAbsent(attrType, k -> new LinkedList());
                otherAttrVals.add(attrVal);
            }
            Vector<Attribute> attrs = new Vector<Attribute>();
            for (ASN1ObjectIdentifier attrType : subjectDirAttrsControl.getTypes()) {
                block99: {
                    if (ObjectIdentifiers.DN.dateOfBirth.equals((ASN1Primitive)attrType)) {
                        if (dateOfBirth != null) {
                            String timeStirng = dateOfBirth.getTimeString();
                            if (!TextVadidator.DATE_OF_BIRTH.isValid(timeStirng)) {
                                throw new BadCertTemplateException("invalid dateOfBirth " + timeStirng);
                            }
                            attrs.add(new Attribute(attrType, (ASN1Set)new DERSet((ASN1Encodable)dateOfBirth)));
                            continue;
                        }
                    } else if (ObjectIdentifiers.DN.placeOfBirth.equals((ASN1Primitive)attrType)) {
                        if (placeOfBirth != null) {
                            attrs.add(new Attribute(attrType, (ASN1Set)new DERSet((ASN1Encodable)new DERUTF8String(placeOfBirth))));
                            continue;
                        }
                    } else if (ObjectIdentifiers.DN.gender.equals((ASN1Primitive)attrType)) {
                        if (gender != null && !gender.isEmpty()) {
                            char ch = gender.charAt(0);
                            if (gender.length() != 1 || ch != 'f' && ch != 'F' && ch != 'm' && ch != 'M') {
                                throw new BadCertTemplateException("invalid gender " + gender);
                            }
                            attrs.add(new Attribute(attrType, (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(gender))));
                            continue;
                        }
                    } else if (ObjectIdentifiers.DN.countryOfCitizenship.equals((ASN1Primitive)attrType)) {
                        if (!countryOfCitizenshipList.isEmpty()) {
                            for (String country : countryOfCitizenshipList) {
                                if (!SubjectDnSpec.isValidCountryAreaCode((String)country)) {
                                    throw new BadCertTemplateException("invalid countryOfCitizenship code " + country);
                                }
                                attrs.add(new Attribute(attrType, (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(country))));
                            }
                            continue;
                        }
                    } else if (ObjectIdentifiers.DN.countryOfResidence.equals((ASN1Primitive)attrType)) {
                        if (!countryOfResidenceList.isEmpty()) {
                            for (String country : countryOfResidenceList) {
                                if (!SubjectDnSpec.isValidCountryAreaCode((String)country)) {
                                    throw new BadCertTemplateException("invalid countryOfResidence code " + country);
                                }
                                attrs.add(new Attribute(attrType, (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(country))));
                            }
                            continue;
                        }
                    } else if (otherAttrs.containsKey(attrType)) {
                        for (ASN1Encodable attrVal : (List)otherAttrs.get(attrType)) {
                            attrs.add(new Attribute(attrType, (ASN1Set)new DERSet(attrVal)));
                        }
                    }
                    break block99;
                    continue;
                }
                throw new BadCertTemplateException("could not process type " + attrType.getId() + " in extension SubjectDirectoryAttributes");
            }
            SubjectDirectoryAttributes subjDirAttrs = new SubjectDirectoryAttributes(attrs);
            ExtensionValue extValue2 = new ExtensionValue(extensionControls.get(type).isCritical(), (ASN1Encodable)subjDirAttrs);
            values.addExtension(type, extValue2);
            occurrences.remove(type);
        }
        type = Extension.nameConstraints;
        ExtensionValue nameConstraints = this.extensions.getNameConstraints();
        if (nameConstraints != null && occurrences.remove(type)) {
            values.addExtension(type, nameConstraints);
        }
        type = Extension.policyConstraints;
        ExtensionValue policyConstraints = this.extensions.getPolicyConstraints();
        if (policyConstraints != null && occurrences.remove(type)) {
            values.addExtension(type, policyConstraints);
        }
        type = Extension.inhibitAnyPolicy;
        ExtensionValue inhibitAnyPolicy = this.extensions.getInhibitAnyPolicy();
        if (inhibitAnyPolicy != null && occurrences.remove(type)) {
            values.addExtension(type, inhibitAnyPolicy);
        }
        if ((admissionRdns = requestedSubject.getRDNs(type = ObjectIdentifiers.Extn.id_extension_admission)) != null && admissionRdns.length == 0) {
            admissionRdns = null;
        }
        AdmissionExtension.AdmissionSyntaxOption admission = this.extensions.getAdmission();
        if (occurrences.contains(type) && admission != null) {
            if (admission.isInputFromRequestRequired()) {
                if (admissionRdns == null) {
                    throw new BadCertTemplateException("admission required in the request but not present");
                }
                LinkedList<List<String>> reqRegNumsList = new LinkedList<List<String>>();
                for (RDN m : admissionRdns) {
                    String str = X509Util.rdnValueToString((ASN1Encodable)m.getFirst().getValue());
                    ConfPairs pairs = new ConfPairs(str);
                    for (String name : pairs.names()) {
                        if (!"registrationNumber".equalsIgnoreCase(name)) continue;
                        reqRegNumsList.add(StringUtil.split((String)pairs.value(name), (String)" ,;:"));
                    }
                }
                values.addExtension(type, admission.getExtensionValue(reqRegNumsList));
                occurrences.remove(type);
            } else {
                values.addExtension(type, admission.getExtensionValue(null));
                occurrences.remove(type);
            }
        }
        type = ObjectIdentifiers.Extn.id_extension_restriction;
        ExtensionValue restriction = this.extensions.getRestriction();
        if (restriction != null && occurrences.remove(type)) {
            values.addExtension(type, restriction);
        }
        type = ObjectIdentifiers.Extn.id_extension_additionalInformation;
        ExtensionValue additionalInformation = this.extensions.getAdditionalInformation();
        if (additionalInformation != null && occurrences.remove(type)) {
            values.addExtension(type, additionalInformation);
        }
        type = ObjectIdentifiers.Extn.id_extension_validityModel;
        ExtensionValue validityModel = this.extensions.getValidityModel();
        if (validityModel != null && occurrences.remove(type)) {
            values.addExtension(type, validityModel);
        }
        if (occurrences.contains(type = Extension.privateKeyUsagePeriod)) {
            Instant tmpNotAfter;
            Validity privateKeyUsagePeriod = this.extensions.getPrivateKeyUsagePeriod();
            if (privateKeyUsagePeriod == null) {
                tmpNotAfter = notAfter;
            } else {
                tmpNotAfter = privateKeyUsagePeriod.add(notBefore);
                if (tmpNotAfter.isAfter(notAfter)) {
                    tmpNotAfter = notAfter;
                }
            }
            ASN1EncodableVector vec2 = new ASN1EncodableVector();
            vec2.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERGeneralizedTime(Date.from(notBefore))));
            vec2.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERGeneralizedTime(Date.from(tmpNotAfter))));
            ExtensionValue extValue3 = new ExtensionValue(extensionControls.get(type).isCritical(), (ASN1Encodable)new DERSequence(vec2));
            values.addExtension(type, extValue3);
            occurrences.remove(type);
        }
        type = Extension.qCStatements;
        ExtensionValue qcStatments = this.extensions.getQcStatments();
        List<QcStatementOption> qcStatementsOption = this.extensions.getQcStatementsOption();
        if (occurrences.contains(type) && (qcStatments != null || qcStatementsOption != null)) {
            if (qcStatments != null) {
                values.addExtension(type, qcStatments);
                occurrences.remove(type);
            } else if (requestedExtensions != null) {
                extension = requestedExtensions.get(type);
                if (extension == null) {
                    throw new BadCertTemplateException("No QCStatement extension is contained in the request");
                }
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)extension.getParsedValue());
                HashMap<String, int[]> qcEuLimits = new HashMap<String, int[]>();
                int n = seq.size();
                for (int i = 0; i < n; ++i) {
                    QCStatement qCStatement = QCStatement.getInstance((Object)seq.getObjectAt(i));
                    if (!ObjectIdentifiers.Extn.id_etsi_qcs_QcLimitValue.equals((ASN1Primitive)qCStatement.getStatementId())) continue;
                    MonetaryValue monetaryValue = MonetaryValue.getInstance((Object)qCStatement.getStatementInfo());
                    int amount = monetaryValue.getAmount().intValue();
                    int exponent = monetaryValue.getExponent().intValue();
                    Iso4217CurrencyCode currency = monetaryValue.getCurrency();
                    String currencyS = currency.isAlphabetic() ? currency.getAlphabetic().toUpperCase() : Integer.toString(currency.getNumeric());
                    qcEuLimits.put(currencyS, new int[]{amount, exponent});
                }
                vec = new ASN1EncodableVector();
                for (QcStatementOption m : qcStatementsOption) {
                    if (m.getStatement() != null) {
                        vec.add((ASN1Encodable)m.getStatement());
                        continue;
                    }
                    MonetaryValueOption monetaryOption = m.getMonetaryValueOption();
                    String currencyS = monetaryOption.getCurrencyString();
                    int[] limit = (int[])qcEuLimits.get(currencyS);
                    if (limit == null) {
                        throw new BadCertTemplateException("no EuLimitValue is specified for currency '" + currencyS + "'");
                    }
                    int amount = limit[0];
                    QcStatements.Range2Type range = monetaryOption.getAmountRange();
                    if (amount < range.getMin() || amount > range.getMax()) {
                        throw new BadCertTemplateException("amount for currency '" + currencyS + "' is not within [" + range.getMin() + ", " + range.getMax() + "]");
                    }
                    int exponent = limit[1];
                    range = monetaryOption.getExponentRange();
                    if (exponent < range.getMin() || exponent > range.getMax()) {
                        throw new BadCertTemplateException("exponent for currency '" + currencyS + "' is not within [" + range.getMin() + ", " + range.getMax() + "]");
                    }
                    MonetaryValue monetaryVale = new MonetaryValue(monetaryOption.getCurrency(), amount, exponent);
                    QCStatement qcStatment = new QCStatement(m.getStatementId(), (ASN1Encodable)monetaryVale);
                    vec.add((ASN1Encodable)qcStatment);
                }
                ExtensionValue extensionValue = new ExtensionValue(extensionControls.get(type).isCritical(), (ASN1Encodable)new DERSequence(vec));
                values.addExtension(type, extensionValue);
                occurrences.remove(type);
            }
        }
        type = Extension.biometricInfo;
        extension = requestedExtensions == null ? null : requestedExtensions.get(type);
        BiometricInfoOption biometricInfo = this.extensions.getBiometricInfo();
        if (occurrences.contains(type) && biometricInfo != null && extension != null) {
            void var28_53;
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)extension.getParsedValue());
            int n = seq.size();
            if (n < 1) {
                throw new BadCertTemplateException("biometricInfo extension in request contains empty sequence");
            }
            vec = new ASN1EncodableVector();
            boolean bl = false;
            while (var28_53 < n) {
                HashAlgo hashAlgo;
                BiometricData bd = BiometricData.getInstance((Object)seq.getObjectAt((int)var28_53));
                TypeOfBiometricData bdType = bd.getTypeOfBiometricData();
                if (!biometricInfo.isTypePermitted(bdType)) {
                    throw new BadCertTemplateException("biometricInfo[" + (int)var28_53 + "].typeOfBiometricData is not permitted");
                }
                try {
                    hashAlgo = HashAlgo.getInstance((AlgorithmIdentifier)bd.getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new CertprofileException("biometricInfo[" + (int)var28_53 + "].hashAlgorithm: " + ex.getMessage());
                }
                if (!biometricInfo.isHashAlgorithmPermitted(hashAlgo)) {
                    throw new BadCertTemplateException("biometricInfo[" + (int)var28_53 + "].hashAlgorithm is not permitted");
                }
                int expHashValueSize = hashAlgo.getLength();
                byte[] hashValue = bd.getBiometricDataHash().getOctets();
                if (hashValue.length != expHashValueSize) {
                    throw new BadCertTemplateException("biometricInfo[" + (int)var28_53 + "].biometricDataHash has incorrect length");
                }
                ASN1IA5String sourceDataUri = bd.getSourceDataUriIA5();
                TripleState occurrence = biometricInfo.getSourceDataUriOccurrence();
                if (occurrence == TripleState.forbidden) {
                    sourceDataUri = null;
                } else if (occurrence == TripleState.required && sourceDataUri == null) {
                    throw new BadCertTemplateException("biometricInfo[" + (int)var28_53 + "].sourceDataUri is not specified in request but is required");
                }
                BiometricData newBiometricData = new BiometricData(bdType, hashAlgo.getAlgorithmIdentifier(), (ASN1OctetString)new DEROctetString(hashValue), sourceDataUri);
                vec.add((ASN1Encodable)newBiometricData);
                ++var28_53;
            }
            ExtensionValue extensionValue = new ExtensionValue(extensionControls.get(type).isCritical(), (ASN1Encodable)new DERSequence(vec));
            values.addExtension(type, extensionValue);
            occurrences.remove(type);
        }
        type = ObjectIdentifiers.Extn.id_pe_tlsfeature;
        ExtensionValue tlsFeature = this.extensions.getTlsFeature();
        if (tlsFeature != null && occurrences.remove(type)) {
            values.addExtension(type, tlsFeature);
        }
        type = ObjectIdentifiers.Extn.id_smimeCapabilities;
        ExtensionValue smimeCapabilities = this.extensions.getSmimeCapabilities();
        if (smimeCapabilities != null && occurrences.remove(type)) {
            values.addExtension(type, smimeCapabilities);
        }
        if (occurrences.contains(type = ObjectIdentifiers.Extn.id_GMT_0015_IdentityCode)) {
            void var28_62;
            int tag = -1;
            Object var28_56 = null;
            Extension extension2 = extension = requestedExtensions == null ? null : requestedExtensions.get(type);
            if (extension != null) {
                ASN1Encodable reqExtnValue = extension.getParsedValue();
                if (reqExtnValue instanceof ASN1TaggedObject) {
                    ASN1TaggedObject tagged = (ASN1TaggedObject)reqExtnValue;
                    tag = tagged.getTagNo();
                    if (tagged.isExplicit()) {
                        String string = ((ASN1String)tagged.getBaseObject()).getString();
                    } else if (tag == 0 || tag == 2) {
                        String string = ASN1PrintableString.getInstance((ASN1TaggedObject)tagged, (boolean)false).getString();
                    } else if (tag == 1) {
                        String string = ASN1UTF8String.getInstance((ASN1TaggedObject)tagged, (boolean)false).getString();
                    }
                }
            } else {
                String str;
                RDN[] rdns = requestedSubject.getRDNs(type);
                if (rdns != null && rdns.length > 0 && (str = X509Util.rdnValueToString((ASN1Encodable)rdns[0].getFirst().getValue())).length() > 3 && str.charAt(0) == '[' && str.charAt(2) == ']') {
                    tag = Integer.parseInt(str.substring(1, 2));
                    String string = str.substring(3);
                }
            }
            if (StringUtil.isNotBlank((String)var28_62)) {
                boolean explicit = true;
                DERTaggedObject extnValue = null;
                if (tag == 0 || tag == 2) {
                    extnValue = new DERTaggedObject(true, tag, (ASN1Encodable)new DERPrintableString((String)var28_62));
                } else if (tag == 1) {
                    extnValue = new DERTaggedObject(true, tag, (ASN1Encodable)new DERUTF8String((String)var28_62));
                }
                if (extnValue != null) {
                    occurrences.remove(type);
                    values.addExtension(type, new ExtensionValue(extensionControls.get(type).isCritical(), (ASN1Encodable)extnValue));
                }
            }
        }
        if ((type = this.extensions.getCccExtensionSchemaType()) != null && occurrences.remove(type)) {
            values.addExtension(type, this.extensions.getCccExtensionSchemaValue());
        }
        for (ASN1ObjectIdentifier m : gmtOids = new ASN1ObjectIdentifier[]{ObjectIdentifiers.Extn.id_GMT_0015_InsuranceNumber, ObjectIdentifiers.Extn.id_GMT_0015_ICRegistrationNumber, ObjectIdentifiers.Extn.id_GMT_0015_OrganizationCode, ObjectIdentifiers.Extn.id_GMT_0015_TaxationNumber}) {
            if (!occurrences.contains(m)) continue;
            String extnStr = null;
            Extension extension3 = extension = requestedExtensions == null ? null : requestedExtensions.get(m);
            if (extension != null) {
                extnStr = ((ASN1String)extension.getParsedValue()).getString();
            } else {
                RDN[] rdns = requestedSubject.getRDNs(m);
                if (rdns != null && rdns.length > 0) {
                    extnStr = X509Util.rdnValueToString((ASN1Encodable)rdns[0].getFirst().getValue());
                }
            }
            if (!StringUtil.isNotBlank((String)extnStr)) continue;
            occurrences.remove(m);
            DERPrintableString extnValue = new DERPrintableString(extnStr);
            values.addExtension(m, new ExtensionValue(extensionControls.get(m).isCritical(), (ASN1Encodable)extnValue));
        }
        Map<ASN1ObjectIdentifier, ExtensionValue> map = this.extensions.getConstantExtensions();
        if (map != null) {
            for (Map.Entry<ASN1ObjectIdentifier, ExtensionValue> entry : map.entrySet()) {
                ExtensionValue extensionValue;
                ASN1ObjectIdentifier m = entry.getKey();
                if (!occurrences.remove(m) || (extensionValue = entry.getValue()) == null) continue;
                values.addExtension(m, extensionValue);
            }
        }
        if ((extraExtensions = this.getExtraExtensions(extensionControls, requestedSubject, grantedSubject, requestedExtensions, notBefore, notAfter, caInfo)) != null) {
            for (ASN1ObjectIdentifier m : extraExtensions.getExtensionTypes()) {
                values.addExtension(m, extraExtensions.getExtensionValue(m));
            }
        }
        return values;
    }

    protected ExtensionValues getExtraExtensions(Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> extensionOccurrences, X500Name requestedSubject, X500Name grantedSubject, Map<ASN1ObjectIdentifier, Extension> requestedExtensions, Instant notBefore, Instant notAfter, PublicCaInfo caInfo) throws CertprofileException, BadCertTemplateException {
        return null;
    }

    public Set<Certprofile.KeyUsageControl> getKeyUsage() {
        return this.extensions.getKeyusages();
    }

    public Set<Certprofile.ExtKeyUsageControl> getExtendedKeyUsages() {
        return this.extensions.getExtendedKeyusages();
    }

    public Certprofile.CertLevel getCertLevel() {
        return this.certLevel;
    }

    public Certprofile.CertDomain getCertDomain() {
        return this.certDomain;
    }

    public KeypairGenControl getKeypairGenControl() {
        return this.keypairGenControl;
    }

    public String getSerialNumberMode() {
        return this.serialNumberMode;
    }

    public Integer getPathLenBasicConstraint() {
        return this.extensions.getPathLen();
    }

    public Certprofile.AuthorityInfoAccessControl getAiaControl() {
        return this.extensions.getAiaControl();
    }

    public Certprofile.CrlDistributionPointsControl getCrlDpControl() {
        return this.extensions.getCrlDpControl();
    }

    public Certprofile.CrlDistributionPointsControl getFreshestCrlControl() {
        return this.extensions.getFreshestCrlControl();
    }

    public Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> getExtensionControls() {
        return this.extensions.getExtensionControls();
    }

    public int getMaxCertSize() {
        return this.maxSize == null ? super.getMaxCertSize() : this.maxSize.intValue();
    }

    public boolean useIssuerAndSerialInAki() {
        return this.extensions.isUseIssuerAndSerialInAki();
    }

    protected SubjectKeyIdentifierControl getSubjectKeyIdentifierControl() {
        return this.extensions.getSubjectKeyIdentifier();
    }

    public Certprofile.SubjectControl getSubjectControl() {
        return this.subjectControl;
    }

    public NotBeforeOption getNotBeforeOption() {
        return this.notBeforeOption;
    }

    public Instant getNotBefore(Instant requestedNotBefore) {
        return this.notBeforeOption.getNotBefore(requestedNotBefore);
    }

    public Map<ASN1ObjectIdentifier, KeyParametersOption> getKeyAlgorithms() {
        return this.keyAlgorithms;
    }

    public Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> getSubjectInfoAccessModes() {
        return this.extensions.getSubjectInfoAccessModes();
    }

    public Certprofile.X509CertVersion getVersion() {
        return this.version;
    }

    public XijsonExtensions extensions() {
        return this.extensions;
    }

    public List<SignAlgo> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public Set<Certprofile.GeneralNameMode> getSubjectAltNameModes() {
        return this.extensions.getSubjectAltNameModes();
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public CertificatePolicies getCertificatePolicies() {
        return this.extensions.getCertificatePolicies();
    }

    private static boolean booleanValue(Boolean boolObj, boolean dfltValue) {
        return Objects.requireNonNullElse(boolObj, dfltValue);
    }
}

