/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.xipki.ca.api.profile.BaseCertprofile;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.ca.api.profile.SubjectKeyIdentifierControl;
import org.xipki.ca.certprofile.xijson.AdmissionExtension;
import org.xipki.ca.certprofile.xijson.BiometricInfoOption;
import org.xipki.ca.certprofile.xijson.MonetaryValueOption;
import org.xipki.ca.certprofile.xijson.QcStatementOption;
import org.xipki.ca.certprofile.xijson.SubjectDirectoryAttributesControl;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.GeneralNameType;
import org.xipki.ca.certprofile.xijson.conf.SubjectToSubjectAltNameType;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.ca.certprofile.xijson.conf.extn.AdditionalInformation;
import org.xipki.ca.certprofile.xijson.conf.extn.AdmissionSyntax;
import org.xipki.ca.certprofile.xijson.conf.extn.AuthorityInfoAccess;
import org.xipki.ca.certprofile.xijson.conf.extn.AuthorityKeyIdentifier;
import org.xipki.ca.certprofile.xijson.conf.extn.BasicConstraints;
import org.xipki.ca.certprofile.xijson.conf.extn.BiometricInfo;
import org.xipki.ca.certprofile.xijson.conf.extn.CCCSimpleExtensionSchema;
import org.xipki.ca.certprofile.xijson.conf.extn.CertificatePolicies;
import org.xipki.ca.certprofile.xijson.conf.extn.CrlDistributionPoints;
import org.xipki.ca.certprofile.xijson.conf.extn.ExtendedKeyUsage;
import org.xipki.ca.certprofile.xijson.conf.extn.InhibitAnyPolicy;
import org.xipki.ca.certprofile.xijson.conf.extn.KeyUsage;
import org.xipki.ca.certprofile.xijson.conf.extn.NameConstraints;
import org.xipki.ca.certprofile.xijson.conf.extn.PolicyConstraints;
import org.xipki.ca.certprofile.xijson.conf.extn.PolicyMappings;
import org.xipki.ca.certprofile.xijson.conf.extn.PrivateKeyUsagePeriod;
import org.xipki.ca.certprofile.xijson.conf.extn.QcStatements;
import org.xipki.ca.certprofile.xijson.conf.extn.Restriction;
import org.xipki.ca.certprofile.xijson.conf.extn.SmimeCapabilities;
import org.xipki.ca.certprofile.xijson.conf.extn.SubjectDirectoryAttributs;
import org.xipki.ca.certprofile.xijson.conf.extn.SubjectInfoAccess;
import org.xipki.ca.certprofile.xijson.conf.extn.TlsFeature;
import org.xipki.ca.certprofile.xijson.conf.extn.ValidityModel;
import org.xipki.pki.BadCertTemplateException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class XijsonExtensions {
    private ExtensionValue additionalInformation;
    private AdmissionExtension.AdmissionSyntaxOption admission;
    private Certprofile.AuthorityInfoAccessControl aiaControl;
    private Certprofile.CrlDistributionPointsControl crlDpControl;
    private Certprofile.CrlDistributionPointsControl freshestCrlControl;
    private Map<ASN1ObjectIdentifier, Certprofile.GeneralNameTag> subjectToSubjectAltNameModes;
    private Set<Certprofile.GeneralNameMode> subjectAltNameModes;
    private Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> subjectInfoAccessModes;
    private BiometricInfoOption biometricInfo;
    private org.bouncycastle.asn1.x509.CertificatePolicies certificatePolicies;
    private final Map<ASN1ObjectIdentifier, ExtensionValue> constantExtensions;
    private Set<Certprofile.ExtKeyUsageControl> extendedKeyusages;
    private final Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> extensionControls;
    private boolean useIssuerAndSerialInAki;
    private SubjectKeyIdentifierControl subjectKeyIdentifier;
    private ExtensionValue inhibitAnyPolicy;
    private Set<Certprofile.KeyUsageControl> keyusages;
    private ExtensionValue nameConstraints;
    private Integer pathLen;
    private ExtensionValue policyConstraints;
    private ExtensionValue policyMappings;
    private Validity privateKeyUsagePeriod;
    private ExtensionValue qcStatments;
    private List<QcStatementOption> qcStatementsOption;
    private ExtensionValue restriction;
    private ExtensionValue smimeCapabilities;
    private ExtensionValue tlsFeature;
    private ExtensionValue validityModel;
    private SubjectDirectoryAttributesControl subjectDirAttrsControl;
    private ASN1ObjectIdentifier cccExtensionSchemaType;
    private ExtensionValue cccExtensionSchemaValue;

    XijsonExtensions(XijsonCertprofile certProfile, X509ProfileType conf, Certprofile.SubjectControl subjectControl) throws CertprofileException {
        ASN1ObjectIdentifier type;
        Args.notNull((Object)subjectControl, (String)"subjectControl");
        Map<String, ExtensionType> extensions = ((X509ProfileType)((Object)Args.notNull((Object)((Object)conf), (String)"conf"))).buildExtensions();
        this.extensionControls = conf.buildExtensionControls();
        HashSet<ASN1ObjectIdentifier> extnIds = new HashSet<ASN1ObjectIdentifier>(this.extensionControls.keySet());
        this.initSubjectToSubjectAltNames(conf.getSubjectToSubjectAltNames());
        this.initAdditionalInformation(extnIds, extensions);
        this.initAdmission(extnIds, extensions);
        this.initAuthorityInfoAccess(extnIds, extensions);
        this.initAuthorityKeyIdentifier(extnIds, extensions);
        this.initSubjectKeyIdentifier(extnIds, extensions);
        this.initBasicConstraints(extnIds, extensions);
        this.initBiometricInfo(extnIds, extensions);
        this.initCertificatePolicies(extnIds, extensions);
        this.initCrlDistributionPoints(extnIds, extensions);
        this.initExtendedKeyUsage(extnIds, extensions);
        this.initFreshestCrl(extnIds, extensions);
        this.initInhibitAnyPolicy(extnIds, extensions);
        this.initKeyUsage(extnIds, extensions);
        this.initNameConstraints(extnIds, extensions);
        this.initPolicyConstraints(extnIds, extensions);
        this.initPolicyMappings(extnIds, extensions);
        this.initPrivateKeyUsagePeriod(extnIds, extensions);
        this.initQcStatements(extnIds, extensions);
        this.initRestriction(extnIds, extensions);
        this.initSmimeCapabilities(extnIds, extensions);
        this.initSubjectAlternativeName(extnIds, extensions);
        this.initSubjectInfoAccess(extnIds, extensions);
        this.initTlsFeature(extnIds, extensions);
        this.initValidityModel(extnIds, extensions);
        this.initSubjectDirAttrs(extnIds, extensions);
        this.initGmt0015Extensions(extnIds);
        this.initCCCExtensionSchemas(extnIds, extensions);
        this.constantExtensions = conf.buildConstantExtesions();
        if (this.constantExtensions != null) {
            extnIds.removeAll(this.constantExtensions.keySet());
        }
        if (subjectControl.getControl(ObjectIdentifiers.DN.emailAddress) != null) {
            type = ObjectIdentifiers.DN.emailAddress;
            if (this.subjectToSubjectAltNameModes == null || this.subjectToSubjectAltNameModes.get(type) == null) {
                throw new CertprofileException("subjectToSubjectAltNames for " + ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type) + " must be configured if subject RDN emailAddress is permitted");
            }
            Certprofile.GeneralNameTag nameTag = this.subjectToSubjectAltNameModes.get(type);
            if (nameTag != Certprofile.GeneralNameTag.rfc822Name) {
                throw new CertprofileException("For the RDN " + ObjectIdentifiers.DN.emailAddress.getId() + ", only target SubjectAltName type rfc822Name is permitted, but not " + nameTag);
            }
        }
        if (this.subjectToSubjectAltNameModes != null) {
            type = Extension.subjectAlternativeName;
            if (!this.extensionControls.containsKey(type)) {
                throw new CertprofileException("subjectToSubjectAltNames cannot be configured if extension subjectAltNames is not permitted");
            }
            if (this.subjectAltNameModes != null) {
                for (Map.Entry<ASN1ObjectIdentifier, Certprofile.GeneralNameTag> entry : this.subjectToSubjectAltNameModes.entrySet()) {
                    Certprofile.GeneralNameTag nameTag = entry.getValue();
                    boolean allowed = false;
                    for (Certprofile.GeneralNameMode m : this.subjectAltNameModes) {
                        if (m.getTag() != nameTag) continue;
                        allowed = true;
                        break;
                    }
                    if (allowed) continue;
                    throw new CertprofileException("target SubjectAltName type " + nameTag + " is not allowed");
                }
            }
        }
        Arrays.asList(Extension.issuerAlternativeName, Extension.authorityInfoAccess, Extension.cRLDistributionPoints, Extension.freshestCRL, Extension.subjectKeyIdentifier, Extension.subjectInfoAccess, ObjectIdentifiers.Extn.id_extension_pkix_ocsp_nocheck, ObjectIdentifiers.Extn.id_SCTs).forEach(extnIds::remove);
        HashSet<ASN1ObjectIdentifier> copyOfExtnIds = new HashSet<ASN1ObjectIdentifier>(extnIds);
        for (ASN1ObjectIdentifier extnId : copyOfExtnIds) {
            ExtensionType extn = XijsonExtensions.getExtension(extnId, extensions);
            boolean processed = certProfile.initExtraExtension(extn);
            if (!processed) continue;
            extnIds.remove(extnId);
        }
        if (!extnIds.isEmpty()) {
            throw new CertprofileException("Cannot process the extensions: " + extnIds);
        }
    }

    private void initSubjectToSubjectAltNames(List<SubjectToSubjectAltNameType> list) throws CertprofileException {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.subjectToSubjectAltNameModes = new HashMap<ASN1ObjectIdentifier, Certprofile.GeneralNameTag>();
        for (SubjectToSubjectAltNameType m : list) {
            Certprofile.GeneralNameTag targetTag = m.getTarget();
            switch (targetTag) {
                case rfc822Name: 
                case DNSName: 
                case uniformResourceIdentifier: 
                case IPAddress: 
                case directoryName: 
                case registeredID: {
                    break;
                }
                default: {
                    throw new CertprofileException("unsupported target tag " + targetTag);
                }
            }
            this.subjectToSubjectAltNameModes.put(new ASN1ObjectIdentifier(m.getSource().getOid()), targetTag);
        }
    }

    private void initAdditionalInformation(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_extension_additionalInformation;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            AdditionalInformation extConf = XijsonExtensions.getExtension(type, extensions).getAdditionalInformation();
            if (extConf != null) {
                this.additionalInformation = new ExtensionValue(this.critical(type), extConf.getType().createDirectoryString(extConf.getText()));
            }
        }
    }

    private void initAdmission(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_extension_admission;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            ExtensionType extn = XijsonExtensions.getExtension(type, extensions);
            AdmissionSyntax extConf = extn.getAdmissionSyntax();
            if (extConf != null) {
                this.admission = extConf.toXiAdmissionSyntax(this.critical(type));
                if (!extn.permittedInRequest() && this.admission.isInputFromRequestRequired()) {
                    throw new CertprofileException("Extension " + ObjectIdentifiers.getName((ASN1ObjectIdentifier)type) + " should be permitted in request");
                }
            }
        }
    }

    private void initAuthorityInfoAccess(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.authorityInfoAccess;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            AuthorityInfoAccess extConf = XijsonExtensions.getExtension(type, extensions).getAuthorityInfoAccess();
            this.aiaControl = extConf == null ? new Certprofile.AuthorityInfoAccessControl(false, true, null, null) : new Certprofile.AuthorityInfoAccessControl(extConf.isIncludeCaIssuers(), extConf.isIncludeOcsp(), extConf.getCaIssuersProtocols(), extConf.getOcspProtocols());
        }
    }

    private void initAuthorityKeyIdentifier(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.authorityKeyIdentifier;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            AuthorityKeyIdentifier extConf = XijsonExtensions.getExtension(type, extensions).getAuthorityKeyIdentifier();
            this.useIssuerAndSerialInAki = extConf != null && extConf.isUseIssuerAndSerial();
        }
    }

    private void initSubjectKeyIdentifier(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.subjectKeyIdentifier;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            this.subjectKeyIdentifier = XijsonExtensions.getExtension(type, extensions).getSubjectKeyIdentifier();
        }
    }

    private void initBasicConstraints(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.basicConstraints;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            BasicConstraints extConf = XijsonExtensions.getExtension(type, extensions).getBasicConstraints();
            if (extConf == null) {
                extConf = XijsonExtensions.getExtension(type, extensions).getBasicConstraints();
            }
            if (extConf != null) {
                this.pathLen = extConf.getPathLen();
            }
        }
    }

    private void initBiometricInfo(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.biometricInfo;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            BiometricInfo extConf = XijsonExtensions.getExtension(type, extensions).getBiometricInfo();
            if (extConf != null) {
                try {
                    this.biometricInfo = new BiometricInfoOption(extConf);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new CertprofileException("NoSuchAlgorithmException: " + ex.getMessage());
                }
            }
        }
    }

    private void initCertificatePolicies(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.certificatePolicies;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            CertificatePolicies extConf = XijsonExtensions.getExtension(type, extensions).getCertificatePolicies();
            if (extConf != null) {
                this.certificatePolicies = extConf.toXiCertificatePolicies();
            }
        }
    }

    private void initCrlDistributionPoints(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.cRLDistributionPoints;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            CrlDistributionPoints extConf = XijsonExtensions.getExtension(type, extensions).getCrlDistributionPoints();
            this.crlDpControl = new Certprofile.CrlDistributionPointsControl(extConf == null ? null : extConf.getProtocols());
        }
    }

    private void initExtendedKeyUsage(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.extendedKeyUsage;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            ExtendedKeyUsage extConf = XijsonExtensions.getExtension(type, extensions).getExtendedKeyUsage();
            if (extConf != null) {
                this.extendedKeyusages = extConf.toXiExtKeyUsageOptions();
            }
        }
    }

    private void initFreshestCrl(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.freshestCRL;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            CrlDistributionPoints extConf = XijsonExtensions.getExtension(type, extensions).getFreshestCrl();
            this.freshestCrlControl = new Certprofile.CrlDistributionPointsControl(extConf == null ? null : extConf.getProtocols());
        }
    }

    private void initInhibitAnyPolicy(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.inhibitAnyPolicy;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            InhibitAnyPolicy extConf = XijsonExtensions.getExtension(type, extensions).getInhibitAnyPolicy();
            if (extConf != null) {
                int skipCerts = extConf.getSkipCerts();
                if (skipCerts < 0) {
                    throw new CertprofileException("negative inhibitAnyPolicy.skipCerts is not allowed: " + skipCerts);
                }
                this.inhibitAnyPolicy = new ExtensionValue(this.critical(type), (ASN1Encodable)new ASN1Integer(BigInteger.valueOf(skipCerts)));
            }
        }
    }

    private void initKeyUsage(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.keyUsage;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            KeyUsage extConf = XijsonExtensions.getExtension(type, extensions).getKeyUsage();
            if (extConf != null) {
                this.keyusages = extConf.toXiKeyUsageOptions();
            }
        }
    }

    private void initNameConstraints(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.nameConstraints;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            NameConstraints extConf = XijsonExtensions.getExtension(type, extensions).getNameConstraints();
            if (extConf != null) {
                this.nameConstraints = new ExtensionValue(this.critical(type), (ASN1Encodable)extConf.toXiNameConstraints());
            }
        }
    }

    private void initPrivateKeyUsagePeriod(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.privateKeyUsagePeriod;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            PrivateKeyUsagePeriod extConf = XijsonExtensions.getExtension(type, extensions).getPrivateKeyUsagePeriod();
            if (extConf != null) {
                this.privateKeyUsagePeriod = Validity.getInstance((String)extConf.getValidity());
            }
        }
    }

    private void initPolicyConstraints(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.policyConstraints;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            PolicyConstraints extConf = XijsonExtensions.getExtension(type, extensions).getPolicyConstraints();
            if (extConf != null) {
                this.policyConstraints = new ExtensionValue(this.critical(type), (ASN1Encodable)extConf.toXiPolicyConstraints());
            }
        }
    }

    private void initPolicyMappings(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.policyMappings;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            PolicyMappings extConf = XijsonExtensions.getExtension(type, extensions).getPolicyMappings();
            if (extConf != null) {
                this.policyMappings = new ExtensionValue(this.critical(type), (ASN1Encodable)extConf.toXiPolicyMappings());
            }
        }
    }

    private void initQcStatements(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.qCStatements;
        if (!this.extensionControls.containsKey(type)) {
            return;
        }
        extnIds.remove(type);
        QcStatements extConf = XijsonExtensions.getExtension(type, extensions).getQcStatements();
        if (extConf == null) {
            return;
        }
        List<QcStatements.QcStatementType> qcStatementTypes = extConf.getQcStatements();
        this.qcStatementsOption = new ArrayList<QcStatementOption>(qcStatementTypes.size());
        HashSet<String> currencyCodes = new HashSet<String>();
        boolean requireInfoFromReq = false;
        for (QcStatements.QcStatementType m : qcStatementTypes) {
            QcStatementOption qcStatementOption;
            ASN1ObjectIdentifier qcStatementId = new ASN1ObjectIdentifier(m.getStatementId().getOid());
            QcStatements.QcStatementValueType statementValue = m.getStatementValue();
            if (statementValue == null) {
                qcStatementOption = new QcStatementOption(new QCStatement(qcStatementId));
            } else if (statementValue.getQcRetentionPeriod() != null) {
                QCStatement qcStatment = new QCStatement(qcStatementId, (ASN1Encodable)new ASN1Integer((long)statementValue.getQcRetentionPeriod().intValue()));
                qcStatementOption = new QcStatementOption(qcStatment);
            } else if (statementValue.getConstant() != null) {
                ASN1Encodable constantStatementValue;
                try {
                    constantStatementValue = new ASN1StreamParser(statementValue.getConstant().getValue()).readObject();
                }
                catch (IOException ex) {
                    throw new CertprofileException("can not parse the constant value of QcStatement");
                }
                qcStatementOption = new QcStatementOption(new QCStatement(qcStatementId, constantStatementValue));
            } else if (statementValue.getQcEuLimitValue() != null) {
                QcStatements.QcEuLimitValueType euLimitType = statementValue.getQcEuLimitValue();
                String tmpCurrency = euLimitType.getCurrency().toUpperCase();
                if (currencyCodes.contains(tmpCurrency)) {
                    throw new CertprofileException("Duplicated definition of qcStatments with QCEuLimitValue for the currency " + tmpCurrency);
                }
                Iso4217CurrencyCode currency = StringUtil.isNumber((String)tmpCurrency) ? new Iso4217CurrencyCode(Integer.parseInt(tmpCurrency)) : new Iso4217CurrencyCode(tmpCurrency);
                QcStatements.Range2Type r1 = euLimitType.getAmount();
                QcStatements.Range2Type r2 = euLimitType.getExponent();
                if (r1.getMin() == r1.getMax() && r2.getMin() == r2.getMax()) {
                    MonetaryValue monetaryValue = new MonetaryValue(currency, r1.getMin(), r2.getMin());
                    qcStatementOption = new QcStatementOption(new QCStatement(qcStatementId, (ASN1Encodable)monetaryValue));
                } else {
                    qcStatementOption = new QcStatementOption(qcStatementId, new MonetaryValueOption(currency, r1, r2));
                    requireInfoFromReq = true;
                }
                currencyCodes.add(tmpCurrency);
            } else if (statementValue.getPdsLocations() != null) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (QcStatements.PdsLocationType pl : statementValue.getPdsLocations()) {
                    String lang = pl.getLanguage();
                    if (lang.length() != 2) {
                        throw new CertprofileException("invalid language '" + lang + "'");
                    }
                    vec.add((ASN1Encodable)new DERSequence(new ASN1Encodable[]{new DERIA5String(pl.getUrl()), new DERPrintableString(lang)}));
                }
                qcStatementOption = new QcStatementOption(new QCStatement(qcStatementId, (ASN1Encodable)new DERSequence(vec)));
            } else {
                throw new CertprofileException("unknown value of qcStatment");
            }
            this.qcStatementsOption.add(qcStatementOption);
        }
        if (requireInfoFromReq) {
            return;
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (QcStatementOption m : this.qcStatementsOption) {
            if (m.getStatement() == null) {
                throw new IllegalStateException("should not reach here");
            }
            vec.add((ASN1Encodable)m.getStatement());
        }
        this.qcStatments = new ExtensionValue(this.critical(type), (ASN1Encodable)new DERSequence(vec));
        this.qcStatementsOption = null;
    }

    private void initRestriction(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_extension_restriction;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            Restriction extConf = XijsonExtensions.getExtension(type, extensions).getRestriction();
            if (extConf != null) {
                this.restriction = new ExtensionValue(this.critical(type), extConf.getType().createDirectoryString(extConf.getText()));
            }
        }
    }

    private void initSmimeCapabilities(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_smimeCapabilities;
        if (!this.extensionControls.containsKey(type)) {
            return;
        }
        extnIds.remove(type);
        SmimeCapabilities extConf = XijsonExtensions.getExtension(type, extensions).getSmimeCapabilities();
        if (extConf == null) {
            return;
        }
        List<SmimeCapabilities.SmimeCapability> list = extConf.getCapabilities();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (SmimeCapabilities.SmimeCapability m : list) {
            ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(m.getCapabilityId().getOid());
            ASN1Integer params = null;
            SmimeCapabilities.SmimeCapabilityParameter capParams = m.getParameter();
            if (capParams != null) {
                if (capParams.getInteger() != null) {
                    params = new ASN1Integer(capParams.getInteger());
                } else if (capParams.getBinary() != null) {
                    params = XijsonExtensions.readAsn1Encodable(capParams.getBinary().getValue());
                }
            }
            vec.add((ASN1Encodable)new SMIMECapability(oid, params));
        }
        this.smimeCapabilities = new ExtensionValue(this.critical(type), (ASN1Encodable)new DERSequence(vec));
    }

    private void initSubjectAlternativeName(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.subjectAlternativeName;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            GeneralNameType extConf = XijsonExtensions.getExtension(type, extensions).getSubjectAltName();
            if (extConf != null) {
                this.subjectAltNameModes = extConf.toGeneralNameModes();
            }
        }
    }

    private void initSubjectInfoAccess(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = Extension.subjectInfoAccess;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            SubjectInfoAccess extConf = XijsonExtensions.getExtension(type, extensions).getSubjectInfoAccess();
            if (extConf != null) {
                List<SubjectInfoAccess.Access> list = extConf.getAccesses();
                this.subjectInfoAccessModes = new HashMap<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>>();
                for (SubjectInfoAccess.Access entry : list) {
                    this.subjectInfoAccessModes.put(new ASN1ObjectIdentifier(entry.getAccessMethod().getOid()), entry.getAccessLocation().toGeneralNameModes());
                }
            }
        }
    }

    private void initTlsFeature(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_pe_tlsfeature;
        if (!this.extensionControls.containsKey(type)) {
            return;
        }
        extnIds.remove(type);
        TlsFeature extConf = XijsonExtensions.getExtension(type, extensions).getTlsFeature();
        if (extConf == null) {
            return;
        }
        ArrayList<Integer> features = new ArrayList<Integer>(extConf.getFeatures().size());
        for (Describable.DescribableInt m : extConf.getFeatures()) {
            int value = m.getValue();
            if (value < 0 || value > 65535) {
                throw new CertprofileException("invalid TLS feature (extensionType) " + value);
            }
            features.add(value);
        }
        Collections.sort(features);
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (Integer m : features) {
            vec.add((ASN1Encodable)new ASN1Integer((long)m.intValue()));
        }
        this.tlsFeature = new ExtensionValue(this.critical(type), (ASN1Encodable)new DERSequence(vec));
    }

    private void initValidityModel(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_extension_validityModel;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            ValidityModel extConf = XijsonExtensions.getExtension(type, extensions).getValidityModel();
            if (extConf != null) {
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(extConf.getModelId().getOid());
                this.validityModel = new ExtensionValue(this.critical(type), (ASN1Encodable)new DERSequence((ASN1Encodable)oid));
            }
        }
    }

    private void initSubjectDirAttrs(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) {
        ASN1ObjectIdentifier type = Extension.subjectDirectoryAttributes;
        if (this.extensionControls.containsKey(type)) {
            extnIds.remove(type);
            SubjectDirectoryAttributs extConf = XijsonExtensions.getExtension(type, extensions).getSubjectDirectoryAttributs();
            if (extConf != null) {
                this.subjectDirAttrsControl = new SubjectDirectoryAttributesControl(XijsonExtensions.toOidList(extConf.getTypes()));
            }
        }
    }

    private void initGmt0015Extensions(Set<ASN1ObjectIdentifier> extnIds) {
        Arrays.asList(ObjectIdentifiers.Extn.id_GMT_0015_ICRegistrationNumber, ObjectIdentifiers.Extn.id_GMT_0015_IdentityCode, ObjectIdentifiers.Extn.id_GMT_0015_InsuranceNumber, ObjectIdentifiers.Extn.id_GMT_0015_OrganizationCode, ObjectIdentifiers.Extn.id_GMT_0015_TaxationNumber).forEach(extnIds::remove);
    }

    private void initCCCExtensionSchemas(Set<ASN1ObjectIdentifier> extnIds, Map<String, ExtensionType> extensions) throws CertprofileException {
        ASN1ObjectIdentifier type = null;
        for (ASN1ObjectIdentifier m : extnIds) {
            if (!m.on(ObjectIdentifiers.Extn.id_ccc_extn)) continue;
            if (type != null) {
                throw new CertprofileException("Maximal one CCC Extension is allowed, but configured at least 2.");
            }
            type = m;
        }
        if (type == null) {
            return;
        }
        extnIds.remove(type);
        ExtensionType ex = extensions.get(type.getId());
        if (!ex.critical()) {
            throw new CertprofileException("CCC Extension must be set to critical, but configured non-critical.");
        }
        List<ASN1ObjectIdentifier> simpleSchemaTypes = Arrays.asList(ObjectIdentifiers.Extn.id_ccc_Vehicle_Cert_K, ObjectIdentifiers.Extn.id_ccc_External_CA_Cert_F, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_Enc_Cert, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_Sig_Cert, ObjectIdentifiers.Extn.id_ccc_Device_Enc_Cert, ObjectIdentifiers.Extn.id_ccc_Vehicle_Intermediate_Cert, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_CA_Cert_J, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_CA_Cert_M);
        if (!simpleSchemaTypes.contains(type)) {
            return;
        }
        CCCSimpleExtensionSchema schema = ex.getCccExtensionSchema();
        if (schema == null) {
            throw new CertprofileException("ccExtensionSchema is not set for " + type);
        }
        this.cccExtensionSchemaType = type;
        this.cccExtensionSchemaValue = new ExtensionValue(ex.critical(), (ASN1Encodable)new DERSequence((ASN1Encodable)new ASN1Integer((long)schema.getVersion())));
    }

    private static List<ASN1ObjectIdentifier> toOidList(List<Describable.DescribableOid> oidWithDescTypes) {
        if (CollectionUtil.isEmpty(oidWithDescTypes)) {
            return null;
        }
        LinkedList<ASN1ObjectIdentifier> oids = new LinkedList<ASN1ObjectIdentifier>();
        for (Describable.DescribableOid type : oidWithDescTypes) {
            oids.add(new ASN1ObjectIdentifier(type.getOid()));
        }
        return Collections.unmodifiableList(oids);
    }

    GeneralNames createRequestedSubjectAltNames(X500Name requestedSubject, X500Name grantedSubject, Map<ASN1ObjectIdentifier, Extension> requestedExtensions) throws BadCertTemplateException {
        GeneralNames reqNames;
        ASN1Encodable extValue;
        Extension extn = requestedExtensions == null ? null : requestedExtensions.get(Extension.subjectAlternativeName);
        ASN1Encodable aSN1Encodable = extValue = extn == null ? null : extn.getParsedValue();
        if (extValue == null && this.subjectToSubjectAltNameModes == null) {
            return null;
        }
        GeneralNames generalNames = reqNames = extValue == null ? null : GeneralNames.getInstance((Object)extValue);
        if (this.subjectAltNameModes == null && this.subjectToSubjectAltNameModes == null) {
            return reqNames;
        }
        LinkedList<GeneralName> grantedNames = new LinkedList<GeneralName>();
        if (this.subjectToSubjectAltNameModes != null) {
            for (Map.Entry<ASN1ObjectIdentifier, Certprofile.GeneralNameTag> entry : this.subjectToSubjectAltNameModes.entrySet()) {
                ASN1ObjectIdentifier attrType = entry.getKey();
                Certprofile.GeneralNameTag tag = entry.getValue();
                RDN[] rdns = grantedSubject.getRDNs(attrType);
                if (rdns == null || rdns.length == 0) {
                    rdns = requestedSubject.getRDNs(attrType);
                }
                if (rdns == null) continue;
                for (RDN rdn : rdns) {
                    GeneralName gn;
                    String rdnValue = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
                    switch (tag) {
                        case rfc822Name: 
                        case DNSName: 
                        case uniformResourceIdentifier: 
                        case IPAddress: 
                        case directoryName: 
                        case registeredID: {
                            gn = new GeneralName(tag.getTag(), rdnValue);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unsupported GeneralName tag " + tag);
                        }
                    }
                    if (grantedNames.contains(gn)) continue;
                    grantedNames.add(gn);
                }
            }
        }
        if (reqNames != null) {
            GeneralName[] reqL;
            for (GeneralName generalName : reqL = reqNames.getNames()) {
                GeneralName gn = BaseCertprofile.createGeneralName((GeneralName)generalName, this.subjectAltNameModes);
                if (grantedNames.contains(gn)) continue;
                grantedNames.add(gn);
            }
        }
        return grantedNames.isEmpty() ? null : new GeneralNames(grantedNames.toArray(new GeneralName[0]));
    }

    public ExtensionValue getAdditionalInformation() {
        return this.additionalInformation;
    }

    public AdmissionExtension.AdmissionSyntaxOption getAdmission() {
        return this.admission;
    }

    public Certprofile.AuthorityInfoAccessControl getAiaControl() {
        return this.aiaControl;
    }

    public Certprofile.CrlDistributionPointsControl getCrlDpControl() {
        return this.crlDpControl;
    }

    public Certprofile.CrlDistributionPointsControl getFreshestCrlControl() {
        return this.freshestCrlControl;
    }

    public Map<ASN1ObjectIdentifier, Certprofile.GeneralNameTag> getSubjectToSubjectAltNameModes() {
        return this.subjectToSubjectAltNameModes;
    }

    public Set<Certprofile.GeneralNameMode> getSubjectAltNameModes() {
        return this.subjectAltNameModes;
    }

    public Map<ASN1ObjectIdentifier, Set<Certprofile.GeneralNameMode>> getSubjectInfoAccessModes() {
        return this.subjectInfoAccessModes;
    }

    public BiometricInfoOption getBiometricInfo() {
        return this.biometricInfo;
    }

    public org.bouncycastle.asn1.x509.CertificatePolicies getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public Map<ASN1ObjectIdentifier, ExtensionValue> getConstantExtensions() {
        return this.constantExtensions;
    }

    public Set<Certprofile.ExtKeyUsageControl> getExtendedKeyusages() {
        return this.extendedKeyusages;
    }

    public Map<ASN1ObjectIdentifier, Certprofile.ExtensionControl> getExtensionControls() {
        return this.extensionControls;
    }

    public boolean isUseIssuerAndSerialInAki() {
        return this.useIssuerAndSerialInAki;
    }

    public SubjectKeyIdentifierControl getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public ExtensionValue getInhibitAnyPolicy() {
        return this.inhibitAnyPolicy;
    }

    public Set<Certprofile.KeyUsageControl> getKeyusages() {
        return this.keyusages;
    }

    public ExtensionValue getNameConstraints() {
        return this.nameConstraints;
    }

    public Integer getPathLen() {
        return this.pathLen;
    }

    public ExtensionValue getPolicyConstraints() {
        return this.policyConstraints;
    }

    public ExtensionValue getPolicyMappings() {
        return this.policyMappings;
    }

    public Validity getPrivateKeyUsagePeriod() {
        return this.privateKeyUsagePeriod;
    }

    public ExtensionValue getQcStatments() {
        return this.qcStatments;
    }

    public List<QcStatementOption> getQcStatementsOption() {
        return this.qcStatementsOption;
    }

    public ExtensionValue getRestriction() {
        return this.restriction;
    }

    public ExtensionValue getSmimeCapabilities() {
        return this.smimeCapabilities;
    }

    public ExtensionValue getTlsFeature() {
        return this.tlsFeature;
    }

    public ExtensionValue getValidityModel() {
        return this.validityModel;
    }

    public SubjectDirectoryAttributesControl getSubjectDirAttrsControl() {
        return this.subjectDirAttrsControl;
    }

    public ASN1ObjectIdentifier getCccExtensionSchemaType() {
        return this.cccExtensionSchemaType;
    }

    public ExtensionValue getCccExtensionSchemaValue() {
        return this.cccExtensionSchemaValue;
    }

    private static ExtensionType getExtension(ASN1ObjectIdentifier type, Map<String, ExtensionType> extensions) {
        return Optional.ofNullable(extensions.get(type.getId())).orElseThrow(() -> new IllegalStateException("should not reach here: undefined extension " + ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)type)));
    }

    private static ASN1Encodable readAsn1Encodable(byte[] encoded) throws CertprofileException {
        ASN1StreamParser parser = new ASN1StreamParser(encoded);
        try {
            return parser.readObject();
        }
        catch (IOException ex) {
            throw new CertprofileException("could not parse the constant extension value", (Throwable)ex);
        }
    }

    private boolean critical(ASN1ObjectIdentifier type) {
        return this.extensionControls.get(type).isCritical();
    }
}

