/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.xipki.util.Base64;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class ConstantExtnValue
extends ValidableConf {
    public static final String TYPE_ASN1 = "ASN1";
    public static final String TYPE_OCTET_STRING = "OCTET STRING";
    public static final String TYPE_BIT_STRING = "BIT STRING";
    public static final String TYPE_UTF8_STRING = "UTF8String";
    public static final String TYPE_PRINTABLE_STRING = "PrintableString";
    public static final String TYPE_INTEGER = "INTEGER";
    private String type;
    private String value;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.toUpperCase(Locale.ROOT);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ASN1Encodable toASN1Encodable() throws InvalidConfException {
        if (this.value == null) {
            throw new InvalidConfException("value must not be non-null");
        }
        String tType = this.type == null ? TYPE_ASN1 : this.type;
        try {
            if (tType.equalsIgnoreCase(TYPE_ASN1)) {
                ASN1StreamParser parser = new ASN1StreamParser(Base64.decode((String)this.value));
                return parser.readObject();
            }
            if (tType.equalsIgnoreCase(TYPE_INTEGER)) {
                return new ASN1Integer(StringUtil.toBigInt((String)this.value));
            }
            if (tType.equalsIgnoreCase(TYPE_OCTET_STRING)) {
                return new DEROctetString(Base64.decode((String)this.value));
            }
            if (tType.equalsIgnoreCase(TYPE_BIT_STRING)) {
                return new DERBitString(Base64.decode((String)this.value));
            }
            if (tType.equalsIgnoreCase(TYPE_PRINTABLE_STRING)) {
                return new DERPrintableString(this.value);
            }
            if (tType.equalsIgnoreCase(TYPE_UTF8_STRING)) {
                return new DERUTF8String(this.value);
            }
            throw new InvalidConfException("invalid type " + this.type);
        }
        catch (Exception ex) {
            throw new InvalidConfException("could not parse the constant extension value", (Throwable)ex);
        }
    }

    public void validate() throws InvalidConfException {
        this.toASN1Encodable();
    }
}

