/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.xipki.ca.api.profile.KeyParametersOption;
import org.xipki.ca.api.profile.Range;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class KeyParametersType
extends ValidableConf {
    private DsaParametersType dsa;
    private EcParametersType ec;
    private RsaParametersType rsa;

    public DsaParametersType getDsa() {
        return this.dsa;
    }

    public void setDsa(DsaParametersType dsa) {
        this.dsa = dsa;
    }

    public EcParametersType getEc() {
        return this.ec;
    }

    public void setEc(EcParametersType ec) {
        this.ec = ec;
    }

    public RsaParametersType getRsa() {
        return this.rsa;
    }

    public void setRsa(RsaParametersType rsa) {
        this.rsa = rsa;
    }

    public KeyParametersOption toXiKeyParametersOption() {
        if (this.ec != null) {
            KeyParametersOption.ECParamatersOption option = new KeyParametersOption.ECParamatersOption();
            if (this.ec.getCurves() != null) {
                option.setCurveOids(X509ProfileType.toOidSet(this.ec.getCurves()));
            }
            if (this.ec.getPointEncodings() != null) {
                option.setPointEncodings(new HashSet<Byte>(this.ec.getPointEncodings()));
            }
            return option;
        }
        if (this.rsa != null) {
            KeyParametersOption.RSAParametersOption option = new KeyParametersOption.RSAParametersOption();
            option.setModulusLengths(this.rsa.getModulus());
            return option;
        }
        if (this.dsa != null) {
            KeyParametersOption.DSAParametersOption option = new KeyParametersOption.DSAParametersOption();
            option.setPlengths(this.dsa.getP());
            option.setQlengths(this.dsa.getQ());
            return option;
        }
        return KeyParametersOption.ALLOW_ALL;
    }

    private static void validateRanges(List<Range> ranges) throws InvalidConfException {
        if (ranges != null) {
            for (Range r : ranges) {
                try {
                    r.validate();
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidConfException(ex.getMessage());
                }
            }
        }
    }

    public void validate() throws InvalidConfException {
        KeyParametersType.validate((ValidableConf)this.dsa, (ValidableConf[])new ValidableConf[]{this.ec, this.rsa});
    }

    public static class RsaParametersType
    extends ValidableConf {
        private List<Integer> modulus;

        public List<Integer> getModulus() {
            return this.modulus;
        }

        public void setModulus(List<Integer> modulus) {
            this.modulus = modulus;
        }

        @Deprecated
        public void setModulusLengths(List<Range> modulusLengths) {
            if (CollectionUtil.isNotEmpty(modulusLengths)) {
                this.modulus = new LinkedList<Integer>();
                for (Range r : modulusLengths) {
                    for (int i = r.getMin().intValue(); i < r.getMax(); ++i) {
                        this.modulus.add(i);
                    }
                }
            }
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class EcParametersType
    extends ValidableConf {
        private List<Describable.DescribableOid> curves;
        private List<Byte> pointEncodings;

        public List<Describable.DescribableOid> getCurves() {
            if (this.curves == null) {
                this.curves = new LinkedList<Describable.DescribableOid>();
            }
            return this.curves;
        }

        public void setCurves(List<Describable.DescribableOid> curves) {
            this.curves = curves;
        }

        public List<Byte> getPointEncodings() {
            if (this.pointEncodings == null) {
                this.pointEncodings = new LinkedList<Byte>();
            }
            return this.pointEncodings;
        }

        public void setPointEncodings(List<Byte> pointEncodings) {
            this.pointEncodings = pointEncodings;
        }

        public void validate() throws InvalidConfException {
            EcParametersType.validate(this.curves, (Collection[])new Collection[0]);
        }
    }

    public static class DsaParametersType
    extends ValidableConf {
        private List<Integer> p;
        private List<Integer> q;

        public List<Integer> getP() {
            return this.p;
        }

        public void setP(List<Integer> p) {
            this.p = p;
        }

        public List<Integer> getQ() {
            return this.q;
        }

        public void setQ(List<Integer> q) {
            this.q = q;
        }

        @Deprecated
        public void setPlengths(List<Range> plengths) {
            if (CollectionUtil.isNotEmpty(plengths)) {
                this.p = new LinkedList<Integer>();
                for (Range r : plengths) {
                    for (int i = r.getMin().intValue(); i < r.getMax(); ++i) {
                        this.p.add(i);
                    }
                }
            }
        }

        @Deprecated
        public void setQlengths(List<Range> qlengths) {
            if (CollectionUtil.isNotEmpty(qlengths)) {
                this.q = new LinkedList<Integer>();
                for (Range r : qlengths) {
                    for (int i = r.getMin().intValue(); i < r.getMax(); ++i) {
                        this.q.add(i);
                    }
                }
            }
        }

        public void validate() throws InvalidConfException {
        }
    }
}

