/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf;

import java.util.Map;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.security.EdECConstants;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class KeypairGenerationType
extends ValidableConf {
    public static final String PARAM_keysize = "keysize";
    public static final String PARAM_curve = "curve";
    public static final String PARAM_plength = "plength";
    public static final String PARAM_qlength = "qlength";
    private Boolean inheritCA;
    private Boolean forbidden;
    private Describable.DescribableOid algorithm;
    private KeyType keyType;
    private Map<String, String> parameters;

    public Boolean getInheritCA() {
        return this.inheritCA;
    }

    public void setInheritCA(Boolean inheritCA) {
        this.inheritCA = inheritCA;
    }

    public Boolean getForbidden() {
        return this.forbidden;
    }

    public void setForbidden(Boolean forbidden) {
        this.forbidden = forbidden;
    }

    public Describable.DescribableOid getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Describable.DescribableOid algorithm) {
        this.algorithm = algorithm;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyType keyType) {
        this.keyType = keyType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters == null || parameters.isEmpty() ? null : parameters;
    }

    public void validate() throws InvalidConfException {
        if (this.inheritCA == null) {
            return;
        }
        if (this.inheritCA.booleanValue()) {
            return;
        }
        if (this.forbidden == null) {
            return;
        }
        if (this.forbidden.booleanValue()) {
            return;
        }
        KeypairGenerationType.notNull((Object)((Object)this.algorithm), (String)"algorithm");
        KeypairGenerationType.validate((ValidableConf)this.algorithm, (ValidableConf[])new ValidableConf[0]);
        KeypairGenerationType.notNull((Object)((Object)this.keyType), (String)"keyType");
        switch (this.keyType) {
            case RSA: {
                KeypairGenerationType.notNull(this.parameters, (String)"parameters");
                if (this.parameters.containsKey(PARAM_keysize)) break;
                throw new InvalidConfException("parameters keysize may not be null");
            }
            case DSA: {
                KeypairGenerationType.notNull(this.parameters, (String)"parameters");
                if (this.parameters.containsKey(PARAM_plength)) break;
                throw new InvalidConfException("parameters plength may not be null");
            }
            case EC: {
                KeypairGenerationType.notNull(this.parameters, (String)"parameters");
                if (this.parameters.containsKey(PARAM_curve)) break;
                throw new InvalidConfException("parameters curve may not be null");
            }
            case ED25519: {
                if (EdECConstants.id_ED25519.getId().equals(this.algorithm.getOid())) break;
                throw new InvalidConfException("keyType and algorithm not match");
            }
            case ED448: {
                if (EdECConstants.id_ED448.getId().equals(this.algorithm.getOid())) break;
                throw new InvalidConfException("keyType and algorithm not match");
            }
            case X25519: {
                if (EdECConstants.id_X25519.getId().equals(this.algorithm.getOid())) break;
                throw new InvalidConfException("keyType and algorithm not match");
            }
            case X448: {
                if (EdECConstants.id_X448.getId().equals(this.algorithm.getOid())) break;
                throw new InvalidConfException("keyType and algorithm not match");
            }
        }
    }

    public static enum KeyType {
        RSA,
        EC,
        DSA,
        ED25519,
        ED448,
        X25519,
        X448;

    }
}

