/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf.extn;

import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.conf.GeneralSubtreeType;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class NameConstraints
extends ValidableConf {
    private List<GeneralSubtreeType> permittedSubtrees;
    private List<GeneralSubtreeType> excludedSubtrees;

    public List<GeneralSubtreeType> getPermittedSubtrees() {
        if (this.permittedSubtrees == null) {
            this.permittedSubtrees = new LinkedList<GeneralSubtreeType>();
        }
        return this.permittedSubtrees;
    }

    public void setPermittedSubtrees(List<GeneralSubtreeType> permittedSubtrees) {
        this.permittedSubtrees = permittedSubtrees;
    }

    public List<GeneralSubtreeType> getExcludedSubtrees() {
        if (this.excludedSubtrees == null) {
            this.excludedSubtrees = new LinkedList<GeneralSubtreeType>();
        }
        return this.excludedSubtrees;
    }

    public void setExcludedSubtrees(List<GeneralSubtreeType> excludedSubtrees) {
        this.excludedSubtrees = excludedSubtrees;
    }

    public void validate() throws InvalidConfException {
        if (CollectionUtil.isEmpty(this.permittedSubtrees) && CollectionUtil.isEmpty(this.excludedSubtrees)) {
            throw new InvalidConfException("permittedSubtrees and excludedSubtrees may not be both null");
        }
        NameConstraints.validate(this.permittedSubtrees, (Collection[])new Collection[]{this.excludedSubtrees});
    }

    public org.bouncycastle.asn1.x509.NameConstraints toXiNameConstraints() throws CertprofileException {
        GeneralSubtree[] permitted = NameConstraints.buildGeneralSubtrees(this.getPermittedSubtrees());
        GeneralSubtree[] excluded = NameConstraints.buildGeneralSubtrees(this.getExcludedSubtrees());
        return permitted == null && excluded == null ? null : new org.bouncycastle.asn1.x509.NameConstraints(permitted, excluded);
    }

    private static GeneralSubtree[] buildGeneralSubtrees(List<GeneralSubtreeType> subtrees) throws CertprofileException {
        if (CollectionUtil.isEmpty(subtrees)) {
            return null;
        }
        int n = subtrees.size();
        GeneralSubtree[] ret = new GeneralSubtree[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = NameConstraints.buildGeneralSubtree(subtrees.get(i));
        }
        return ret;
    }

    private static GeneralSubtree buildGeneralSubtree(GeneralSubtreeType type) throws CertprofileException {
        GeneralName base;
        GeneralSubtreeType.Base baseType = ((GeneralSubtreeType)((Object)Args.notNull((Object)((Object)type), (String)"type"))).getBase();
        if (baseType.getDirectoryName() != null) {
            base = new GeneralName(X509Util.reverse((X500Name)new X500Name(baseType.getDirectoryName())));
        } else if (baseType.getDnsName() != null) {
            base = new GeneralName(2, baseType.getDnsName());
        } else if (baseType.getIpAddress() != null) {
            base = new GeneralName(7, baseType.getIpAddress());
        } else if (baseType.getRfc822Name() != null) {
            base = new GeneralName(1, baseType.getRfc822Name());
        } else if (baseType.getUri() != null) {
            base = new GeneralName(6, baseType.getUri());
        } else {
            throw new IllegalStateException("should not reach here, unknown child of GeneralSubtreeType");
        }
        Integer min = type.getMinimum();
        if (min != null && min < 0) {
            throw new CertprofileException("negative minimum is not allowed: " + min);
        }
        BigInteger minimum = min == null ? null : BigInteger.valueOf(min.intValue());
        Integer max = type.getMaximum();
        if (max != null && max < 0) {
            throw new CertprofileException("negative maximum is not allowed: " + max);
        }
        BigInteger maximum = max == null ? null : BigInteger.valueOf(max.intValue());
        return new GeneralSubtree(base, minimum, maximum);
    }
}

