/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.certprofile.xijson.conf.extn;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class PolicyConstraints
extends ValidableConf {
    private Integer requireExplicitPolicy;
    private Integer inhibitPolicyMapping;

    public Integer getRequireExplicitPolicy() {
        return this.requireExplicitPolicy;
    }

    public void setRequireExplicitPolicy(Integer requireExplicitPolicy) {
        this.requireExplicitPolicy = requireExplicitPolicy;
    }

    public Integer getInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public void setInhibitPolicyMapping(Integer inhibitPolicyMapping) {
        this.inhibitPolicyMapping = inhibitPolicyMapping;
    }

    public void validate() throws InvalidConfException {
        if (this.requireExplicitPolicy == null && this.inhibitPolicyMapping == null) {
            throw new InvalidConfException("requireExplicitPolicy and inhibitPolicyMapping may not be both null");
        }
    }

    public ASN1Sequence toXiPolicyConstraints() throws CertprofileException {
        if (this.requireExplicitPolicy != null && this.requireExplicitPolicy < 0) {
            throw new CertprofileException("negative requireExplicitPolicy is not allowed: " + this.requireExplicitPolicy);
        }
        if (this.inhibitPolicyMapping != null && this.inhibitPolicyMapping < 0) {
            throw new CertprofileException("negative inhibitPolicyMapping is not allowed: " + this.inhibitPolicyMapping);
        }
        if (this.requireExplicitPolicy == null && this.inhibitPolicyMapping == null) {
            return null;
        }
        boolean explicit = false;
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (this.requireExplicitPolicy != null) {
            vec.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(BigInteger.valueOf(this.requireExplicitPolicy.intValue()))));
        }
        if (this.inhibitPolicyMapping != null) {
            vec.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new ASN1Integer(BigInteger.valueOf(this.inhibitPolicyMapping.intValue()))));
        }
        return new DERSequence(vec);
    }
}

