/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client;

import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.xipki.cmp.PkiStatusInfo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public class EnrollCertResult {
    private final X509Cert[] caCertChain;
    private final Map<String, CertifiedKeyPairOrError> certsOrErrors;

    public EnrollCertResult(X509Cert[] caCertChain, Map<String, CertifiedKeyPairOrError> certsOrErrors) {
        this.certsOrErrors = Args.notEmpty(certsOrErrors, (String)"certsOrErrors");
        this.caCertChain = caCertChain;
    }

    public X509Cert[] getCaCertChain() {
        return this.caCertChain;
    }

    public CertifiedKeyPairOrError getCertOrError(String id) {
        return this.certsOrErrors.get(Args.notBlank((String)id, (String)"id"));
    }

    public Set<String> getAllIds() {
        return this.certsOrErrors.keySet();
    }

    public static class CertifiedKeyPairOrError {
        private final X509Cert certificate;
        private final PrivateKeyInfo privateKeyInfo;
        private final PkiStatusInfo error;

        public CertifiedKeyPairOrError(X509Cert certificate, PrivateKeyInfo privateKeyInfo) {
            this.certificate = (X509Cert)Args.notNull((Object)certificate, (String)"certificate");
            this.privateKeyInfo = privateKeyInfo;
            this.error = null;
        }

        public CertifiedKeyPairOrError(PkiStatusInfo error) {
            this.certificate = null;
            this.privateKeyInfo = null;
            this.error = (PkiStatusInfo)Args.notNull((Object)error, (String)"error");
        }

        public X509Cert getCertificate() {
            return this.certificate;
        }

        public PrivateKeyInfo getPrivateKeyInfo() {
            return this.privateKeyInfo;
        }

        public PkiStatusInfo getError() {
            return this.error;
        }
    }
}

