/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.security.X509Cert;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.IoUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class CertActions {

    public static abstract class UnsuspendRmCertAction
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--cert", aliases={"-c"}, description="certificate file\n(either cert or serial must be specified)")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--serial", aliases={"-s"}, description="serial number\n(either cert or serial must be specified)")
        private String serialNumberS;

        protected BigInteger getSerialNumber() throws Exception {
            BigInteger serialNumber;
            CaEntry ca = this.caManager.getCa(this.caName);
            if (ca == null) {
                throw new CmdFailure("CA " + this.caName + " not available");
            }
            if (this.serialNumberS != null) {
                serialNumber = UnsuspendRmCertAction.toBigInt((String)this.serialNumberS);
            } else if (this.certFile != null) {
                X509Cert cert;
                X509Cert caCert = ca.getCert();
                if (!X509Util.issues((X509Cert)caCert, (X509Cert)(cert = X509Util.parseCert((File)new File(this.certFile))))) {
                    throw new CmdFailure("certificate '" + this.certFile + "' is not issued by CA " + this.caName);
                }
                serialNumber = cert.getSerialNumber();
            } else {
                throw new IllegalCmdParamException("neither serialNumber nor certFile is specified");
            }
            return serialNumber;
        }
    }

    @Command(scope="ca", name="unsuspend-cert", description="unsuspend certificate")
    @Service
    public static class UnsuspendCert
    extends UnsuspendRmCertAction {
        protected Object execute0() throws Exception {
            BigInteger serialNo = this.getSerialNumber();
            String msg = "certificate (serial number = 0x" + serialNo.toString(16) + ")";
            try {
                this.caManager.unsuspendCertificate(this.caName, serialNo);
                this.println("unsuspended " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not unsuspend " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="revoke-cert", description="revoke certificate")
    @Service
    public static class RevokeCert
    extends UnsuspendRmCertAction {
        @Option(name="--reason", aliases={"-r"}, required=true, description="CRL reason")
        @Completion(value=Completers.ClientCrlReasonCompleter.class)
        private String reason;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        protected Object execute0() throws Exception {
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!CrlReason.PERMITTED_CLIENT_CRLREASONS.contains(crlReason)) {
                throw new InvalidConfException("reason " + this.reason + " is not permitted");
            }
            BigInteger serialNo = this.getSerialNumber();
            String msg = "certificate (serial number = 0x" + serialNo.toString(16) + ")";
            try {
                this.caManager.revokeCertificate(this.caName, serialNo, crlReason, RevokeCert.parseDate(this.invalidityDateS));
                this.println("revoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not revoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="rm-cert", description="remove certificate")
    @Service
    public static class RmCert
    extends UnsuspendRmCertAction {
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            BigInteger serialNo = this.getSerialNumber();
            String msg = "certificate (serial number = 0x" + serialNo.toString(16) + ")";
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCertificate(this.caName, serialNo);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="list-cert", description="show a list of certificates")
    @Service
    public static class ListCert
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--subject", description="the subject pattern, * is allowed.")
        protected String subjectPatternS;
        @Option(name="--valid-from", description="start UTC time when the certificate is still valid, in form of yyyyMMdd or yyyyMMddHHmmss")
        private String validFromS;
        @Option(name="--valid-to", description="end UTC time when the certificate is still valid, in form of yyyMMdd or yyyyMMddHHmmss")
        private String validToS;
        @Option(name="-n", description="maximal number of entries (between 1 and 1000)")
        private int num = 1000;
        @Option(name="--order", description="by which the result is ordered")
        @Completion(value=CaCompleters.CertListSortByCompleter.class)
        private String orderByS;

        protected Object execute0() throws Exception {
            X500Name subjectPattern = StringUtil.isBlank((String)this.subjectPatternS) ? null : new X500Name(this.subjectPatternS);
            CertListOrderBy orderBy = null;
            if (this.orderByS != null && (orderBy = CertListOrderBy.forValue((String)this.orderByS)) == null) {
                throw new IllegalCmdParamException("invalid order '" + this.orderByS + "'");
            }
            List certInfos = this.caManager.listCertificates(this.caName, subjectPattern, ListCert.parseDate(this.validFromS), ListCert.parseDate(this.validToS), orderBy, this.num);
            int n = certInfos.size();
            if (n == 0) {
                this.println("found no certificate");
                return null;
            }
            this.println("     |                    serial                |    notBefore   |    notAfter    |         subject");
            this.println("-----+------------------------------------------+----------------+----------------+---------------------------");
            for (int i = 0; i < n; ++i) {
                this.println(this.format(i + 1, (CertListInfo)certInfos.get(i)));
            }
            return null;
        }

        private String format(int index, CertListInfo info) {
            return StringUtil.concat((String)StringUtil.formatAccount((long)index, (int)4), (String[])new String[]{" | ", StringUtil.formatText((String)info.getSerialNumber().toString(16), (int)40), " | ", info.getNotBefore(), " | ", info.getNotAfter(), " | ", info.getSubject()});
        }
    }

    @Command(scope="ca", name="get-crl", description="download CRL")
    @Service
    public static class GetCrl
    extends CrlAction {
        @Option(name="--with-basecrl", description="whether to retrieve the baseCRL if the current CRL is a delta CRL")
        private Boolean withBaseCrl = Boolean.FALSE;
        @Option(name="--basecrl-out", description="where to save the baseCRL\n(defaults to <out>-baseCRL)")
        @Completion(value=FileCompleter.class)
        private String baseCrlOut;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        protected String outFile;

        @Override
        protected X509CRLHolder retrieveCrl() throws Exception {
            return this.caManager.getCurrentCrl(this.caName);
        }

        @Override
        protected Object execute0() throws Exception {
            Extensions extns;
            byte[] extnValue;
            X509CRLHolder crl;
            CaEntry ca = Optional.ofNullable(this.caManager.getCa(this.caName)).orElseThrow(() -> new CmdFailure("CA " + this.caName + " not available"));
            try {
                crl = this.retrieveCrl();
            }
            catch (Exception ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            this.saveVerbose("saved CRL to file", this.outFile, GetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            if (this.withBaseCrl.booleanValue() && (extnValue = X509Util.getCoreExtValue((Extensions)(extns = crl.getExtensions()), (ASN1ObjectIdentifier)Extension.deltaCRLIndicator)) != null) {
                if (this.baseCrlOut == null) {
                    this.baseCrlOut = this.outFile + "-baseCRL";
                }
                BigInteger baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                try {
                    crl = this.caManager.getCrl(this.caName, baseCrlNumber);
                }
                catch (Exception ex) {
                    throw new CmdFailure("received no baseCRL from server: " + ex.getMessage());
                }
                if (crl == null) {
                    throw new CmdFailure("received no baseCRL from server");
                }
                this.saveVerbose("saved baseCRL to file", this.baseCrlOut, GetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            }
            return null;
        }

        @Override
        protected String getOutFile() {
            return this.outFile;
        }
    }

    @Command(scope="ca", name="get-cert", description="get certificate")
    @Service
    public static class GetCert
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--serial", aliases={"-s"}, required=true, description="serial number")
        private String serialNumberS;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            CertWithRevocationInfo certInfo = this.caManager.getCert(this.caName, GetCert.toBigInt((String)this.serialNumberS));
            if (certInfo == null) {
                System.out.println("certificate unknown");
                return null;
            }
            this.saveVerbose("certificate saved to file", this.outputFile, GetCert.encodeCert((byte[])certInfo.getCert().getCert().getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="ca", name="gen-crl", description="generate CRL")
    @Service
    public static class GenCrl
    extends CrlAction {
        @Option(name="--out", aliases={"-o"}, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        protected String outFile;

        @Override
        protected X509CRLHolder retrieveCrl() throws Exception {
            return this.caManager.generateCrlOnDemand(this.caName);
        }

        @Override
        protected String getOutFile() {
            return this.outFile;
        }
    }

    @Command(scope="ca", name="enroll-cross-cert", description="enroll cross certificate")
    @Service
    public static class EnrollCrossCert
    extends EnrollCert {
        @Option(name="--target-cert", required=true, description=" certificate file, for which the cross certificate will be generated. There shall be no difference in subject and public key between certFile and csrFile.")
        @Completion(value=FileCompleter.class)
        private String targetCertFile;

        @Override
        protected Object execute0() throws Exception {
            CaEntry ca = Optional.ofNullable(this.caManager.getCa(this.caName)).orElseThrow(() -> new CmdFailure("CA " + this.caName + " not available"));
            Instant notBefore = EnrollCrossCert.parseDate(this.notBeforeS);
            Instant notAfter = EnrollCrossCert.parseDate(this.notAfterS);
            byte[] encodedCsr = X509Util.toDerEncoded((byte[])IoUtil.read((String)this.csrFile));
            byte[] encodedTargetCert = X509Util.toDerEncoded((byte[])IoUtil.read((String)this.targetCertFile));
            X509Cert cert = this.caManager.generateCrossCertificate(this.caName, this.profileName, encodedCsr, encodedTargetCert, notBefore, notAfter);
            this.saveVerbose("saved certificate to file", this.outFile, EnrollCrossCert.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="ca", name="enroll-cert", description="enroll certificate")
    @Service
    public static class EnrollCert
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--subject", description="Subject of the certificate.\nExactly one of subject (keypair generated by CA) or CSR must be specified.")
        protected String subject;
        @Option(name="--csr", description="The CSR file.\nExactly one of subject (keypair generated by CA) or csr must be specified.")
        @Completion(value=FileCompleter.class)
        protected String csrFile;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--key-outform", description="output format of the private key (pem or p12)")
        protected String keyOutform = "p12";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        protected String outFile;
        @Option(name="--key-password", description="Password to protect the private key, as plaintext or PBE-encrypted.\nFor key-outform PEM, NONE may be used to save the key in unecrypted form.")
        protected String keyPasswordHint;
        @Option(name="--profile", aliases={"-p"}, required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        protected String profileName;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        protected String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        protected String notAfterS;

        protected Object execute0() throws Exception {
            byte[] certBytes;
            CaEntry ca = Optional.ofNullable(this.caManager.getCa(this.caName)).orElseThrow(() -> new CmdFailure("CA " + this.caName + " not available"));
            if (StringUtil.isBlank((String)this.subject) == StringUtil.isBlank((String)this.csrFile)) {
                throw new IllegalCmdParamException("Exactly one of subject (keypair generated by CA) or CSR must be specified.");
            }
            if (!StringUtil.orEqualsIgnoreCase((String)this.keyOutform, (String[])new String[]{"pem", "p12", "pkcs12"})) {
                throw new IllegalCmdParamException("invalid key-outform " + this.keyOutform);
            }
            Instant notBefore = EnrollCert.parseDate(this.notBeforeS);
            Instant notAfter = EnrollCert.parseDate(this.notAfterS);
            if (StringUtil.isNotBlank((String)this.csrFile)) {
                byte[] encodedCsr = StringUtil.isNotBlank((String)this.csrFile) ? X509Util.toDerEncoded((byte[])IoUtil.read((String)this.csrFile)) : null;
                certBytes = this.caManager.generateCertificate(this.caName, this.profileName, encodedCsr, notBefore, notAfter).getEncoded();
            } else {
                boolean needKeyPwd = true;
                if ("NONE".equalsIgnoreCase(this.keyPasswordHint)) {
                    needKeyPwd = false;
                    if (!"pem".equalsIgnoreCase(this.keyOutform)) {
                        throw new IllegalCmdParamException("Password NONE is not allowed");
                    }
                }
                char[] keyPwd = null;
                if (needKeyPwd) {
                    keyPwd = this.readPasswordIfNotSet("Enter password to protect the private key", this.keyPasswordHint);
                }
                KeyCertBytesPair keyCertBytesPair = this.caManager.generateKeyCert(this.caName, this.profileName, this.subject, notBefore, notAfter);
                certBytes = keyCertBytesPair.getCert();
                String ksFilePrefix = this.outFile.substring(0, this.outFile.lastIndexOf(46));
                PrivateKey privKey = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)keyCertBytesPair.getKey()));
                if (StringUtil.orEqualsIgnoreCase((String)this.keyOutform, (String[])new String[]{"p12", "pkcs12"})) {
                    byte[] ksBytes;
                    Certificate cert;
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    try (ByteArrayInputStream is = new ByteArrayInputStream(certBytes);){
                        cert = cf.generateCertificate(is);
                    }
                    KeyStore p12Ks = KeyUtil.getOutKeyStore((String)"PKCS12");
                    p12Ks.load(null, keyPwd);
                    p12Ks.setKeyEntry("main", privKey, keyPwd, new Certificate[]{cert});
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        p12Ks.store(os, keyPwd);
                        ksBytes = os.toByteArray();
                    }
                    this.saveVerbose("saved PKCS#12 keystore to file", ksFilePrefix + ".p12", ksBytes);
                } else if (keyPwd == null) {
                    this.saveVerbose("save unencrypted key to file", ksFilePrefix + "-key.pem", PemEncoder.encode((byte[])keyCertBytesPair.getKey(), (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
                } else {
                    JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.PBE_SHA1_3DES);
                    encryptorBuilder.setRandom(this.securityFactory.getRandom4Sign());
                    encryptorBuilder.setPassword(keyPwd);
                    JcaPKCS8Generator gen = new JcaPKCS8Generator(privKey, encryptorBuilder.build());
                    PemObject obj = gen.generate();
                    this.saveVerbose("save key to file", ksFilePrefix + "-key.pem", PemEncoder.encode((byte[])obj.getContent(), (PemEncoder.PemLabel)PemEncoder.PemLabel.ENCRYPTED_PRIVATE_KEY));
                }
            }
            this.saveVerbose("saved certificate to file", this.outFile, EnrollCert.encodeCert((byte[])certBytes, (String)this.outform));
            return null;
        }
    }

    public static abstract class CrlAction
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--outform", description="output format of the CRL")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";

        protected abstract X509CRLHolder retrieveCrl() throws Exception;

        protected Object execute0() throws Exception {
            X509CRLHolder crl;
            CaEntry ca = Optional.ofNullable(this.caManager.getCa(this.caName)).orElseThrow(() -> new CmdFailure("CA " + this.caName + " not available"));
            try {
                crl = this.retrieveCrl();
            }
            catch (Exception ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            String outFile = this.getOutFile();
            if (outFile != null) {
                this.saveVerbose("saved CRL to file", outFile, CrlAction.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            }
            return null;
        }

        protected abstract String getOutFile();
    }

    @Command(scope="ca", name="cert-status", description="show certificate status and save the certificate")
    @Service
    public static class CertStatus
    extends UnsuspendRmCertAction {
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            CertWithRevocationInfo certInfo = this.caManager.getCert(this.caName, this.getSerialNumber());
            if (certInfo == null) {
                System.out.println("certificate unknown");
                return null;
            }
            String msg = StringUtil.concat((String)"certificate profile: ", (String[])new String[]{certInfo.getCertprofile(), "\nstatus: ", certInfo.getRevInfo() == null ? "good" : "revoked with " + certInfo.getRevInfo()});
            this.println(msg);
            if (this.outputFile != null) {
                this.saveVerbose("saved certificate to file", this.outputFile, CertStatus.encodeCert((byte[])certInfo.getCert().getCert().getEncoded(), (String)this.outform));
            }
            return null;
        }
    }
}

