/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.time.Instant;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;

public class CertStatusInfo {
    private CertStatus certStatus;
    private CertRevocationInfo revocationInfo;
    private HashAlgo certHashAlgo;
    private byte[] certHash;
    private Instant thisUpdate;
    private Instant nextUpdate;
    private String certprofile;
    private CrlID crlId;
    private Instant archiveCutOff;

    private CertStatusInfo(CertStatus certStatus, Instant thisUpdate, Instant nextUpdate, String certprofile) {
        this.certStatus = (CertStatus)((Object)Args.notNull((Object)((Object)certStatus), (String)"certStatus"));
        this.thisUpdate = (Instant)Args.notNull((Object)thisUpdate, (String)"thisUpdate");
        this.nextUpdate = nextUpdate;
        this.certprofile = certprofile;
    }

    public Instant getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(Instant thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public Instant getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Instant nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public CertStatus getCertStatus() {
        return this.certStatus;
    }

    public void setCertStatus(CertStatus certStatus) {
        this.certStatus = (CertStatus)((Object)Args.notNull((Object)((Object)certStatus), (String)"certStatus"));
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public HashAlgo getCertHashAlgo() {
        return this.certHashAlgo;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public String getCertprofile() {
        return this.certprofile;
    }

    public void setCertprofile(String certprofile) {
        this.certprofile = certprofile;
    }

    public CrlID getCrlId() {
        return this.crlId;
    }

    public void setCrlId(CrlID crlId) {
        this.crlId = crlId;
    }

    public Instant getArchiveCutOff() {
        return this.archiveCutOff;
    }

    public void setArchiveCutOff(Instant archiveCutOff) {
        this.archiveCutOff = archiveCutOff;
    }

    public static CertStatusInfo getCrlExpiredStatusInfo() {
        return new CertStatusInfo(CertStatus.CRL_EXPIRED, Instant.now(), null, null);
    }

    public static CertStatusInfo getUnknownCertStatusInfo(Instant thisUpdate, Instant nextUpdate) {
        return new CertStatusInfo(CertStatus.UNKNOWN, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getIgnoreCertStatusInfo(Instant thisUpdate, Instant nextUpdate) {
        return new CertStatusInfo(CertStatus.IGNORE, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getIssuerUnknownCertStatusInfo(Instant thisUpdate, Instant nextUpdate) {
        return new CertStatusInfo(CertStatus.ISSUER_UNKNOWN, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getGoodCertStatusInfo(HashAlgo certHashAlgo, byte[] certHash, Instant thisUpdate, Instant nextUpdate, String certprofile) {
        CertStatusInfo ret = new CertStatusInfo(CertStatus.GOOD, thisUpdate, nextUpdate, certprofile);
        ret.certHashAlgo = certHashAlgo;
        ret.certHash = certHash;
        return ret;
    }

    public static CertStatusInfo getGoodCertStatusInfo(Instant thisUpdate, Instant nextUpdate) {
        return new CertStatusInfo(CertStatus.GOOD, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getRevokedCertStatusInfo(CertRevocationInfo revocationInfo, HashAlgo certHashAlgo, byte[] certHash, Instant thisUpdate, Instant nextUpdate, String certprofile) {
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        CertStatusInfo ret = new CertStatusInfo(CertStatus.REVOKED, thisUpdate, nextUpdate, certprofile);
        ret.revocationInfo = revocationInfo;
        ret.certHashAlgo = certHashAlgo;
        ret.certHash = certHash;
        return ret;
    }

    public static CertStatusInfo getRevokedCertStatusInfo(CertRevocationInfo revocationInfo, Instant thisUpdate, Instant nextUpdate) {
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        CertStatusInfo ret = new CertStatusInfo(CertStatus.REVOKED, thisUpdate, nextUpdate, null);
        ret.revocationInfo = revocationInfo;
        return ret;
    }

    public static enum UnknownIssuerBehaviour {
        unknown,
        malformedRequest,
        internalError,
        unauthorized,
        tryLater;

    }

    public static enum UnknownCertBehaviour {
        unknown,
        good,
        malformedRequest,
        internalError,
        tryLater;

    }

    public static enum CertStatus {
        GOOD,
        REVOKED,
        UNKNOWN,
        IGNORE,
        ISSUER_UNKNOWN,
        CRL_EXPIRED;

    }
}

