/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.io.Closeable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Map;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Validity;

public abstract class OcspStore
implements Closeable {
    protected String name;
    protected CertStatusInfo.UnknownCertBehaviour unknownCertBehaviour = CertStatusInfo.UnknownCertBehaviour.unknown;
    protected int retentionInterval;
    protected boolean includeArchiveCutoff;
    protected boolean includeCrlId;
    protected boolean ignoreExpiredCert;
    protected boolean ignoreNotYetValidCert;
    protected Validity minNextUpdatePeriod;
    protected Validity maxNextUpdatePeriod;
    protected Validity updateInterval;

    public abstract boolean knowsIssuer(RequestIssuer var1);

    public abstract X509Cert getIssuerCert(RequestIssuer var1);

    protected boolean isIgnoreExpiredCrls() {
        return false;
    }

    public final CertStatusInfo getCertStatus(Instant time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation) throws OcspStoreException {
        CertStatusInfo info = this.getCertStatus0(time, reqIssuer, serialNumber, includeCertHash, includeRit, inheritCaRevocation);
        if (info == null) {
            return null;
        }
        Instant nextUpdate = info.getNextUpdate();
        if (this.minNextUpdatePeriod != null) {
            Instant minNextUpdate = this.minNextUpdatePeriod.add(time);
            if (nextUpdate == null || minNextUpdate.isAfter(nextUpdate)) {
                info.setNextUpdate(minNextUpdate);
            }
        }
        if (this.maxNextUpdatePeriod != null) {
            Instant maxNextUpdate = this.maxNextUpdatePeriod.add(time);
            if (nextUpdate == null || nextUpdate.isAfter(maxNextUpdate)) {
                info.setNextUpdate(maxNextUpdate);
            }
        }
        return info;
    }

    protected abstract CertStatusInfo getCertStatus0(Instant var1, RequestIssuer var2, BigInteger var3, boolean var4, boolean var5, boolean var6) throws OcspStoreException;

    public abstract void init(Map<String, ?> var1, DataSourceWrapper var2) throws OcspStoreException;

    public abstract boolean isHealthy();

    public void setName(String name) {
        this.name = Args.notBlank((String)name, (String)"name");
    }

    public String getName() {
        return this.name;
    }

    public CertStatusInfo.UnknownCertBehaviour getUnknownCertBehaviour() {
        return this.unknownCertBehaviour;
    }

    public void setUnknownCertBehaviour(CertStatusInfo.UnknownCertBehaviour unknownCertBehaviour) {
        this.unknownCertBehaviour = unknownCertBehaviour;
    }

    public boolean isIncludeArchiveCutoff() {
        return this.includeArchiveCutoff;
    }

    public void setIncludeArchiveCutoff(boolean includeArchiveCutoff) {
        this.includeArchiveCutoff = includeArchiveCutoff;
    }

    public int getRetentionInterval() {
        return this.retentionInterval;
    }

    public void setRetentionInterval(int retentionInterval) {
        this.retentionInterval = retentionInterval;
    }

    public boolean isIncludeCrlId() {
        return this.includeCrlId;
    }

    public void setIncludeCrlId(boolean includeCrlId) {
        this.includeCrlId = includeCrlId;
    }

    public boolean isIgnoreExpiredCert() {
        return this.ignoreExpiredCert;
    }

    public void setIgnoreExpiredCert(boolean ignoreExpiredCert) {
        this.ignoreExpiredCert = ignoreExpiredCert;
    }

    public boolean isIgnoreNotYetValidCert() {
        return this.ignoreNotYetValidCert;
    }

    public void setIgnoreNotYetValidCert(boolean ignoreNotYetValidCert) {
        this.ignoreNotYetValidCert = ignoreNotYetValidCert;
    }

    public Validity getMinNextUpdatePeriod() {
        return this.minNextUpdatePeriod;
    }

    public void setNextUpdatePeriodLimit(Validity minNextUpdatePeriod, Validity maxNextUpdatePeriod) {
        if (minNextUpdatePeriod != null && maxNextUpdatePeriod != null && minNextUpdatePeriod.compareTo(maxNextUpdatePeriod) > 0) {
            throw new IllegalArgumentException(String.format("minNextUpdatePeriod (%s) > maxNextUpdatePeriod (%s) is not allowed", minNextUpdatePeriod, maxNextUpdatePeriod));
        }
        this.minNextUpdatePeriod = minNextUpdatePeriod;
        this.maxNextUpdatePeriod = maxNextUpdatePeriod;
    }

    public Validity getMaxNextUpdatePeriod() {
        return this.maxNextUpdatePeriod;
    }

    public Validity getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(Validity updateInterval) {
        this.updateInterval = updateInterval;
    }

    protected static String overviewString(X509Cert cert) {
        return "subject: " + cert.getSubjectText() + ", issuer: " + cert.getIssuerText() + ", serialNo: " + cert.getSerialNumberHex();
    }
}

