/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.security.HashAlgo;
import org.xipki.util.CompareUtil;
import org.xipki.util.Hex;

public class RequestIssuer {
    private final HashAlgo hashAlgo;
    private final byte[] data;
    private final int from;
    private final int nameHashFrom;
    private final int length;

    public RequestIssuer(HashAlgo hashAlgo, byte[] hashData) {
        int algIdLen = 2 + hashAlgo.getEncodedLength() + 2;
        this.data = new byte[algIdLen + hashData.length];
        int offset = 0;
        this.data[offset++] = 48;
        this.data[offset++] = (byte)(hashAlgo.getEncodedLength() + 2);
        offset += hashAlgo.write(this.data, offset);
        this.data[offset++] = 5;
        this.data[offset++] = 0;
        this.nameHashFrom = offset;
        System.arraycopy(hashData, 0, this.data, offset, hashData.length);
        this.from = 0;
        this.length = offset += hashData.length;
        this.hashAlgo = hashAlgo;
    }

    public RequestIssuer(byte[] data) throws NoSuchAlgorithmException {
        this(data, 0, data.length);
    }

    public RequestIssuer(byte[] data, int from, int length) throws NoSuchAlgorithmException {
        this.data = data;
        this.from = from;
        this.length = length;
        this.hashAlgo = HashAlgo.getInstanceForEncoded((byte[])data, (int)(from + 2), (int)(2 + data[from + 3]));
        int hashAlgoFieldLen = 0xFF & data[from + 1];
        this.nameHashFrom = from + 2 + hashAlgoFieldLen;
    }

    public static int arraycopy(byte[] hashData, byte[] data, int offset) {
        System.arraycopy(hashData, 0, data, offset, hashData.length);
        return hashData.length;
    }

    public HashAlgo hashAlgorithm() {
        return this.hashAlgo;
    }

    public String hashAlgorithmOID() {
        if (this.hashAlgo != null) {
            return this.hashAlgo.getOid().getId();
        }
        int start = this.from + 2;
        byte[] bytes = Arrays.copyOfRange(this.data, start, start + 2 + (0xFF & this.data[this.from + 3]));
        return ASN1ObjectIdentifier.getInstance((Object)bytes).getId();
    }

    public int getFrom() {
        return this.from;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getNameHashFrom() {
        return this.nameHashFrom;
    }

    public int getLength() {
        return this.length;
    }

    public int write(byte[] out, int offset) {
        System.arraycopy(this.data, this.from, out, offset, this.length);
        return this.length;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestIssuer)) {
            return false;
        }
        RequestIssuer other = (RequestIssuer)obj;
        return this.length == other.length && CompareUtil.areEqual((byte[])this.data, (int)this.from, (byte[])other.data, (int)other.from, (int)this.length);
    }

    public String toString() {
        return Hex.encode((byte[])Arrays.copyOfRange(this.data, this.from, this.from + this.length));
    }
}

