/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public interface CaCertValidator {
    public boolean isTrusted(X509Cert var1);

    public static final class PreprovisionedHashCaCertValidator
    implements CaCertValidator {
        private final HashAlgo hashAlgo;
        private final Set<byte[]> hashValues;

        public PreprovisionedHashCaCertValidator(HashAlgo hashAlgo, Set<byte[]> hashValues) {
            this.hashAlgo = (HashAlgo)Args.notNull((Object)hashAlgo, (String)"hashAlgo");
            Args.notEmpty(hashValues, (String)"hashValues");
            int hLen = hashAlgo.getLength();
            for (byte[] m : hashValues) {
                if (m.length == hLen) continue;
                throw new IllegalArgumentException("invalid the length of hashValue: " + m.length + " != " + hLen);
            }
            this.hashValues = new HashSet<byte[]>(hashValues.size());
            for (byte[] m : hashValues) {
                this.hashValues.add(Arrays.copyOf(m, m.length));
            }
        }

        @Override
        public boolean isTrusted(X509Cert cert) {
            byte[] actual = this.hashAlgo.hash((byte[][])new byte[][]{((X509Cert)Args.notNull((Object)cert, (String)"cert")).getEncoded()});
            for (byte[] m : this.hashValues) {
                if (!Arrays.equals(actual, m)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class PreprovisionedCaCertValidator
    implements CaCertValidator {
        private final Set<String> fpOfCerts;

        public PreprovisionedCaCertValidator(X509Cert cert) {
            Args.notNull((Object)cert, (String)"cert");
            this.fpOfCerts = new HashSet<String>(1);
            this.fpOfCerts.add(HashAlgo.SHA256.hexHash((byte[][])new byte[][]{cert.getEncoded()}));
        }

        public PreprovisionedCaCertValidator(Set<X509Cert> certs) {
            Args.notEmpty(certs, (String)"certs");
            this.fpOfCerts = new HashSet<String>(certs.size());
            for (X509Cert m : certs) {
                this.fpOfCerts.add(HashAlgo.SHA256.hexHash((byte[][])new byte[][]{m.getEncoded()}));
            }
        }

        @Override
        public boolean isTrusted(X509Cert cert) {
            String hextFp = HashAlgo.SHA256.hexHash((byte[][])new byte[][]{((X509Cert)Args.notNull((Object)cert, (String)"cert")).getEncoded()});
            return this.fpOfCerts.contains(hextFp);
        }
    }

    public static final class CachingCertificateValidator
    implements CaCertValidator {
        private final ConcurrentHashMap<String, Boolean> cachedAnswers;
        private final CaCertValidator delegate;

        public CachingCertificateValidator(CaCertValidator delegate) {
            this.delegate = (CaCertValidator)Args.notNull((Object)delegate, (String)"delegate");
            this.cachedAnswers = new ConcurrentHashMap();
        }

        @Override
        public boolean isTrusted(X509Cert cert) {
            Args.notNull((Object)cert, (String)"cert");
            String hexFp = HashAlgo.SHA256.hexHash((byte[][])new byte[][]{cert.getEncoded()});
            Boolean bo = this.cachedAnswers.get(hexFp);
            if (bo != null) {
                return bo;
            }
            boolean answer = this.delegate.isTrusted(cert);
            this.cachedAnswers.put(hexFp, answer);
            return answer;
        }
    }
}

