/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.xipki.scep.transaction.Operation;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class CaIdentifier {
    private final String url;
    private final String profile;

    public CaIdentifier(String serverUrl, String profile) throws MalformedURLException {
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        URL tmpUrl = new URL(serverUrl);
        String protocol = tmpUrl.getProtocol();
        if (!StringUtil.orEqualsIgnoreCase((String)protocol, (String[])new String[]{"http", "https"})) {
            throw new IllegalArgumentException("URL protocol should be HTTP or HTTPS, but not '" + protocol + "'");
        }
        if (tmpUrl.getQuery() != null) {
            throw new IllegalArgumentException("URL should contain no query string");
        }
        this.url = serverUrl;
        this.profile = profile;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProfile() {
        return this.profile;
    }

    public String buildGetUrl(Operation operation) {
        return this.buildGetUrl(operation, null);
    }

    public String buildGetUrl(Operation operation, String message) {
        String str = this.url + "?operation=" + ((Operation)Args.notNull((Object)operation, (String)"operation")).getCode();
        return StringUtil.isBlank((String)message) ? str : str + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
    }

    public String buildPostUrl(Operation operation) {
        return this.url + "?operation=" + ((Operation)Args.notNull((Object)operation, (String)"operation")).getCode();
    }

    public String toString() {
        return StringUtil.isBlank((String)this.profile) ? "URL: " + this.url : "URL: " + this.url + ", CA-Ident: " + this.profile;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CaIdentifier)) {
            return false;
        }
        CaIdentifier objB = (CaIdentifier)object;
        return this.url.equals(objB.url) && Objects.equals(this.profile, objB.profile);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

