/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.servlet5;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.servlet5.XiHttpRequestImpl;
import org.xipki.servlet5.XiHttpResponseImpl;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public abstract class ServletFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ServletFilter.class);
    private XiHttpFilter filter0;

    protected abstract XiHttpFilter initFilter(FilterConfig var1) throws Exception;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.filter0 = this.initFilter(filterConfig);
        }
        catch (Exception ex) {
            LOG.error("error initializing ServletFiler", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
        if (this.filter0 != null) {
            this.filter0.destroy();
            this.filter0 = null;
        }
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filter0 == null) {
            throw new ServletException("filter is not initialized");
        }
        if (!(request instanceof HttpServletRequest & response instanceof HttpServletResponse)) {
            throw new ServletException("Only HTTP request is supported");
        }
        try {
            this.filter0.doFilter((XiHttpRequest)new XiHttpRequestImpl((HttpServletRequest)request), (XiHttpResponse)new XiHttpResponseImpl((HttpServletResponse)response));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

