/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.kpgen;

import java.io.Closeable;
import java.math.BigInteger;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;

public abstract class KeypairGenerator
implements Closeable {
    protected String name;
    protected BigInteger rsaE;
    protected final Set<String> keyspecs = new HashSet<String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialize(String conf) throws XiSecurityException {
        String str;
        String str2;
        ConfPairs pairs;
        ConfPairs confPairs = pairs = conf == null ? null : new ConfPairs(conf);
        if (pairs != null && StringUtil.isNotBlank((String)(str2 = pairs.value("RSA.E")))) {
            this.rsaE = StringUtil.toBigInt((String)str2);
        }
        if (this.rsaE == null) {
            this.rsaE = RSAKeyGenParameterSpec.F4;
        }
        HashSet<String> tokens = null;
        if (pairs != null && StringUtil.isNotBlank((String)(str = pairs.value("keyspecs")))) {
            tokens = StringUtil.splitAsSet((String)str.toUpperCase(Locale.ROOT), (String)": \t");
        }
        if (tokens == null) {
            tokens = new HashSet<String>(Arrays.asList("RSA", "EC", "DSA", "ED25519", "ED448", "X25519", "X448"));
        }
        block12: for (String token : tokens) {
            try {
                switch (token) {
                    case "RSA": {
                        for (int i = 2; i < 9; ++i) {
                            this.keyspecs.add("RSA/" + i * 1024);
                        }
                        continue block12;
                    }
                    case "DSA": {
                        this.keyspecs.add("DSA/1024/160");
                        this.keyspecs.add("DSA/2048/224");
                        this.keyspecs.add("DSA/2048/256");
                        this.keyspecs.add("DSA/3072/256");
                        break;
                    }
                    case "EC": {
                        List curveNames = AlgorithmUtil.getECCurveNames();
                        for (String curveName : curveNames) {
                            ASN1ObjectIdentifier curveId = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
                            if (curveId == null) continue;
                            String keyspec = "EC/" + curveId.getId();
                            this.keyspecs.add(keyspec);
                        }
                        continue block12;
                    }
                    default: {
                        if (token.startsWith("EC/")) {
                            String nameOrOid = token.substring(3);
                            ASN1ObjectIdentifier curveId = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)nameOrOid);
                            if (curveId == null) {
                                throw new XiSecurityException("invalid keyspec " + token);
                            }
                            this.keyspecs.add("EC/" + curveId.getId());
                            break;
                        }
                        if (token.startsWith("RSA/")) {
                            int keysize = Integer.parseInt(token.substring(4));
                            this.keyspecs.add("RSA/" + keysize);
                            break;
                        }
                        if (token.startsWith("DSA/")) {
                            String[] strs = token.substring(4).split("/");
                            int pSize = Integer.parseInt(strs[0]);
                            int qSize = Integer.parseInt(strs[1]);
                            this.keyspecs.add("DSA/" + pSize + "/" + qSize);
                            break;
                        }
                        this.keyspecs.add(token);
                    }
                }
            }
            catch (RuntimeException e) {
                throw new XiSecurityException("invalid keyspec " + token);
            }
        }
        this.initialize0(pairs);
    }

    protected abstract void initialize0(ConfPairs var1) throws XiSecurityException;

    public boolean supports(String keyspec) {
        return keyspec != null && this.keyspecs.contains(keyspec.toUpperCase(Locale.ROOT));
    }

    public abstract PrivateKeyInfo generateKeypair(String var1) throws XiSecurityException;

    public abstract boolean isHealthy();
}

