/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.ExtensionValue;
import org.xipki.util.Args;

public class ExtensionValues {
    private final Map<ASN1ObjectIdentifier, ExtensionValue> extensions = new HashMap<ASN1ObjectIdentifier, ExtensionValue>();

    public void addExtension(ASN1ObjectIdentifier type, boolean critical, ASN1Encodable value) throws CertprofileException {
        Args.notNull((Object)type, (String)"type");
        Args.notNull((Object)value, (String)"value");
        if (this.extensions.containsKey(type)) {
            throw new CertprofileException("Extension " + type.getId() + " exists");
        }
        this.extensions.put(type, new ExtensionValue(critical, value));
    }

    public void addExtension(ASN1ObjectIdentifier type, ExtensionValue value) throws CertprofileException {
        Args.notNull((Object)type, (String)"type");
        Args.notNull((Object)value, (String)"value");
        if (this.extensions.containsKey(type)) {
            throw new CertprofileException("Extension " + type.getId() + " exists");
        }
        this.extensions.put(type, value);
    }

    public Set<ASN1ObjectIdentifier> getExtensionTypes() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    public ExtensionValue getExtensionValue(ASN1ObjectIdentifier type) {
        return this.extensions.get(Args.notNull((Object)type, (String)"type"));
    }

    public ExtensionValue removeExtensionTuple(ASN1ObjectIdentifier type) {
        return this.extensions.remove(Args.notNull((Object)type, (String)"type"));
    }

    public int size() {
        return this.extensions.size();
    }
}

