/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.DatabaseType;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.Passwords;
import org.xipki.util.Args;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.exception.InvalidConfException;

public class DataSourceFactory {
    public DataSourceWrapper createDataSource(String name, FileOrValue conf) throws IOException, InvalidConfException {
        ConfigurableProperties props;
        try (StringReader reader = new StringReader(((FileOrValue)Args.notNull((Object)conf, (String)"conf")).readContent());){
            props = new ConfigurableProperties();
            props.load((Reader)reader);
        }
        return this.createDataSource(name, props);
    }

    public DataSourceWrapper createDataSource(String name, InputStream conf) throws IOException, InvalidConfException {
        ConfigurableProperties config = new ConfigurableProperties();
        config.load((InputStream)Args.notNull((Object)conf, (String)"conf"));
        return this.createDataSource(name, config);
    }

    public DataSourceWrapper createDataSource(String name, ConfigurableProperties conf) throws InvalidConfException {
        DatabaseType databaseType;
        String className = ((ConfigurableProperties)Args.notNull((Object)conf, (String)"conf")).getProperty("dataSourceClassName");
        if (className != null) {
            databaseType = DatabaseType.forDataSourceClass(className);
        } else {
            className = conf.getProperty("driverClassName");
            if (className != null) {
                databaseType = DatabaseType.forDriver(className);
            } else {
                String jdbcUrl = Optional.ofNullable(conf.getProperty("jdbcUrl")).orElseThrow(() -> new IllegalArgumentException("none of the properties dataSourceClassName, driverClassName and jdbcUrl is configured"));
                databaseType = DatabaseType.forJdbcUrl(jdbcUrl);
            }
        }
        try {
            String password = conf.getProperty("password");
            if (password != null) {
                password = new String(Passwords.resolvePassword((String)password));
                conf.setProperty("password", password);
            }
            if ((password = conf.getProperty("dataSource.password")) != null) {
                password = new String(Passwords.resolvePassword((String)password));
                conf.setProperty("dataSource.password", password);
            }
        }
        catch (PasswordResolverException ex) {
            throw new InvalidConfException("error resolving password");
        }
        Object dataSourceUrl = conf.getProperty("dataSource.url");
        if (dataSourceUrl == null) {
            if (databaseType == DatabaseType.MARIADB) {
                String serverName = conf.remove("dataSource.serverName");
                String port = conf.remove("dataSource.port");
                if (port == null) {
                    port = "3306";
                }
                String databaseName = conf.remove("dataSource.databaseName");
                dataSourceUrl = "jdbc:mariadb://" + serverName + ":" + port + "/" + databaseName;
                conf.setProperty("dataSource.url", (String)dataSourceUrl);
            }
        } else {
            String newUrl = null;
            String h2_prefix = "jdbc:h2:";
            String hsqldb_prefix = "jdbc:hsqldb:file:";
            if (((String)dataSourceUrl).startsWith("jdbc:h2:~")) {
                newUrl = "jdbc:h2:" + IoUtil.expandFilepath((String)((String)dataSourceUrl).substring("jdbc:h2:".length()));
            } else if (((String)dataSourceUrl).startsWith("jdbc:hsqldb:file:~")) {
                newUrl = "jdbc:hsqldb:file:" + IoUtil.expandFilepath((String)((String)dataSourceUrl).substring("jdbc:hsqldb:file:".length()));
            }
            if (newUrl != null) {
                conf.setProperty("dataSource.url", newUrl);
            }
        }
        for (String key : conf.propertyNames()) {
            if (!key.startsWith("sqlscript.") && !key.startsWith("liquibase.")) continue;
            conf.remove(key);
        }
        return DataSourceWrapper.createDataSource(name, conf, databaseType);
    }

    public DataSourceWrapper createDataSourceForFile(String name, String confFile) throws IOException, InvalidConfException {
        String path = IoUtil.expandFilepath((String)Args.notBlank((String)confFile, (String)"confFile"));
        try (InputStream fileIn = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            DataSourceWrapper dataSourceWrapper = this.createDataSource(name, fileIn);
            return dataSourceWrapper;
        }
    }
}

