/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.IOException;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.cbor.CborDecoder;
import org.xipki.apppackage.cbor.CborEncoder;

public class PathInfo {
    private Integer posixPermissions;
    private String path;
    private Long lastModified;

    public Integer getPosixPermissions() {
        return this.posixPermissions;
    }

    public void setPosixPermissions(Integer posixPermissions) {
        this.posixPermissions = posixPermissions;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public void encode(CborEncoder encoder) throws IOException {
        encoder.writeArrayStart(3);
        encoder.writeTextString(this.path);
        if (this.posixPermissions == null) {
            encoder.writeNull();
        } else {
            encoder.writeInt(this.posixPermissions.intValue());
        }
        if (this.lastModified == null) {
            encoder.writeNull();
        } else {
            encoder.writeInt(this.lastModified);
        }
    }

    public static PathInfo decode(CborDecoder decoder) throws IOException {
        MyUtil.readArrayStart(3, decoder);
        PathInfo ret = new PathInfo();
        ret.setPath(decoder.readTextString());
        Long l = MyUtil.readLong(decoder);
        if (l != null) {
            ret.setPosixPermissions(l.intValue());
        }
        ret.setLastModified(MyUtil.readLong(decoder));
        return ret;
    }
}

