/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage.cbor;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.xipki.apppackage.cbor.CborType;

public class CborDecoder {
    protected final PushbackInputStream m_is;

    public CborDecoder(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        this.m_is = is instanceof PushbackInputStream ? (PushbackInputStream)is : new PushbackInputStream(is);
    }

    private static void fail(String msg, Object ... args) throws IOException {
        throw new IOException(String.format(msg, args));
    }

    public CborType peekType() throws IOException {
        int p = this.m_is.read();
        if (p < 0) {
            return null;
        }
        this.m_is.unread(p);
        return CborType.valueOf(p);
    }

    public long readArrayLength() throws IOException {
        return this.readMajorTypeWithSize(4);
    }

    public boolean readBoolean() throws IOException {
        int b = this.readMajorType(7);
        if (b != 20 && b != 21) {
            CborDecoder.fail("Unexpected boolean value: %d!", b);
        }
        return b == 21;
    }

    public byte[] readByteString() throws IOException {
        long len = this.readMajorTypeWithSize(2);
        if (len < 0L) {
            CborDecoder.fail("Infinite-length byte strings not supported!", new Object[0]);
        }
        if (len > Integer.MAX_VALUE) {
            CborDecoder.fail("String length too long!", new Object[0]);
        }
        return this.readFully(new byte[(int)len]);
    }

    public long readInt() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return ui ^ this.readUInt(ib & 0x1F, false);
    }

    public Object readNull() throws IOException {
        this.readMajorTypeExact(7, 22);
        return null;
    }

    public String readTextString() throws IOException {
        long len = this.readMajorTypeWithSize(3);
        if (len < 0L) {
            CborDecoder.fail("Infinite-length text strings not supported!", new Object[0]);
        }
        if (len > Integer.MAX_VALUE) {
            CborDecoder.fail("String length too long!", new Object[0]);
        }
        return new String(this.readFully(new byte[(int)len]), "UTF-8");
    }

    protected long expectIntegerType(int ib) throws IOException {
        int majorType = (ib & 0xFF) >>> 5;
        if (majorType != 0 && majorType != 1) {
            CborDecoder.fail("Unexpected type: %s, expected type %s or %s!", CborType.getName(majorType), CborType.getName(0), CborType.getName(1));
        }
        return -majorType;
    }

    protected int readMajorType(int majorType) throws IOException {
        int ib = this.m_is.read();
        if (majorType != (ib >>> 5 & 7)) {
            CborDecoder.fail("Unexpected type: %s, expected: %s!", CborType.getName(ib), CborType.getName(majorType));
        }
        return ib & 0x1F;
    }

    protected void readMajorTypeExact(int majorType, int subtype) throws IOException {
        int st = this.readMajorType(majorType);
        if ((st ^ subtype) != 0) {
            CborDecoder.fail("Unexpected subtype: %d, expected: %d!", st, subtype);
        }
    }

    protected long readMajorTypeWithSize(int majorType) throws IOException {
        return this.readUInt(this.readMajorType(majorType), true);
    }

    protected long readUInt(int length, boolean breakAllowed) throws IOException {
        long result = -1L;
        if (length < 24) {
            result = length;
        } else if (length == 24) {
            result = this.readUInt8();
        } else if (length == 25) {
            result = this.readUInt16();
        } else if (length == 26) {
            result = this.readUInt32();
        } else if (length == 27) {
            result = this.readUInt64();
        } else if (breakAllowed && length == 31) {
            return -1L;
        }
        if (result < 0L) {
            CborDecoder.fail("Not well-formed CBOR integer found, invalid length: %d!", result);
        }
        return result;
    }

    protected int readUInt16() throws IOException {
        byte[] buf = this.readFully(new byte[2]);
        return (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
    }

    protected long readUInt32() throws IOException {
        byte[] buf = this.readFully(new byte[4]);
        return (long)((buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF) & 0xFFFFFFFFL;
    }

    protected long readUInt64() throws IOException {
        byte[] buf = this.readFully(new byte[8]);
        return ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
    }

    protected int readUInt8() throws IOException {
        return this.m_is.read() & 0xFF;
    }

    private byte[] readFully(byte[] buf) throws IOException {
        int count;
        int len = buf.length;
        int off = 0;
        for (int n = 0; n < len; n += count) {
            count = this.m_is.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return buf;
    }
}

