/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xipki.password.Args;

class ConfPairs {
    private static final char BACKSLASH = '\\';
    public static final char NAME_TERM = '=';
    public static final char TOKEN_TERM = ',';
    private final Map<String, String> pairs = new HashMap<String, String>();

    ConfPairs(String confPairs) {
        if (Args.isBlank(confPairs)) {
            return;
        }
        int len = confPairs.length();
        LinkedList<String> tokens = new LinkedList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        int i = 0;
        while (i < len) {
            char ch = confPairs.charAt(i);
            if (',' == ch) {
                if (tokenBuilder.length() > 0) {
                    tokens.add(tokenBuilder.toString());
                }
                tokenBuilder = new StringBuilder();
                ++i;
                continue;
            }
            if ('\\' == ch) {
                if (i == len - 1) {
                    throw new IllegalArgumentException("invalid ConfPairs '" + confPairs + "'");
                }
                tokenBuilder.append(ch);
                ch = confPairs.charAt(i + 1);
                ++i;
            }
            tokenBuilder.append(ch);
            ++i;
        }
        if (tokenBuilder.length() > 0) {
            tokens.add(tokenBuilder.toString());
        }
        for (String token : tokens) {
            char ch;
            int termPosition = -1;
            len = token.length();
            int i2 = 0;
            while (i2 < len) {
                ch = token.charAt(i2);
                if (ch == '=') {
                    termPosition = i2;
                    break;
                }
                if ('\\' == ch) {
                    if (i2 == len - 1) {
                        throw new IllegalArgumentException("invalid ConfPairs '" + confPairs + "'");
                    }
                    i2 += 2;
                    continue;
                }
                ++i2;
            }
            if (termPosition < 1) {
                throw new IllegalArgumentException("invalid ConfPair '" + token + "'");
            }
            tokenBuilder = new StringBuilder();
            i2 = 0;
            while (i2 < termPosition) {
                ch = token.charAt(i2);
                if ('\\' == ch) {
                    if (i2 == termPosition - 1) {
                        throw new IllegalArgumentException("invalid ConfPair '" + confPairs + "'");
                    }
                    i2 += 2;
                    continue;
                }
                tokenBuilder.append(ch);
                ++i2;
            }
            String name = tokenBuilder.toString();
            tokenBuilder = new StringBuilder();
            for (int i3 = termPosition + 1; i3 < len; ++i3) {
                char ch2 = token.charAt(i3);
                if ('\\' == ch2) {
                    if (i3 == len - 1) {
                        throw new IllegalArgumentException("invalid ConfPair '" + confPairs + "'");
                    }
                    ch2 = token.charAt(i3 + 1);
                    ++i3;
                }
                tokenBuilder.append(ch2);
            }
            String value = tokenBuilder.toString();
            this.pairs.put(name, value);
        }
    }

    String value(String name) {
        return this.pairs.get(Args.notBlank(name, "name"));
    }
}

