/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.xipki.password.Args;
import org.xipki.password.PBEAlgo;
import org.xipki.password.PasswordBasedEncryption;
import org.xipki.password.PasswordResolverException;

public class PBEPasswordService {
    static final SecureRandom random = new SecureRandom();
    public static final String PROTOCOL_PBE = "PBE";

    public static char[] decryptPassword(char[] masterPassword, String passwordHint) throws PasswordResolverException {
        byte[] pwd;
        int bb;
        byte[] bytes;
        int len;
        Args.notNull(masterPassword, "masterPassword");
        Args.notNull(passwordHint, "passwordHint");
        passwordHint = passwordHint.trim();
        if (!passwordHint.startsWith("PBE:")) {
            throw new PasswordResolverException("encrypted password does not start with 'PBE:'");
        }
        Object passwordHintWithoutPrefix = passwordHint.substring(4);
        int b64Len = ((String)passwordHintWithoutPrefix).length();
        if (b64Len % 4 != 0) {
            char[] suffix = new char[4 - b64Len % 4];
            Arrays.fill(suffix, '=');
            passwordHintWithoutPrefix = (String)passwordHintWithoutPrefix + new String(suffix);
        }
        if ((len = (bytes = Base64.getDecoder().decode((String)passwordHintWithoutPrefix)).length) <= 16 && len != 0) {
            throw new PasswordResolverException("invalid length of the encrypted password");
        }
        int offset = 0;
        int algoCode = (bb = bytes[offset++]) < 0 ? 256 + bb : bb;
        PBEAlgo algo = Optional.ofNullable(PBEAlgo.forCode(algoCode)).orElseThrow(() -> new PasswordResolverException("unknown algorithm code " + algoCode));
        byte[] iterationCountBytes = Arrays.copyOfRange(bytes, offset, offset + 2);
        byte[] salt = Arrays.copyOfRange(bytes, offset += 2, offset + 16);
        byte[] cipherText = Arrays.copyOfRange(bytes, offset += 16, len);
        int iterationCount = new BigInteger(1, iterationCountBytes).intValue();
        try {
            pwd = PasswordBasedEncryption.decrypt(algo, cipherText, masterPassword, iterationCount, salt);
        }
        catch (GeneralSecurityException ex) {
            throw new PasswordResolverException("could not decrypt the password: " + ex.getMessage());
        }
        char[] ret = new char[pwd.length];
        for (int i = 0; i < pwd.length; ++i) {
            ret[i] = (char)pwd[i];
        }
        return ret;
    }

    public static String encryptPassword(PBEAlgo algo, int iterationCount, char[] masterPassword, char[] password) throws PasswordResolverException {
        byte[] encrypted;
        if (iterationCount < 1 || iterationCount > 65535) {
            throw new IllegalArgumentException("iterationCount may not be out of the range [1, 65535]: " + iterationCount);
        }
        Args.notNull(masterPassword, "masterPassword");
        Args.notNull(password, "password");
        byte[] iterationCountBytes = new byte[]{(byte)(iterationCount >>> 8), (byte)(iterationCount & 0xFF)};
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        try {
            encrypted = PasswordBasedEncryption.encrypt(algo, Args.toUtf8Bytes(new String(password)), masterPassword, iterationCount, salt);
        }
        catch (GeneralSecurityException ex) {
            throw new PasswordResolverException("could not encrypt the password: " + ex.getMessage());
        }
        byte[] encryptedText = new byte[3 + salt.length + encrypted.length];
        int offset = 0;
        encryptedText[offset++] = (byte)(algo.code() & 0xFF);
        System.arraycopy(iterationCountBytes, 0, encryptedText, offset, 2);
        System.arraycopy(salt, 0, encryptedText, offset += 2, salt.length);
        System.arraycopy(encrypted, 0, encryptedText, offset += salt.length, encrypted.length);
        String b64 = Base64.getEncoder().encodeToString(encryptedText);
        int endIndex = b64.length();
        while (b64.charAt(endIndex - 1) == '=') {
            --endIndex;
        }
        return "PBE:" + b64.substring(0, endIndex);
    }
}

