/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.xipki.password.Args;
import org.xipki.password.PBEAlgo;

public class PasswordBasedEncryption {
    private PasswordBasedEncryption() {
    }

    public static byte[] encrypt(PBEAlgo algo, byte[] plaintext, char[] password, int iterationCount, byte[] salt) throws GeneralSecurityException {
        int ivLen;
        Args.notNull(plaintext, "plaintext");
        Args.notNull(password, "password");
        Args.positive(iterationCount, "iterationCount");
        Args.notNull(salt, "salt");
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algo.algoName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(algo.algoName());
        PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, iterationCount);
        cipher.init(1, (Key)pbeKey, pbeParameterSpec);
        pbeKeySpec.clearPassword();
        byte[] iv = cipher.getIV();
        int n = ivLen = iv == null ? 0 : iv.length;
        if (ivLen > 255) {
            throw new GeneralSecurityException("IV too long: " + ivLen);
        }
        byte[] cipherText = cipher.doFinal(plaintext);
        byte[] ret = new byte[1 + ivLen + cipherText.length];
        ret[0] = (byte)(ivLen & 0xFF);
        if (ivLen > 0) {
            System.arraycopy(iv, 0, ret, 1, ivLen);
        }
        System.arraycopy(cipherText, 0, ret, 1 + ivLen, cipherText.length);
        return ret;
    }

    public static byte[] decrypt(PBEAlgo algo, byte[] cipherTextWithIv, char[] password, int iterationCount, byte[] salt) throws GeneralSecurityException {
        PBEParameterSpec pbeParameterSpec;
        int ivLen;
        Args.notNull(cipherTextWithIv, "cipherTextWithIv");
        Args.notNull(password, "password");
        Args.positive(iterationCount, "iterationCount");
        Args.notNull(salt, "salt");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algo.algoName());
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(algo.algoName());
        int bb = cipherTextWithIv[0];
        int n = ivLen = bb < 0 ? 256 + bb : bb;
        if (ivLen == 0) {
            pbeParameterSpec = new PBEParameterSpec(salt, iterationCount);
        } else {
            byte[] iv = new byte[ivLen];
            System.arraycopy(cipherTextWithIv, 1, iv, 0, ivLen);
            pbeParameterSpec = new PBEParameterSpec(salt, iterationCount, new IvParameterSpec(iv));
        }
        int cipherTextOffset = 1 + ivLen;
        byte[] cipherText = new byte[cipherTextWithIv.length - cipherTextOffset];
        System.arraycopy(cipherTextWithIv, 1 + ivLen, cipherText, 0, cipherText.length);
        cipher.init(2, (Key)pbeKey, pbeParameterSpec);
        return cipher.doFinal(cipherText);
    }
}

