/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.CaNameSigners;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.acme.AcmeHttpServlet;
import org.xipki.ca.gateway.acme.AcmeProtocolConf;
import org.xipki.ca.gateway.acme.AcmeResponder;
import org.xipki.ca.gateway.api.RequestorAuthenticator;
import org.xipki.ca.gateway.cmp.CmpControl;
import org.xipki.ca.gateway.cmp.CmpHttpServlet;
import org.xipki.ca.gateway.cmp.CmpProtocolConf;
import org.xipki.ca.gateway.cmp.CmpResponder;
import org.xipki.ca.gateway.conf.CaNameSignerConf;
import org.xipki.ca.gateway.conf.CaNameSignersConf;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.gateway.conf.GatewayConf;
import org.xipki.ca.gateway.conf.SignerConf;
import org.xipki.ca.gateway.est.EstHttpServlet;
import org.xipki.ca.gateway.est.EstProtocolConf;
import org.xipki.ca.gateway.est.EstResponder;
import org.xipki.ca.gateway.rest.RestHttpServlet;
import org.xipki.ca.gateway.rest.RestProtocolConf;
import org.xipki.ca.gateway.rest.RestResponder;
import org.xipki.ca.gateway.scep.CaNameScepSigners;
import org.xipki.ca.gateway.scep.ScepHttpServlet;
import org.xipki.ca.gateway.scep.ScepProtocolConf;
import org.xipki.ca.gateway.scep.ScepResponder;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.Securities;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ReflectiveUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class GatewayHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GatewayHttpFilter.class);
    private static final String DFLT_CFG = "etc/gateway.json";
    private static final String ACME_CFG = "etc/acme-gateway.json";
    private static final String CMP_CFG = "etc/cmp-gateway.json";
    private static final String EST_CFG = "etc/est-gateway.json";
    private static final String REST_CFG = "etc/rest-gateway.json";
    private static final String SCEP_CFG = "etc/scep-gateway.json";
    private AcmeHttpServlet acmeServlet;
    private CmpHttpServlet cmpServlet;
    private EstHttpServlet estServlet;
    private RestHttpServlet restServlet;
    private ScepHttpServlet scepServlet;
    private Securities securities;

    public GatewayHttpFilter() throws Exception {
        GatewayConf gatewayConf;
        XipkiBaseDir.init();
        try {
            gatewayConf = GatewayConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
        }
        catch (IOException ex) {
            throw new IOException("could not parse configuration file etc/gateway.json", ex);
        }
        catch (InvalidConfException ex) {
            throw new InvalidConfException("could not parse configuration file etc/gateway.json", (Throwable)ex);
        }
        this.securities = new Securities();
        try {
            this.securities.init(gatewayConf.getSecurity());
        }
        catch (IOException ex) {
            throw new InvalidConfException("could not initialize Securities", (Throwable)ex);
        }
        Audits.init((String)gatewayConf.getAudit().getType(), (ConfPairs)gatewayConf.getAudit().getConf());
        if (Audits.getAuditService() == null) {
            throw new InvalidConfException("could not init AuditService");
        }
        SdkClient gSdkClient = new SdkClient(gatewayConf.getSdkClient());
        boolean gLogReqResp = gatewayConf.isLogReqResp();
        String reverseProxyMode = gatewayConf.getReverseProxyMode();
        PopControl gPopControl = new PopControl(gatewayConf.getPop());
        GatewayConf.SupportedProtocols protocols = gatewayConf.getProtocols();
        boolean enabled = protocols.isAcme();
        LOG.info("ACME is " + (enabled ? "enabled" : "disabled"));
        if (enabled) {
            this.initAcme(gLogReqResp, gSdkClient, gPopControl);
        }
        LOG.info("CMP is " + ((enabled = protocols.isCmp()) ? "enabled" : "disabled"));
        if (enabled) {
            this.initCmp(gLogReqResp, gSdkClient, gPopControl, reverseProxyMode);
        }
        LOG.info("EST is " + ((enabled = protocols.isEst()) ? "enabled" : "disabled"));
        if (enabled) {
            this.initEst(gLogReqResp, gSdkClient, gPopControl, reverseProxyMode);
        }
        LOG.info("REST is " + ((enabled = protocols.isRest()) ? "enabled" : "disabled"));
        if (enabled) {
            this.initRest(gLogReqResp, gSdkClient, gPopControl, reverseProxyMode);
        }
        LOG.info("SCEP is " + ((enabled = protocols.isScep()) ? "enabled" : "disabled"));
        if (enabled) {
            this.initScep(gLogReqResp, gSdkClient, gPopControl);
        }
        GatewayUtil.auditLogPciEvent(LOG, "Gateway", true, "START");
    }

    private void initAcme(boolean gLogReqResp, SdkClient gSdkClient, PopControl gPopControl) {
        try {
            AcmeProtocolConf pconf = AcmeProtocolConf.readConfFromFile(IoUtil.expandFilepath((String)ACME_CFG, (boolean)true));
            boolean logReqResp = gLogReqResp;
            if (pconf.getLogReqResp() != null) {
                logReqResp = pconf.getLogReqResp();
            }
            SdkClient sdkClient = gSdkClient;
            if (pconf.getSdkClient() != null) {
                sdkClient = new SdkClient(pconf.getSdkClient());
                sdkClient.setLogReqResp(logReqResp);
            }
            PopControl popControl = gPopControl;
            if (pconf.getPop() != null) {
                popControl = new PopControl(pconf.getPop());
            }
            AcmeResponder responder = new AcmeResponder(sdkClient, this.securities.getSecurityFactory(), popControl, pconf.getAcme());
            responder.start();
            this.acmeServlet = new AcmeHttpServlet(logReqResp, responder);
            LOG.info("started ACME gateway");
        }
        catch (Throwable ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error starting ACME gateway");
        }
    }

    private void initCmp(boolean gLogReqResp, SdkClient gSdkClient, PopControl gPopControl, String reverseProxyMode) {
        try {
            CmpProtocolConf pconf = CmpProtocolConf.readConfFromFile(IoUtil.expandFilepath((String)CMP_CFG, (boolean)true));
            boolean logReqResp = gLogReqResp;
            if (pconf.getLogReqResp() != null) {
                logReqResp = pconf.getLogReqResp();
            }
            SdkClient sdkClient = gSdkClient;
            if (pconf.getSdkClient() != null) {
                sdkClient = new SdkClient(pconf.getSdkClient());
                sdkClient.setLogReqResp(logReqResp);
            }
            PopControl popControl = gPopControl;
            if (pconf.getPop() != null) {
                popControl = new PopControl(pconf.getPop());
            }
            RequestorAuthenticator authenticator = GatewayHttpFilter.newAuthenticator(pconf.getAuthenticator());
            CaNameSigners signers = GatewayHttpFilter.newCaSigners(this.securities, pconf.getSigners());
            CmpControl cmpControl = new CmpControl(pconf.getCmp());
            CmpResponder responder = new CmpResponder(cmpControl, sdkClient, this.securities.getSecurityFactory(), signers, authenticator, popControl);
            this.cmpServlet = new CmpHttpServlet(logReqResp, reverseProxyMode, responder);
            LOG.info("started CMP gateway");
        }
        catch (Throwable ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error starting CMP gateway");
        }
    }

    private void initEst(boolean gLogReqResp, SdkClient gSdkClient, PopControl gPopControl, String reverseProxyMode) {
        try {
            EstProtocolConf pconf = EstProtocolConf.readConfFromFile(IoUtil.expandFilepath((String)EST_CFG, (boolean)true));
            boolean logReqResp = gLogReqResp;
            if (pconf.getLogReqResp() != null) {
                logReqResp = pconf.getLogReqResp();
            }
            SdkClient sdkClient = gSdkClient;
            if (pconf.getSdkClient() != null) {
                sdkClient = new SdkClient(pconf.getSdkClient());
                sdkClient.setLogReqResp(logReqResp);
            }
            PopControl popControl = gPopControl;
            if (pconf.getPop() != null) {
                popControl = new PopControl(pconf.getPop());
            }
            RequestorAuthenticator authenticator = GatewayHttpFilter.newAuthenticator(pconf.getAuthenticator());
            CaProfilesControl caProfilesControl = new CaProfilesControl(pconf.getCaProfiles());
            EstResponder responder = new EstResponder(sdkClient, this.securities.getSecurityFactory(), authenticator, popControl, caProfilesControl, reverseProxyMode);
            this.estServlet = new EstHttpServlet(logReqResp, responder);
            LOG.info("started EST gateway");
        }
        catch (Throwable ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error starting EST gateway");
        }
    }

    private void initRest(boolean gLogReqResp, SdkClient gSdkClient, PopControl gPopControl, String reverseProxyMode) {
        try {
            RestProtocolConf pconf = RestProtocolConf.readConfFromFile(IoUtil.expandFilepath((String)REST_CFG, (boolean)true));
            boolean logReqResp = gLogReqResp;
            if (pconf.getLogReqResp() != null) {
                logReqResp = pconf.getLogReqResp();
            }
            SdkClient sdkClient = gSdkClient;
            if (pconf.getSdkClient() != null) {
                sdkClient = new SdkClient(pconf.getSdkClient());
                sdkClient.setLogReqResp(logReqResp);
            }
            PopControl popControl = gPopControl;
            if (pconf.getPop() != null) {
                popControl = new PopControl(pconf.getPop());
            }
            RequestorAuthenticator authenticator = GatewayHttpFilter.newAuthenticator(pconf.getAuthenticator());
            CaProfilesControl caProfilesControl = new CaProfilesControl(pconf.getCaProfiles());
            RestResponder responder = new RestResponder(sdkClient, this.securities.getSecurityFactory(), authenticator, popControl, caProfilesControl, reverseProxyMode);
            this.restServlet = new RestHttpServlet(logReqResp, responder);
            LOG.info("started REST gateway");
        }
        catch (Throwable ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error starting REST gateway");
        }
    }

    private void initScep(boolean gLogReqResp, SdkClient gSdkClient, PopControl gPopControl) {
        try {
            ScepProtocolConf pconf = ScepProtocolConf.readConfFromFile(IoUtil.expandFilepath((String)SCEP_CFG, (boolean)true));
            boolean logReqResp = gLogReqResp;
            if (pconf.getLogReqResp() != null) {
                logReqResp = pconf.getLogReqResp();
            }
            SdkClient sdkClient = gSdkClient;
            if (pconf.getSdkClient() != null) {
                sdkClient = new SdkClient(pconf.getSdkClient());
                sdkClient.setLogReqResp(logReqResp);
            }
            PopControl popControl = gPopControl;
            if (pconf.getPop() != null) {
                popControl = new PopControl(pconf.getPop());
            }
            RequestorAuthenticator authenticator = GatewayHttpFilter.newAuthenticator(pconf.getAuthenticator());
            CaProfilesControl caProfilesControl = new CaProfilesControl(pconf.getCaProfiles());
            CaNameScepSigners signers = new CaNameScepSigners(GatewayHttpFilter.newCaSigners(this.securities, pconf.getSigners()));
            ScepResponder responder = new ScepResponder(pconf.getScep(), sdkClient, this.securities.getSecurityFactory(), signers, authenticator, popControl, caProfilesControl);
            this.scepServlet = new ScepHttpServlet(logReqResp, responder);
            LOG.info("started SCEP gateway");
        }
        catch (Throwable ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error starting SCEP gateway");
        }
    }

    public void destroy() {
        try {
            if (this.securities != null) {
                this.securities.close();
                this.securities = null;
            }
            GatewayUtil.auditLogPciEvent(LOG, "Gateway", true, "SHUTDOWN");
            GatewayUtil.closeAudits(LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws Exception {
        String path = req.getServletPath();
        if (path.startsWith("/acme/")) {
            if (this.acmeServlet != null) {
                req.setAttribute("xipki_path", path.substring(5));
                this.acmeServlet.service(req, resp);
            } else {
                resp.sendError(404);
            }
        } else if (path.startsWith("/cmp/")) {
            if (this.cmpServlet != null) {
                req.setAttribute("xipki_path", path.substring(4));
                this.cmpServlet.service(req, resp);
            } else {
                resp.sendError(403);
            }
        } else if (path.startsWith("/est/")) {
            if (this.estServlet != null) {
                req.setAttribute("xipki_path", path.substring(4));
                this.estServlet.service(req, resp);
            } else {
                resp.sendError(403);
            }
        } else if (path.startsWith("/rest/")) {
            if (this.restServlet != null) {
                req.setAttribute("xipki_path", path.substring(5));
                this.restServlet.service(req, resp);
            } else {
                resp.sendError(403);
            }
        } else if (path.startsWith("/scep/")) {
            if (this.scepServlet != null) {
                req.setAttribute("xipki_path", path.substring(5));
                this.scepServlet.service(req, resp);
            } else {
                resp.sendError(403);
            }
        } else {
            resp.sendError(404);
        }
    }

    private static RequestorAuthenticator newAuthenticator(String authenticatorClazz) throws InvalidConfException {
        if (authenticatorClazz == null) {
            return null;
        }
        try {
            return (RequestorAuthenticator)ReflectiveUtil.newInstance((String)authenticatorClazz);
        }
        catch (ObjectCreationException e) {
            String msg = "could not load RequestorAuthenticator " + authenticatorClazz;
            LOG.error(msg, (Throwable)e);
            throw new InvalidConfException(msg);
        }
    }

    private static CaNameSigners newCaSigners(Securities securities, CaNameSignersConf signersConf) throws InvalidConfException, ObjectCreationException {
        if (signersConf == null) {
            return null;
        }
        ConcurrentContentSigner defaultSigner = GatewayHttpFilter.buildSigner(securities, signersConf.getDefault());
        CaNameSignerConf[] signerConfs = signersConf.getSigners();
        HashMap<String, ConcurrentContentSigner> signerMap = null;
        if (signerConfs != null && signerConfs.length > 0) {
            signerMap = new HashMap<String, ConcurrentContentSigner>();
            for (CaNameSignerConf m : signerConfs) {
                ConcurrentContentSigner signer = GatewayHttpFilter.buildSigner(securities, m.getSigner());
                for (String name : m.getNames()) {
                    signerMap.put(name, signer);
                }
            }
        }
        return new CaNameSigners(defaultSigner, signerMap);
    }

    private static ConcurrentContentSigner buildSigner(Securities securities, SignerConf signerConf) throws InvalidConfException, ObjectCreationException {
        return signerConf == null ? null : securities.getSecurityFactory().createSigner(signerConf.getType(), new org.xipki.security.SignerConf(signerConf.getConf()), X509Util.parseCerts(signerConf.getCerts()).toArray(new X509Cert[0]));
    }

    static {
        LOG.info("XiPKI CA Protocol Gateway version {}", (Object)StringUtil.getBundleVersion(AcmeResponder.class));
    }
}

