/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.xipki.ca.gateway.conf.KeystoreConf;
import org.xipki.ca.gateway.conf.PopControlConf;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.Passwords;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.X509Cert;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class PopControl {
    private final CollectionAlgorithmValidator popAlgoValidator;
    private final List<DHSigStaticKeyCertPair> dhKeyAndCerts = new ArrayList<DHSigStaticKeyCertPair>(1);
    private final X509Cert[] dhCerts;

    public PopControl(PopControlConf conf) throws InvalidConfException {
        char[] password;
        if (conf.getSigAlgos() == null) {
            this.popAlgoValidator = CollectionAlgorithmValidator.INSTANCE;
        } else {
            try {
                this.popAlgoValidator = CollectionAlgorithmValidator.buildAlgorithmValidator(conf.getSigAlgos());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidConfException("invalid signature algorithm", (Throwable)ex);
            }
        }
        KeystoreConf dh = conf.getDh();
        if (dh == null) {
            this.dhCerts = null;
            return;
        }
        String type = dh.getType();
        String passwordStr = dh.getPassword();
        String keystoreStr = dh.getKeystore();
        if (StringUtil.isBlank((String)type) && StringUtil.isBlank((String)passwordStr) && StringUtil.isBlank((String)keystoreStr)) {
            this.dhCerts = null;
            return;
        }
        if (StringUtil.isBlank((String)type)) {
            throw new InvalidConfException("type is not defined in conf");
        }
        if (StringUtil.isBlank((String)keystoreStr)) {
            throw new InvalidConfException("keystore is not defined in conf");
        }
        if (StringUtil.isBlank((String)passwordStr)) {
            throw new InvalidConfException("password is not defined in conf");
        }
        try {
            password = Passwords.resolvePassword((String)passwordStr);
        }
        catch (PasswordResolverException ex) {
            throw new InvalidConfException("error resolving password");
        }
        try (InputStream is = this.getKeyStoreInputStream(keystoreStr);){
            KeyStore ks = KeyUtil.getInKeyStore((String)type);
            ks.load(is, password);
            Enumeration<String> aliases = ks.aliases();
            LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
            while (aliases.hasMoreElements()) {
                PrivateKey key;
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || !((key = (PrivateKey)ks.getKey(alias, password)) instanceof XDHKey)) continue;
                X509Cert cert = new X509Cert((X509Certificate)ks.getCertificate(alias));
                this.dhKeyAndCerts.add(new DHSigStaticKeyCertPair(key, cert));
                certs.add(cert);
            }
            this.dhCerts = certs.toArray(new X509Cert[0]);
        }
        catch (IOException | ClassCastException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new InvalidConfException("invalid dhStatic pop configuration", (Throwable)ex);
        }
    }

    private InputStream getKeyStoreInputStream(String keystoreStr) throws InvalidConfException {
        if (keystoreStr.startsWith("base64:")) {
            byte[] bytes = Base64.decode((String)keystoreStr.substring("base64:".length()));
            return new ByteArrayInputStream(bytes);
        }
        try {
            return new FileInputStream(IoUtil.expandFilepath((String)keystoreStr, (boolean)true));
        }
        catch (FileNotFoundException e) {
            throw new InvalidConfException(e.getMessage(), (Throwable)e);
        }
    }

    public X509Cert[] getDhCertificates() {
        return this.dhCerts == null || this.dhCerts.length == 0 ? null : Arrays.copyOf(this.dhCerts, this.dhCerts.length);
    }

    public DHSigStaticKeyCertPair getDhKeyCertPair(X500Name issuer, BigInteger serial, String keyAlgorithm) {
        if (this.dhKeyAndCerts.isEmpty()) {
            return null;
        }
        for (DHSigStaticKeyCertPair m : this.dhKeyAndCerts) {
            if (!m.getIssuer().equals((Object)issuer) || !m.getSerialNumber().equals(serial) || !m.getPrivateKey().getAlgorithm().equalsIgnoreCase(keyAlgorithm)) continue;
            return m;
        }
        return null;
    }

    public AlgorithmValidator getPopAlgoValidator() {
        return this.popAlgoValidator;
    }
}

