/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.xipki.ca.gateway.conf.ProtocolConf;
import org.xipki.util.Args;
import org.xipki.util.JSON;
import org.xipki.util.exception.InvalidConfException;

public class AcmeProtocolConf
extends ProtocolConf {
    private Acme acme;

    public static AcmeProtocolConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        AcmeProtocolConf conf = (AcmeProtocolConf)((Object)JSON.parseConf((File)new File(fileName), AcmeProtocolConf.class));
        conf.validate();
        return conf;
    }

    public Acme getAcme() {
        return this.acme;
    }

    public void setAcme(Acme acme) {
        this.acme = acme;
    }

    public void validate() throws InvalidConfException {
        if (this.acme == null) {
            throw new InvalidConfException("acme must be present.");
        }
        this.acme.validate();
    }

    public static class CleanupOrderConf {
        private int expiredCertDays;
        private int expiredOrderDays;

        public int getExpiredCertDays() {
            return this.expiredCertDays;
        }

        public void setExpiredCertDays(int expiredCertDays) {
            this.expiredCertDays = expiredCertDays;
        }

        public int getExpiredOrderDays() {
            return this.expiredOrderDays;
        }

        public void setExpiredOrderDays(int expiredOrderDays) {
            this.expiredOrderDays = expiredOrderDays;
        }
    }

    public static class Acme {
        private int cacheSize = 1000;
        private int nonceNumBytes = 16;
        private int tokenNumBytes = 16;
        private int syncDbSeconds = 60;
        private String dbConf;
        private String contactVerifier;
        private String baseUrl;
        private String termsOfService;
        private String website;
        private List<String> caaIdentities;
        private CleanupOrderConf cleanupOrder;
        private List<CaProfile> caProfiles;
        private List<String> challengeTypes;

        public String getBaseUrl() {
            if (this.baseUrl != null && !this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            return this.baseUrl;
        }

        public int getSyncDbSeconds() {
            return this.syncDbSeconds;
        }

        public void setSyncDbSeconds(int syncDbSeconds) {
            this.syncDbSeconds = syncDbSeconds;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public String getDbConf() {
            return this.dbConf;
        }

        public void setDbConf(String dbConf) {
            this.dbConf = dbConf;
        }

        public List<CaProfile> getCaProfiles() {
            return this.caProfiles;
        }

        public void setCaProfiles(List<CaProfile> caProfiles) {
            this.caProfiles = caProfiles;
        }

        public String getContactVerifier() {
            return this.contactVerifier;
        }

        public void setContactVerifier(String contactVerifier) {
            this.contactVerifier = contactVerifier;
        }

        public int getNonceNumBytes() {
            return this.nonceNumBytes;
        }

        public int getTokenNumBytes() {
            return this.tokenNumBytes;
        }

        public CleanupOrderConf getCleanupOrder() {
            return this.cleanupOrder;
        }

        public void setCleanupOrder(CleanupOrderConf cleanupOrder) {
            this.cleanupOrder = cleanupOrder;
        }

        public void setTokenNumBytes(int tokenNumBytes) {
            this.tokenNumBytes = tokenNumBytes;
        }

        public void setNonceNumBytes(int nonceNumBytes) {
            this.nonceNumBytes = nonceNumBytes;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getTermsOfService() {
            return this.termsOfService;
        }

        public void setTermsOfService(String termsOfService) {
            this.termsOfService = termsOfService;
        }

        public String getWebsite() {
            return this.website;
        }

        public void setWebsite(String website) {
            this.website = website;
        }

        public List<String> getCaaIdentities() {
            return this.caaIdentities;
        }

        public void setCaaIdentities(List<String> caaIdentities) {
            this.caaIdentities = caaIdentities;
        }

        public List<String> getChallengeTypes() {
            return this.challengeTypes;
        }

        public void setChallengeTypes(List<String> challengeTypes) {
            this.challengeTypes = challengeTypes;
        }

        private void validate() throws InvalidConfException {
            if (this.syncDbSeconds < 1) {
                throw new InvalidConfException("syncDbSeconds must be not less than 1");
            }
            if (this.nonceNumBytes < 12) {
                throw new InvalidConfException("nonceNumBytes must be not less than 12");
            }
            if (this.tokenNumBytes < 12) {
                throw new InvalidConfException("tokenNumBytes must be not less than 12");
            }
            if (this.baseUrl == null || this.baseUrl.isEmpty()) {
                throw new InvalidConfException("baseUrl must be present and not blank.");
            }
            if (this.caProfiles == null || this.caProfiles.isEmpty()) {
                throw new InvalidConfException("profiles must be present and not empty.");
            }
            for (CaProfile entry : this.caProfiles) {
                entry.validate();
            }
        }
    }

    public static class CaProfile {
        private List<String> keyTypes;
        private String ca;
        private String tlsProfile;

        public List<String> getKeyTypes() {
            return this.keyTypes;
        }

        public void setKeyTypes(List<String> keyTypes) {
            this.keyTypes = keyTypes;
        }

        public String getCa() {
            return this.ca;
        }

        public void setCa(String ca) {
            this.ca = ca;
        }

        public String getTlsProfile() {
            return this.tlsProfile;
        }

        public void setTlsProfile(String tlsProfile) {
            this.tlsProfile = tlsProfile;
        }

        public void validate() throws InvalidConfException {
            if (this.ca == null || this.ca.isEmpty()) {
                throw new InvalidConfException("ca must be present and not blank.");
            }
            if (this.tlsProfile == null || this.tlsProfile.isEmpty()) {
                throw new InvalidConfException("tlsProfile must be present and not blank.");
            }
        }
    }
}

