/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.acme.AcmeAccount;
import org.xipki.ca.gateway.acme.AcmeAuthz;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeChallenge2;
import org.xipki.ca.gateway.acme.AcmeDataSource;
import org.xipki.ca.gateway.acme.AcmeOrder;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.AuthzId;
import org.xipki.ca.gateway.acme.ChallId;
import org.xipki.ca.gateway.acme.type.AuthzStatus;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.ca.gateway.acme.type.OrderStatus;
import org.xipki.datasource.DataAccessException;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;

public class AcmeRepo
implements AcmeDataSource.IdChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeRepo.class);
    private final AccountLruCache accountCache;
    private final OrderLruCache orderCache;
    private final AcmeDataSource dataSource;
    private final int syncDbSeconds;
    private boolean stopMe;

    public AcmeRepo(AcmeDataSource dataSource, int cacheSize, int syncDbSeconds) {
        this.accountCache = new AccountLruCache(Args.min((int)cacheSize, (String)"cacheSize", (int)1));
        this.orderCache = new OrderLruCache(Args.min((int)cacheSize, (String)"cacheSize", (int)1));
        this.syncDbSeconds = Args.min((int)syncDbSeconds, (String)"syncDbSeconds", (int)1);
        this.dataSource = (AcmeDataSource)Args.notNull((Object)dataSource, (String)"dataSource");
        this.dataSource.setIdChecker(this);
    }

    @Override
    public boolean accountIdExists(long id) {
        return this.accountCache.containsKey(id);
    }

    @Override
    public boolean orderIdExists(long id) {
        return this.orderCache.containsKey(id);
    }

    IdsForOrder newIdsForOrder(int numAuthzs, int numChalls) throws DataAccessException {
        return new IdsForOrder(this.dataSource.nextOrderId(), this.dataSource.nextAuthzIds(numAuthzs), this.dataSource.nextChallIds(numChalls));
    }

    public void start() {
        Thread t = new Thread(new DataToDbWriter());
        t.setName("dataToDbWriter");
        t.setDaemon(true);
        t.start();
    }

    public void addAccount(AcmeAccount account) {
        this.accountCache.put(account.getId(), account);
        LOG.info("added account {}", (Object)account.idText());
    }

    public byte[] getCsr(long orderId) throws AcmeSystemException {
        AcmeOrder order = (AcmeOrder)this.orderCache.get(orderId);
        if (order != null && order.getCsr() != null) {
            return order.getCsr();
        }
        return this.dataSource.getCsr(orderId);
    }

    public AcmeAccount getAccount(long accountId) throws AcmeSystemException {
        AcmeAccount account = (AcmeAccount)this.accountCache.get(accountId);
        if (account == null && (account = this.dataSource.getAccount(accountId)) != null) {
            this.accountCache.put(account.getId(), account);
        }
        return account;
    }

    public AcmeAccount getAccountForJwk(Map<String, String> jwk) throws AcmeSystemException {
        for (Map.Entry entry : this.accountCache.snapshot().entrySet()) {
            if (!((AcmeAccount)entry.getValue()).hasJwk(jwk)) continue;
            return (AcmeAccount)entry.getValue();
        }
        AcmeAccount account = this.dataSource.getAccountForJwk(jwk);
        if (account != null) {
            this.accountCache.put(account.getId(), account);
        }
        return account;
    }

    public void addOrder(AcmeOrder order) {
        this.orderCache.put(order.getId(), order);
        LOG.info("added order {}", (Object)order.idText());
    }

    public AcmeOrder getOrder(long orderId) throws AcmeSystemException {
        AcmeOrder order = (AcmeOrder)this.orderCache.get(orderId);
        if (order == null && (order = this.dataSource.getOrder(orderId)) != null) {
            this.orderCache.put(order.getId(), order);
        }
        return order;
    }

    public AcmeOrder getOrderForCert(byte[] cert) throws AcmeSystemException {
        String sha256 = Base64Url.encodeToStringNoPadding((byte[])HashAlgo.SHA256.hash((byte[][])new byte[][]{cert}));
        AcmeOrder order = null;
        for (Map.Entry entry : this.orderCache.snapshot().entrySet()) {
            if (!sha256.equals(((AcmeOrder)entry.getValue()).getCertSha256())) continue;
            order = (AcmeOrder)entry.getValue();
            break;
        }
        if (order == null && (order = this.dataSource.getOrderForCertSha256(sha256)) != null) {
            this.orderCache.put(order.getId(), order);
        }
        return order;
    }

    public AcmeChallenge2 getChallenge(ChallId challId) throws AcmeSystemException {
        AcmeOrder order = this.getOrder(challId.getOrderId());
        if (order == null) {
            return null;
        }
        AcmeAuthz authz = order.getAuthz(challId.getAuthzId());
        if (authz == null) {
            return null;
        }
        for (AcmeChallenge chall : authz.getChallenges()) {
            if (chall.getSubId() != challId.getSubId()) continue;
            return new AcmeChallenge2(chall, authz.getIdentifier());
        }
        return null;
    }

    public AcmeAuthz getAuthz(AuthzId authzId) throws AcmeSystemException {
        AcmeOrder order = this.getOrder(authzId.getOrderId());
        if (order == null) {
            return null;
        }
        return order.getAuthz(authzId.getSubId());
    }

    public List<Long> getOrderIds(long accountId) throws AcmeSystemException {
        LinkedList<Long> orderIds = new LinkedList<Long>();
        for (Map.Entry entry : this.orderCache.snapshot().entrySet()) {
            if (((AcmeOrder)entry.getValue()).getAccountId() != accountId) continue;
            orderIds.add((Long)entry.getKey());
        }
        List<Long> dbOrderIds = this.dataSource.getOrderIds(accountId);
        orderIds.addAll(dbOrderIds);
        return orderIds;
    }

    public Iterator<ChallId> getChallengesToValidate() throws AcmeSystemException {
        List<ChallId> dbIds = this.dataSource.getChallengesToValidate();
        LinkedList<ChallId> ids = new LinkedList<ChallId>(dbIds);
        for (Long id : this.orderCache.keySnapshot()) {
            AcmeOrder order = (AcmeOrder)this.orderCache.get(id);
            block1: for (AcmeAuthz authz : order.getAuthzs()) {
                for (AcmeChallenge challenge : authz.getChallenges()) {
                    boolean addMe;
                    ChallId challId = new ChallId(order.getId(), authz.getSubId(), challenge.getSubId());
                    boolean bl = addMe = challenge.getStatus() == ChallengeStatus.processing && authz.getStatus() == AuthzStatus.pending && order.getStatus() == OrderStatus.pending;
                    if (addMe) {
                        ids.add(challId);
                        continue block1;
                    }
                    ids.remove(challId);
                }
            }
        }
        return new ListIterator<ChallId>(ids);
    }

    public Iterator<Long> getOrdersToEnroll() throws AcmeSystemException {
        List<Long> dbIds = this.dataSource.getOrdersToEnroll();
        LinkedList<Long> ids = new LinkedList<Long>(dbIds);
        for (Long id : this.orderCache.keySnapshot()) {
            AcmeOrder order = (AcmeOrder)this.orderCache.get(id);
            order.updateStatus();
            if (order.getStatus() == OrderStatus.processing) {
                if (ids.contains(id)) continue;
                ids.add(id);
                continue;
            }
            ids.remove(id);
        }
        return new ListIterator<Long>(ids);
    }

    public int cleanOrders(Instant certNotAfter, Instant notFinishedOrderExpires) throws AcmeSystemException {
        return this.dataSource.cleanOrders(certNotAfter, notFinishedOrderExpires);
    }

    public AcmeOrder newAcmeOrder(long accountId, long orderId) {
        return new AcmeOrder(accountId, orderId, this.dataSource);
    }

    public AcmeAccount newAcmeAccount() throws DataAccessException {
        return new AcmeAccount(this.dataSource.nextAccountId(), this.dataSource);
    }

    public void close() {
        this.stopMe = true;
        try {
            this.writeToDb();
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOG, (Throwable)e, (String)"error closing AcmeRepo.");
        }
    }

    private synchronized void writeToDb() throws AcmeSystemException {
        for (Map.Entry account : this.accountCache.snapshot().entrySet()) {
            ((AcmeAccount)account.getValue()).flush();
        }
        for (Map.Entry order : this.orderCache.snapshot().entrySet()) {
            ((AcmeOrder)order.getValue()).flush();
        }
    }

    public synchronized void flushOrderIfNotCached(AcmeOrder order) throws AcmeSystemException {
        AcmeOrder cachedOrder = (AcmeOrder)this.orderCache.get(order.getId());
        if (cachedOrder != order) {
            order.flush();
        }
    }

    static class IdsForOrder {
        private final long orderId;
        private final int[] authzSubIds;
        private final int[] challSubIds;

        public IdsForOrder(long orderId, int[] authzSubIds, int[] challSubIds) {
            this.orderId = orderId;
            this.authzSubIds = authzSubIds;
            this.challSubIds = challSubIds;
        }

        public long getOrderId() {
            return this.orderId;
        }

        public int[] getAuthzSubIds() {
            return this.authzSubIds;
        }

        public int[] getChallSubIds() {
            return this.challSubIds;
        }
    }

    private class DataToDbWriter
    implements Runnable {
        private DataToDbWriter() {
        }

        @Override
        public void run() {
            while (!AcmeRepo.this.stopMe) {
                try {
                    try {
                        Thread.sleep((long)AcmeRepo.this.syncDbSeconds * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AcmeRepo.this.writeToDb();
                }
                catch (Throwable t) {
                    LogUtil.error((Logger)LOG, (Throwable)t, (String)"unexpected error");
                }
            }
        }
    }

    private static class OrderLruCache
    extends LruCache<Long, AcmeOrder> {
        public OrderLruCache(int maxSize) {
            super(maxSize);
        }

        protected void entryRemoved(boolean evicted, Long key, AcmeOrder oldValue, AcmeOrder newValue) {
            super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
            if (oldValue != null) {
                try {
                    oldValue.flush();
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)("error flushing AcmeOrder " + oldValue.getId()));
                }
            }
        }
    }

    private static class AccountLruCache
    extends LruCache<Long, AcmeAccount> {
        public AccountLruCache(int maxSize) {
            super(maxSize);
        }

        protected void entryRemoved(boolean evicted, Long key, AcmeAccount oldValue, AcmeAccount newValue) {
            super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
            if (oldValue != null) {
                try {
                    oldValue.flush();
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)("error flushing AcmeAccount " + oldValue.getId()));
                }
            }
        }
    }

    static class ListIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private final AtomicInteger index = new AtomicInteger(0);

        ListIterator(List<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.index.get() < this.list.size();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.list.get(this.index.getAndIncrement());
            }
            return null;
        }
    }
}

