/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.io.IOException;
import java.util.Iterator;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.acme.AcmeOrder;
import org.xipki.ca.gateway.acme.AcmeRepo;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.AcmeUtils;
import org.xipki.ca.gateway.acme.type.CertReqMeta;
import org.xipki.ca.gateway.acme.type.OrderStatus;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.pki.OperationException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class CertEnroller
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CertEnroller.class);
    private final AcmeRepo repo;
    private final SdkClient sdk;
    private boolean stopMe;

    public CertEnroller(AcmeRepo repo, SdkClient sdk) {
        this.repo = (AcmeRepo)Args.notNull((Object)repo, (String)"repo");
        this.sdk = (SdkClient)Args.notNull((Object)sdk, (String)"sdk");
    }

    @Override
    public void run() {
        while (!this.stopMe) {
            try {
                this.singleRun();
            }
            catch (Throwable t) {
                LogUtil.error((Logger)LOG, (Throwable)t, (String)"expected error");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void singleRun() throws AcmeSystemException {
        Iterator<Long> orderIds = this.repo.getOrdersToEnroll();
        while (orderIds.hasNext()) {
            Long orderId = orderIds.next();
            if (orderId == null) continue;
            String orderIdStr = AcmeUtils.toBase64(orderId) + " (" + orderId + ")";
            LOG.info("try to enroll certificate for order {}", (Object)orderIdStr);
            AcmeOrder order = this.repo.getOrder(orderId);
            if (order == null) {
                LOG.error("found no order for id {}", (Object)orderIdStr);
                continue;
            }
            byte[] csr = order.getCsr();
            if (csr == null) {
                csr = this.repo.getCsr(orderId);
            }
            if (csr == null) {
                LOG.error("found not CSR for order {}", (Object)orderIdStr);
                continue;
            }
            EnrollCertsRequest.Entry entry = new EnrollCertsRequest.Entry();
            CertReqMeta certReqMeta = order.getCertReqMeta();
            entry.setNotBefore(certReqMeta.getNotBefore());
            entry.setNotAfter(certReqMeta.getNotAfter());
            entry.setCertprofile(certReqMeta.getCertProfile());
            if (certReqMeta.getSubject() == null) {
                entry.setP10req(csr);
            } else {
                entry.setSubject(new X500NameType(certReqMeta.getSubject()));
                try {
                    CertificationRequest p10Req = GatewayUtil.parseCsrInRequest(csr);
                    Extensions extensions = X509Util.getExtensions((CertificationRequestInfo)p10Req.getCertificationRequestInfo());
                    if (extensions != null) {
                        entry.setExtensions(extensions.getEncoded());
                    }
                    entry.setSubjectPublicKey(p10Req.getCertificationRequestInfo().getSubjectPublicKeyInfo().getEncoded());
                }
                catch (IOException | OperationException e) {
                    throw new AcmeSystemException(e);
                }
            }
            EnrollCertsRequest sdkReq = new EnrollCertsRequest();
            sdkReq.setCaCertMode(CertsMode.NONE);
            sdkReq.setEntries(new EnrollCertsRequest.Entry[]{entry});
            LOG.info("start enrolling certificate for order {}", (Object)orderIdStr);
            try {
                boolean valid;
                EnrollOrPollCertsResponse sdkResp = this.sdk.enrollCerts(certReqMeta.getCa(), sdkReq);
                EnrollOrPollCertsResponse.Entry sdkRespEntry = sdkResp.getEntries()[0];
                byte[] certBytes = sdkRespEntry.getCert();
                boolean bl = valid = certBytes != null;
                if (valid) {
                    try {
                        Certificate.getInstance((Object)certBytes);
                    }
                    catch (Exception ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("Error parsing enrolled certificate for order " + orderIdStr));
                        valid = false;
                    }
                } else {
                    LOG.error("CA returned error for the order {}: {}", (Object)orderIdStr, (Object)sdkRespEntry.getError());
                }
                if (valid) {
                    LOG.info("enrolled certificate for order {}", (Object)orderIdStr);
                    order.setCert(certBytes);
                    order.setStatus(OrderStatus.valid);
                } else {
                    order.setStatus(OrderStatus.invalid);
                }
                this.repo.flushOrderIfNotCached(order);
            }
            catch (Throwable t) {
                LogUtil.error((Logger)LOG, (Throwable)t);
                order.setStatus(OrderStatus.invalid);
            }
        }
    }

    public void close() {
        this.stopMe = true;
    }
}

