/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp;

import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xipki.ca.gateway.cmp.CmpControlConf;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.util.CollectionUtil;
import org.xipki.util.exception.InvalidConfException;

public class CmpControl {
    private static final Duration DFLT_MESSAGE_TIME_BIAS = Duration.ofSeconds(300L);
    private static final Duration DFLT_CONFIRM_WAIT_TIME = Duration.ofSeconds(300L);
    private static final int DFLT_PBM_ITERATIONCOUNT = 10240;
    private final boolean confirmCert;
    private final boolean sendCaCert;
    private final boolean sendCertChain;
    private final boolean messageTimeRequired;
    private final boolean sendResponderCert;
    private final Duration messageTimeBias;
    private final Duration confirmWaitTime;
    private HashAlgo responsePbmOwf;
    private final List<HashAlgo> requestPbmOwfs;
    private SignAlgo responsePbmMac;
    private final List<SignAlgo> requestPbmMacs;
    private final int responsePbmIterationCount;
    private final CollectionAlgorithmValidator sigAlgoValidator;

    public CmpControl(CmpControlConf conf) throws InvalidConfException {
        String algo;
        int i;
        this.confirmCert = CmpControl.getBoolean(conf.getConfirmCert(), false);
        this.sendCaCert = CmpControl.getBoolean(conf.getSendCaCert(), false);
        this.sendCertChain = CmpControl.getBoolean(conf.getSendCertChain(), false);
        this.sendResponderCert = CmpControl.getBoolean(conf.getSendResponderCert(), true);
        this.messageTimeRequired = CmpControl.getBoolean(conf.getMessageTimeRequired(), true);
        this.messageTimeBias = conf.getMessageTimeBias() == null ? DFLT_MESSAGE_TIME_BIAS : Duration.ofSeconds(Math.abs(conf.getMessageTimeBias()));
        this.confirmWaitTime = conf.getConfirmWaitTime() == null ? DFLT_CONFIRM_WAIT_TIME : Duration.ofSeconds(Math.abs(conf.getConfirmWaitTime()));
        List<String> requestSigAlgos = conf.getRequestSigAlgos();
        if (CollectionUtil.isEmpty(requestSigAlgos)) {
            throw new InvalidConfException("requestSigAlgos is not set");
        }
        try {
            this.sigAlgoValidator = CollectionAlgorithmValidator.buildAlgorithmValidator(requestSigAlgos);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException("invalid signature algorithm", (Throwable)ex);
        }
        try {
            if (conf.getResponsePbmMac() != null) {
                this.responsePbmMac = SignAlgo.getInstance((String)conf.getResponsePbmMac());
            }
            if (conf.getResponsePbmOwf() != null) {
                this.responsePbmOwf = HashAlgo.getInstance((String)conf.getResponsePbmOwf());
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
        }
        List<String> pbmOwfs = conf.getRequestPbmOwfs();
        List<String> pbmMacs = conf.getRequestPbmMacs();
        Integer pbmIterationCount = conf.getResponsePbmIterationCount();
        if (pbmIterationCount == null) {
            pbmIterationCount = 10240;
        }
        if (pbmIterationCount <= 0) {
            throw new InvalidConfException("invalid pbmIterationCount " + pbmIterationCount);
        }
        this.responsePbmIterationCount = pbmIterationCount;
        if (CollectionUtil.isEmpty(pbmOwfs)) {
            pbmOwfs = Collections.singletonList("SHA256");
        }
        if (CollectionUtil.isEmpty(pbmMacs)) {
            pbmMacs = Collections.singletonList("HMACSHA256");
        }
        this.requestPbmOwfs = new ArrayList<HashAlgo>(pbmOwfs.size());
        for (i = 0; i < pbmOwfs.size(); ++i) {
            HashAlgo ha;
            algo = pbmOwfs.get(i);
            try {
                ha = HashAlgo.getInstance((String)algo);
            }
            catch (Exception ex) {
                throw new InvalidConfException("invalid pbmPwf " + algo, (Throwable)ex);
            }
            this.requestPbmOwfs.add(ha);
            if (i != 0 || this.responsePbmOwf != null) continue;
            this.responsePbmOwf = ha;
        }
        this.requestPbmMacs = new ArrayList<SignAlgo>(pbmMacs.size());
        for (i = 0; i < pbmMacs.size(); ++i) {
            SignAlgo signAlgo;
            algo = pbmMacs.get(i);
            try {
                signAlgo = SignAlgo.getInstance((String)algo);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidConfException("invalid pbmMac " + algo, (Throwable)ex);
            }
            this.requestPbmMacs.add(signAlgo);
            if (i != 0 || this.responsePbmMac != null) continue;
            this.responsePbmMac = signAlgo;
        }
    }

    public CertsMode getCaCertsMode() {
        if (!this.sendCaCert) {
            return CertsMode.NONE;
        }
        return this.sendCertChain ? CertsMode.CHAIN : CertsMode.CERT;
    }

    public boolean isMessageTimeRequired() {
        return this.messageTimeRequired;
    }

    public boolean isConfirmCert() {
        return this.confirmCert;
    }

    public Duration getMessageTimeBias() {
        return this.messageTimeBias;
    }

    public Duration getConfirmWaitTime() {
        return this.confirmWaitTime;
    }

    public boolean isSendResponderCert() {
        return this.sendResponderCert;
    }

    public AlgorithmValidator getSigAlgoValidator() {
        return this.sigAlgoValidator;
    }

    public HashAlgo getResponsePbmOwf() {
        return this.responsePbmOwf;
    }

    public SignAlgo getResponsePbmMac() {
        return this.responsePbmMac;
    }

    public int getResponsePbmIterationCount() {
        return this.responsePbmIterationCount;
    }

    public boolean isRequestPbmOwfPermitted(HashAlgo pbmOwf) {
        return this.requestPbmOwfs.contains(pbmOwf);
    }

    public boolean isRequestPbmMacPermitted(SignAlgo pbmMac) {
        return this.requestPbmMacs.contains(pbmMac);
    }

    private static boolean getBoolean(Boolean b, boolean defaultValue) {
        return b == null ? defaultValue : b;
    }
}

