/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertStatus;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContentBuilder;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.Controls;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.CaNameSigners;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.api.Requestor;
import org.xipki.ca.gateway.api.RequestorAuthenticator;
import org.xipki.ca.gateway.cmp.BaseCmpResponder;
import org.xipki.ca.gateway.cmp.CmpControl;
import org.xipki.ca.sdk.ConfirmCertsRequest;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.OldCertInfo;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.RevokeCertsResponse;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.SingleCertSerialEntry;
import org.xipki.ca.sdk.UnsuspendOrRemoveCertsRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.cmp.CmpUtf8Pairs;
import org.xipki.cmp.CmpUtil;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.X509Util;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InsufficientPermissionException;

public class CmpResponder
extends BaseCmpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCmpResponder.class);

    public CmpResponder(CmpControl cmpControl, SdkClient sdk, SecurityFactory securityFactory, CaNameSigners signers, RequestorAuthenticator authenticator, PopControl popControl) throws NoSuchAlgorithmException {
        super(cmpControl, sdk, securityFactory, signers, authenticator, popControl);
    }

    private CertRepMessage processCertReqMessages(String caName, String dfltCertprofileName, boolean groupEnroll, PKIMessage request, Requestor requestor, ASN1OctetString tid, CertReqMessages cr, AuditEvent event) throws InsufficientPermissionException, IOException, SdkErrorResponseException {
        int numCertprofileNames;
        CertReqMsg[] certReqMsgs = cr.toCertReqMsgArray();
        int n = certReqMsgs.length;
        boolean reenroll = request.getBody().getType() == 7;
        String[] certprofileNames = CmpUtil.extractCertProfile((InfoTypeAndValue[])request.getHeader().getGeneralInfo());
        int n2 = numCertprofileNames = certprofileNames == null ? 0 : certprofileNames.length;
        if (numCertprofileNames == 0) {
            certprofileNames = new String[n];
        } else if (numCertprofileNames < n) {
            certprofileNames = Arrays.copyOf(certprofileNames, n);
        }
        if (certprofileNames.length == n && StringUtil.isNotBlank((String)dfltCertprofileName)) {
            for (int i = 0; i < n; ++i) {
                if (!StringUtil.isBlank((String)certprofileNames[i])) continue;
                certprofileNames[i] = dfltCertprofileName;
            }
        }
        boolean withNullProfileNames = false;
        for (int i = 0; i < n; ++i) {
            if (!StringUtil.isBlank((String)certprofileNames[i])) continue;
            withNullProfileNames = true;
            break;
        }
        if (numCertprofileNames > n || !reenroll && withNullProfileNames) {
            CertResponse[] certResps = new CertResponse[n];
            for (int i = 0; i < n; ++i) {
                certResps[i] = new CertResponse(certReqMsgs[i].getCertReq().getCertReqId(), CmpResponder.generateRejectionStatus(0x100000, "number of specified cert profile names is not correct"));
            }
            event.setStatus(AuditStatus.FAILED);
            return new CertRepMessage(null, certResps);
        }
        ArrayList<EnrollCertsRequest.Entry> certTemplateDatas = new ArrayList<EnrollCertsRequest.Entry>(n);
        HashMap<Integer, CertResponse> failureResps = new HashMap<Integer, CertResponse>();
        for (int i = 0; i < n; ++i) {
            String certprofileName;
            CertReqMsg reqMsg = certReqMsgs[i];
            ASN1Integer certReqId = reqMsg.getCertReq().getCertReqId();
            CertificateRequestMessage req = new CertificateRequestMessage(reqMsg);
            CertTemplate certTemp = req.getCertTemplate();
            SubjectPublicKeyInfo publicKey = certTemp.getPublicKey();
            X500Name subject = certTemp.getSubject();
            OptionalValidity validity = certTemp.getValidity();
            Instant notBefore = null;
            Instant notAfter = null;
            if (validity != null) {
                if (validity.getNotBefore() != null) {
                    notBefore = Instant.ofEpochMilli(validity.getNotBefore().getDate().getTime());
                }
                if (validity.getNotAfter() != null) {
                    notAfter = Instant.ofEpochMilli(validity.getNotAfter().getDate().getTime());
                }
            }
            OldCertInfo oldCertInfo = null;
            if (reenroll) {
                Controls controls = reqMsg.getCertReq().getControls();
                AttributeTypeAndValue oldCertIdAtv = null;
                if (controls != null) {
                    ASN1Sequence seq;
                    try {
                        seq = ASN1Sequence.getInstance((Object)controls.getEncoded());
                    }
                    catch (IOException ex) {
                        CmpResponder.addErrCertResp(failureResps, i, certReqId, 0x40000000, "could not parse the controls");
                        continue;
                    }
                    int seqSize = seq.size();
                    for (int j = 0; j < seqSize; ++j) {
                        AttributeTypeAndValue atv = AttributeTypeAndValue.getInstance((Object)seq.getObjectAt(j));
                        if (!atv.getType().equals((ASN1Primitive)CMPObjectIdentifiers.regCtrl_oldCertID)) continue;
                        oldCertIdAtv = atv;
                        break;
                    }
                }
                if (oldCertIdAtv == null) {
                    CmpResponder.addErrCertResp(failureResps, i, certReqId, 0x100000, "no getCtrl oldCertID is specified");
                    continue;
                }
                CertId oldCertId = CertId.getInstance((Object)oldCertIdAtv.getValue());
                if (4 != oldCertId.getIssuer().getTagNo()) {
                    CmpResponder.addErrCertResp(failureResps, i, certReqId, 8, "invalid regCtrl oldCertID");
                    continue;
                }
                oldCertInfo = new OldCertInfo(false, new OldCertInfo.ByIssuerAndSerial(new X500NameType(oldCertId.getIssuer().getName().toASN1Primitive().getEncoded()), oldCertId.getSerialNumber().getValue()));
            }
            if (StringUtil.isNotBlank((String)(certprofileName = certprofileNames[i])) && !requestor.isCertprofilePermitted(caName, certprofileName)) {
                CmpResponder.addErrCertResp(failureResps, i, certReqId, 65536, "certprofile " + certprofileName + " is not allowed");
                continue;
            }
            if (publicKey != null) {
                if (!req.hasProofOfPossession()) {
                    CmpResponder.addErrCertResp(failureResps, i, certReqId, 16384, "no POP");
                    continue;
                }
                if (!this.verifyPop(req, publicKey)) {
                    LOG.warn("could not validate POP for request {}", (Object)certReqId.getValue());
                    CmpResponder.addErrCertResp(failureResps, i, certReqId, 16384, "invalid POP");
                    continue;
                }
            } else {
                this.checkPermission(requestor, Requestor.Permission.GEN_KEYPAIR);
            }
            EnrollCertsRequest.Entry template = new EnrollCertsRequest.Entry();
            template.setNotBefore(notBefore);
            template.setNotAfter(notAfter);
            template.setCertReqId(certReqId.getValue());
            if (StringUtil.isNotBlank((String)certprofileName)) {
                template.setCertprofile(certprofileName);
            }
            try {
                template.extensions(certTemp.getExtensions());
            }
            catch (IOException e) {
                LogUtil.warn((Logger)LOG, (Throwable)e, (String)("could not encode extensions " + certReqId.getValue()));
                CmpResponder.addErrCertResp(failureResps, i, certReqId, 0x100000, "invalid extensions");
                continue;
            }
            if (publicKey != null) {
                try {
                    template.setSubjectPublicKey(publicKey.getEncoded());
                }
                catch (IOException e) {
                    LogUtil.warn((Logger)LOG, (Throwable)e, (String)("could not encode extensions " + certReqId.getValue()));
                    CmpResponder.addErrCertResp(failureResps, i, certReqId, 0x100000, "invalid public key");
                    continue;
                }
            }
            if (subject != null) {
                template.setSubject(new X500NameType(subject));
            }
            if (oldCertInfo != null) {
                template.setOldCertInfo(oldCertInfo);
            }
            certTemplateDatas.add(template);
        }
        if (certTemplateDatas.size() != n) {
            event.setStatus(AuditStatus.FAILED);
            CertResponse[] certResps = new CertResponse[n];
            for (int i = 0; i < n; ++i) {
                certResps[i] = (CertResponse)failureResps.get(i);
                if (certResps[i] != null) continue;
                certResps[i] = new CertResponse(certReqMsgs[i].getCertReq().getCertReqId(), CmpResponder.generateRejectionStatus(32, "failure in the parallel entries in the same request"));
            }
            return new CertRepMessage(null, certResps);
        }
        boolean cross = request.getBody().getType() == 13;
        return this.enrollCerts(caName, groupEnroll, reenroll, cross, requestor, tid, certTemplateDatas.toArray(new EnrollCertsRequest.Entry[0]), event);
    }

    private PKIBody processP10cr(String caName, String dfltCertprofileName, Requestor requestor, ASN1OctetString tid, PKIHeader reqHeader, CertificationRequest p10cr, AuditEvent event) throws SdkErrorResponseException {
        PKIStatusInfo statusObj;
        int status;
        CertRepMessage certResp;
        ASN1Integer certReqId = new ASN1Integer(-1L);
        if (!GatewayUtil.verifyCsr(p10cr, this.securityFactory, this.popControl)) {
            LOG.warn("could not validate POP for the pkcs#10 requst");
            certResp = CmpResponder.buildErrCertResp(certReqId, 16384, "invalid POP");
        } else {
            InfoTypeAndValue[] generalInfo = reqHeader.getGeneralInfo();
            CmpUtf8Pairs keyvalues = CmpUtil.extractUtf8Pairs((InfoTypeAndValue[])generalInfo);
            String certprofileName = null;
            String[] list = CmpUtil.extractCertProfile((InfoTypeAndValue[])generalInfo);
            if (list != null && list.length > 0) {
                certprofileName = list[0];
            }
            Instant notBefore = null;
            Instant notAfter = null;
            if (keyvalues != null) {
                String str = keyvalues.value("notbefore");
                if (str != null) {
                    notBefore = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                }
                if ((str = keyvalues.value("notafter")) != null) {
                    notAfter = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                }
            }
            if (certprofileName == null) {
                certprofileName = dfltCertprofileName;
            }
            if (certprofileName == null) {
                LOG.warn("no certprofile is specified");
                certResp = CmpResponder.buildErrCertResp(certReqId, 0x100000, "badCertTemplate");
            } else if (!requestor.isCertprofilePermitted(caName, certprofileName = certprofileName.toLowerCase())) {
                String msg = "certprofile " + certprofileName + " is not allowed";
                certResp = CmpResponder.buildErrCertResp(certReqId, 65536, msg);
            } else {
                EnrollCertsRequest.Entry certTemplate = new EnrollCertsRequest.Entry();
                certTemplate.setCertprofile(certprofileName);
                certTemplate.setCertReqId(BigInteger.valueOf(-1L));
                certTemplate.setNotBefore(notBefore);
                certTemplate.setNotAfter(notAfter);
                try {
                    certTemplate.setP10req(p10cr.getEncoded());
                }
                catch (IOException e) {
                    LogUtil.error((Logger)LOG, (Throwable)e);
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "invalid PKCS#10 request");
                }
                try {
                    certResp = this.enrollCerts(caName, false, false, false, requestor, tid, new EnrollCertsRequest.Entry[]{certTemplate}, event);
                }
                catch (IOException e) {
                    LogUtil.error((Logger)LOG, (Throwable)e);
                    return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, null);
                }
            }
        }
        if ((event.getStatus() == null || event.getStatus() != AuditStatus.FAILED) && (status = (statusObj = certResp.getResponse()[0].getStatus()).getStatus().intValue()) != 0 && status != 1 && status != 3) {
            event.setStatus(AuditStatus.FAILED);
            PKIFreeText statusStr = statusObj.getStatusString();
            if (statusStr != null) {
                event.addEventData("message", (Object)statusStr.getStringAtUTF8(0).getString());
            }
        }
        return new PKIBody(3, (ASN1Encodable)certResp);
    }

    private CertRepMessage enrollCerts(String caName, boolean groupEnroll, boolean reenroll, boolean cross, Requestor requestor, ASN1OctetString tid, EnrollCertsRequest.Entry[] templates, AuditEvent event) throws IOException, SdkErrorResponseException {
        String hexTid = Hex.encode((byte[])tid.getOctets());
        EnrollCertsRequest sdkReq = new EnrollCertsRequest();
        sdkReq.setExplicitConfirm(Boolean.valueOf(this.cmpControl.isConfirmCert()));
        sdkReq.setGroupEnroll(Boolean.valueOf(groupEnroll));
        sdkReq.setConfirmWaitTimeMs(Integer.valueOf((int)this.cmpControl.getConfirmWaitTime().toMillis()));
        sdkReq.setCaCertMode(this.cmpControl.getCaCertsMode());
        sdkReq.setTransactionId(hexTid);
        sdkReq.setEntries(templates);
        for (EnrollCertsRequest.Entry m : templates) {
            event.addEventData("certprofile", (Object)m.getCertprofile());
            X500Name subject = null;
            if (m.getSubject() != null) {
                subject = m.getSubject().toX500Name();
            } else if (m.getP10req() != null) {
                CertificationRequest csr;
                try {
                    csr = GatewayUtil.parseCsrInRequest(m.getP10req());
                }
                catch (OperationException e) {
                    throw new SdkErrorResponseException(ErrorCode.BAD_REQUEST, "error parsing PKCS#10 request");
                }
                subject = csr.getCertificationRequestInfo().getSubject();
            }
            if (subject == null) continue;
            event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)subject) + "\""));
        }
        EnrollOrPollCertsResponse resp = cross ? this.sdk.enrollCrossCerts(caName, sdkReq) : (reenroll ? this.sdk.reenrollCerts(caName, sdkReq) : this.sdk.enrollCerts(caName, sdkReq));
        EnrollOrPollCertsResponse.Entry[] rentries = resp.getEntries();
        CertResponse[] certResponses = new CertResponse[rentries.length];
        for (int i = 0; i < rentries.length; ++i) {
            EnrollOrPollCertsResponse.Entry respEntry = rentries[i];
            ErrorEntry error = respEntry.getError();
            certResponses[i] = error != null ? new CertResponse(new ASN1Integer(respEntry.getId()), CmpResponder.buildPKIStatusInfo(error.getCode(), error.getMessage())) : this.postProcessCertInfo(new ASN1Integer(respEntry.getId()), requestor, respEntry.getCert(), respEntry.getPrivateKey());
        }
        CMPCertificate[] caPubs = null;
        byte[][] extraCerts = resp.getExtraCerts();
        if (extraCerts != null && extraCerts.length > 0) {
            caPubs = new CMPCertificate[extraCerts.length];
            for (int i = 0; i < extraCerts.length; ++i) {
                caPubs[i] = new CMPCertificate(Certificate.getInstance((Object)extraCerts[i]));
            }
        }
        return new CertRepMessage(caPubs, certResponses);
    }

    private PKIBody unRevokeCertificates(RevReqContent rr, boolean revoke, AuditEvent event) throws IOException, SdkErrorResponseException {
        SingleCertSerialEntry[] respEntries;
        RevokeCertsResponse resp;
        RevokeCertsRequest req;
        RevDetails[] revContent = rr.toRevDetailsArray();
        if (revContent == null || revContent.length == 0) {
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "no entry is specified");
        }
        ArrayList<RevokeCertsRequest.Entry> revokeEntries = revoke ? new ArrayList<RevokeCertsRequest.Entry>(revContent.length) : null;
        ArrayList<BigInteger> unrevokeEntries = revoke ? null : new ArrayList<BigInteger>(revContent.length);
        X500Name issuer = null;
        byte[] aki = null;
        for (RevDetails revDetails : revContent) {
            CertTemplate certDetails = revDetails.getCertDetails();
            X500Name tIssuer = certDetails.getIssuer();
            if (tIssuer == null) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer is not present");
            }
            if (issuer == null) {
                issuer = tIssuer;
            } else if (!issuer.equals((Object)tIssuer)) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "not all issuers are of the same");
            }
            if (certDetails.getSerialNumber() == null) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "serialNumber is not present");
            }
            BigInteger serialNumber = certDetails.getSerialNumber().getValue();
            if (certDetails.getSigningAlg() != null || certDetails.getValidity() != null || certDetails.getSubject() != null || certDetails.getPublicKey() != null || certDetails.getIssuerUID() != null || certDetails.getSubjectUID() != null) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "only version, issuer and serialNumber in RevDetails.certDetails are allowed, but more is specified");
            }
            if (certDetails.getExtensions() != null) {
                Extension ext;
                Extensions exts = certDetails.getExtensions();
                ASN1ObjectIdentifier[] oids = exts.getCriticalExtensionOIDs();
                if (oids != null) {
                    for (ASN1ObjectIdentifier oid : oids) {
                        if (Extension.authorityKeyIdentifier.equals((ASN1Primitive)oid)) continue;
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "unknown critical extension " + oid.getId());
                    }
                }
                if ((ext = exts.getExtension(Extension.authorityKeyIdentifier)) != null) {
                    AuthorityKeyIdentifier tAki = AuthorityKeyIdentifier.getInstance((Object)ext.getParsedValue());
                    if (tAki.getKeyIdentifier() == null) {
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "issuer's AKI not present");
                    }
                    if (aki == null) {
                        aki = tAki.getKeyIdentifier();
                    } else if (!Arrays.equals(aki, tAki.getKeyIdentifier())) {
                        return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "not all AKIs are of the same");
                    }
                }
            }
            if (revoke) {
                Instant invalidityDate = null;
                CrlReason reason = null;
                Extensions crlDetails = revDetails.getCrlEntryDetails();
                if (crlDetails != null) {
                    ASN1ObjectIdentifier extId = Extension.reasonCode;
                    ASN1Encodable extValue = crlDetails.getExtensionParsedValue(extId);
                    if (extValue != null) {
                        int reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
                        reason = CrlReason.forReasonCode((int)reasonCode);
                    }
                    if ((extValue = crlDetails.getExtensionParsedValue(extId = Extension.invalidityDate)) != null) {
                        try {
                            invalidityDate = ASN1GeneralizedTime.getInstance((Object)extValue).getDate().toInstant();
                        }
                        catch (ParseException ex) {
                            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x100000, "invalid extension InvalidityDate");
                        }
                    }
                }
                if (reason == null) {
                    reason = CrlReason.UNSPECIFIED;
                }
                event.addEventData("reason", (Object)reason);
                revokeEntries.add(new RevokeCertsRequest.Entry(serialNumber, reason, invalidityDate));
            } else {
                unrevokeEntries.add(serialNumber);
            }
            event.addEventData("serial", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
        }
        X500NameType issuerType = new X500NameType(issuer);
        if (revoke) {
            req = new RevokeCertsRequest(null, issuerType, aki, revokeEntries.toArray(new RevokeCertsRequest.Entry[0]));
            resp = this.sdk.revokeCerts(req);
            respEntries = resp.getEntries();
        } else {
            req = new UnsuspendOrRemoveCertsRequest(null, issuerType, aki, unrevokeEntries.toArray(new BigInteger[0]));
            resp = this.sdk.unsuspendCerts((UnsuspendOrRemoveCertsRequest)req);
            respEntries = resp.getEntries();
        }
        GeneralName caGn = new GeneralName(issuer);
        RevRepContentBuilder repContentBuilder = new RevRepContentBuilder();
        for (SingleCertSerialEntry m : respEntries) {
            ErrorEntry error = m.getError();
            PKIStatusInfo status = error == null ? new PKIStatusInfo(PKIStatus.granted) : CmpResponder.buildPKIStatusInfo(error.getCode(), error.getMessage());
            repContentBuilder.add(status, new CertId(caGn, m.getSerialNumber()));
        }
        return new PKIBody(12, (ASN1Encodable)repContentBuilder.build());
    }

    @Override
    protected PKIBody confirmCertificates(String caName, ASN1OctetString transactionId, CertConfirmContent certConf) throws SdkErrorResponseException {
        CertStatus[] certStatuses = certConf.toCertStatusArray();
        ConfirmCertsRequest.Entry[] entries = new ConfirmCertsRequest.Entry[certStatuses.length];
        for (int i = 0; i < entries.length; ++i) {
            int status;
            CertStatus certStatus = certStatuses[i];
            PKIStatusInfo statusInfo = certStatus.getStatusInfo();
            boolean accept = true;
            if (statusInfo != null && 0 != (status = statusInfo.getStatus().intValue()) && 1 != status) {
                accept = false;
            }
            entries[i] = new ConfirmCertsRequest.Entry(accept, certStatus.getCertReqId().getValue(), certStatus.getCertHash().getOctets());
        }
        ConfirmCertsRequest sdkReq = new ConfirmCertsRequest(Hex.encode((byte[])transactionId.getOctets()), entries);
        this.sdk.confirmCerts(caName, sdkReq);
        return new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
    }

    @Override
    protected PKIBody revokePendingCertificates(String caName, ASN1OctetString transactionId) throws SdkErrorResponseException {
        this.sdk.revokePendingCerts(caName, Hex.encode((byte[])transactionId.getOctets()));
        return new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
    }

    @Override
    protected PKIBody cmpEnrollCert(String caName, String dfltCertprofileName, boolean groupEnroll, PKIMessage request, PKIHeaderBuilder respHeader, PKIHeader reqHeader, PKIBody reqBody, Requestor requestor, ASN1OctetString tid, AuditEvent event) throws InsufficientPermissionException, SdkErrorResponseException {
        InfoTypeAndValue tv;
        PKIBody respBody;
        if (dfltCertprofileName != null) {
            dfltCertprofileName = dfltCertprofileName.toLowerCase(Locale.ROOT);
        }
        Duration confirmWaitTime = this.cmpControl.getConfirmWaitTime();
        int type = reqBody.getType();
        try {
            switch (type) {
                case 0: {
                    this.checkPermission(requestor, Requestor.Permission.ENROLL_CERT);
                    CertReqMessages cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    CertRepMessage repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, cr, event);
                    respBody = new PKIBody(1, (ASN1Encodable)repMessage);
                    break;
                }
                case 2: {
                    this.checkPermission(requestor, Requestor.Permission.ENROLL_CERT);
                    CertReqMessages cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    CertRepMessage repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, cr, event);
                    respBody = new PKIBody(3, (ASN1Encodable)repMessage);
                    break;
                }
                case 7: {
                    this.checkPermission(requestor, Requestor.Permission.REENROLL_CERT);
                    CertReqMessages kur = CertReqMessages.getInstance((Object)reqBody.getContent());
                    CertRepMessage repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, kur, event);
                    respBody = new PKIBody(8, (ASN1Encodable)repMessage);
                    break;
                }
                case 4: {
                    this.checkPermission(requestor, Requestor.Permission.ENROLL_CERT);
                    respBody = this.processP10cr(caName, dfltCertprofileName, requestor, tid, reqHeader, GatewayUtil.parseCsrInRequest(reqBody.getContent()), event);
                    break;
                }
                case 13: {
                    this.checkPermission(requestor, Requestor.Permission.ENROLL_CROSS);
                    CertReqMessages cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    CertRepMessage repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, cr, event);
                    respBody = new PKIBody(14, (ASN1Encodable)repMessage);
                    break;
                }
                default: {
                    throw new IllegalStateException("should not reach here");
                }
            }
        }
        catch (IOException | OperationException e) {
            LogUtil.error((Logger)LOG, (Throwable)e);
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, null);
        }
        if (!this.cmpControl.isConfirmCert() && CmpUtil.isImplicitConfirm((PKIHeader)reqHeader)) {
            tv = CmpUtil.getImplicitConfirmGeneralInfo();
        } else {
            Instant now = Instant.now();
            respHeader.setMessageTime(new ASN1GeneralizedTime(Date.from(now)));
            tv = new InfoTypeAndValue(CMPObjectIdentifiers.it_confirmWaitTime, (ASN1Encodable)new ASN1GeneralizedTime(Date.from((Instant)confirmWaitTime.addTo(now))));
        }
        respHeader.setGeneralInfo(tv);
        return respBody;
    }

    @Override
    protected PKIBody cmpUnRevokeCertificates(String caName, PKIMessage request, PKIHeaderBuilder respHeader, PKIHeader reqHeader, PKIBody reqBody, Requestor requestor, AuditEvent event) throws SdkErrorResponseException {
        RevReqContent rr = RevReqContent.getInstance((Object)reqBody.getContent());
        RevDetails[] revContent = rr.toRevDetailsArray();
        if (revContent == null || revContent.length == 0) {
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "no entry is specified");
        }
        Requestor.Permission requiredPermission = null;
        boolean allRevdetailsOfSameType = true;
        for (RevDetails revDetails : revContent) {
            ASN1ObjectIdentifier extId;
            ASN1Encodable extValue;
            Extensions crlDetails = revDetails.getCrlEntryDetails();
            int reasonCode = CrlReason.UNSPECIFIED.getCode();
            if (crlDetails != null && (extValue = crlDetails.getExtensionParsedValue(extId = Extension.reasonCode)) != null) {
                reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
            }
            if (reasonCode < 0 || reasonCode > 10 || reasonCode == 7) {
                return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "invalid CRLReason " + reasonCode);
            }
            if (reasonCode == CrlReason.REMOVE_FROM_CRL.getCode()) {
                if (requiredPermission == null) {
                    event.addEventType("rr_unrevoke");
                    requiredPermission = Requestor.Permission.UNSUSPEND_CERT;
                    continue;
                }
                if (requiredPermission == Requestor.Permission.UNSUSPEND_CERT) continue;
                allRevdetailsOfSameType = false;
                break;
            }
            if (requiredPermission == null) {
                event.addEventType("rr_revoke");
                requiredPermission = Requestor.Permission.REVOKE_CERT;
                continue;
            }
            if (requiredPermission == Requestor.Permission.REVOKE_CERT) continue;
            allRevdetailsOfSameType = false;
            break;
        }
        if (!allRevdetailsOfSameType) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText("not all revDetails are of the same type"), new PKIFailureInfo(32)));
            return new PKIBody(23, (ASN1Encodable)emc);
        }
        try {
            this.checkPermission(requestor, requiredPermission);
        }
        catch (InsufficientPermissionException ex) {
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)"NOT_PERMITTED");
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 65536, null);
        }
        boolean revoke = requiredPermission == Requestor.Permission.REVOKE_CERT;
        try {
            return this.unRevokeCertificates(rr, revoke, event);
        }
        catch (IOException e) {
            LogUtil.error((Logger)LOG, (Throwable)e);
            return CmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, null);
        }
    }
}

