/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.conf;

import java.io.File;
import java.io.IOException;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.conf.PopControlConf;
import org.xipki.ca.sdk.SdkClientConf;
import org.xipki.security.Securities;
import org.xipki.util.Args;
import org.xipki.util.JSON;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class GatewayConf
extends ValidableConf {
    private SupportedProtocols protocols;
    private boolean logReqResp;
    private String reverseProxyMode;
    private PopControlConf pop;
    private SdkClientConf sdkClient;
    private Audits.AuditConf audit;
    private Securities.SecurityConf security;

    public static GatewayConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        GatewayConf conf = (GatewayConf)((Object)JSON.parseConf((File)new File(fileName), GatewayConf.class));
        conf.validate();
        return conf;
    }

    public boolean isLogReqResp() {
        return this.logReqResp;
    }

    public void setLogReqResp(boolean logReqResp) {
        this.logReqResp = logReqResp;
    }

    public String getReverseProxyMode() {
        return this.reverseProxyMode;
    }

    public void setReverseProxyMode(String reverseProxyMode) {
        this.reverseProxyMode = reverseProxyMode;
    }

    public PopControlConf getPop() {
        return this.pop;
    }

    public void setPop(PopControlConf pop) {
        this.pop = pop;
    }

    public SdkClientConf getSdkClient() {
        return this.sdkClient;
    }

    public void setSdkClient(SdkClientConf sdkClient) {
        this.sdkClient = sdkClient;
    }

    public Audits.AuditConf getAudit() {
        return this.audit;
    }

    public void setAudit(Audits.AuditConf audit) {
        this.audit = audit;
    }

    public Securities.SecurityConf getSecurity() {
        return this.security;
    }

    public void setSecurity(Securities.SecurityConf security) {
        this.security = security;
    }

    public SupportedProtocols getProtocols() {
        return this.protocols;
    }

    public void setProtocols(SupportedProtocols protocols) {
        this.protocols = protocols;
    }

    public void validate() throws InvalidConfException {
        GatewayConf.notNull((Object)this.protocols, (String)"protocols");
        GatewayConf.notNull((Object)this.audit, (String)"audit");
        GatewayConf.notNull((Object)this.pop, (String)"pop");
        GatewayConf.notNull((Object)this.sdkClient, (String)"sdkClient");
        GatewayConf.notNull((Object)this.security, (String)"security");
    }

    public static class SupportedProtocols {
        private boolean acme;
        private boolean cmp;
        private boolean est;
        private boolean rest;
        private boolean scep;

        public boolean isAcme() {
            return this.acme;
        }

        public void setAcme(boolean acme) {
            this.acme = acme;
        }

        public boolean isCmp() {
            return this.cmp;
        }

        public void setCmp(boolean cmp) {
            this.cmp = cmp;
        }

        public boolean isEst() {
            return this.est;
        }

        public void setEst(boolean est) {
            this.est = est;
        }

        public boolean isRest() {
            return this.rest;
        }

        public void setRest(boolean rest) {
            this.rest = rest;
        }

        public boolean isScep() {
            return this.scep;
        }

        public void setScep(boolean scep) {
            this.scep = scep;
        }
    }
}

